
/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	externs.h : Header file

	Contains extern declarations that are almost universally needed
	by all CORAL source code.

 ***********************************************************************/

#ifndef CORAL_EXTERNS_H
#define CORAL_EXTERNS_H

#include "config.h"
#include "collection.h"
#include "cor_error.h"
#include "interface.h"

#ifdef __GNUC__
#include <stdlib.h>
#else
#include <sysent.h>
#endif

#define NilArg NilSymbol

#define nested_set_arity 1

#define numpredsinsip(s)  (s)->count()
#define firstpredinsip(s) (s)->next(-1)
#define nextpredinsip(s,p) (s)->next(p)
#define allargsfree(b) ( (b)->next(-1) < 0 )


// Globals used by the parsing and rule interpretation phase

extern class ParserStruct;

EXTERN void exit ARGS((int));
EXTERN int atoi ARGS((CONST char*));
#ifndef __GNUC__
EXTERN void free ARGS((Pointer));
#endif

/* defined in dump-rule.C */
extern void dump_eval_rule (char *proc_name, Clause *rule);
extern void dump_rule_pointers (FILE *);
extern void dump_name_ref (Name name, FILE *file);

/* defined in unparse.C */
//extern void unparse();
extern void print_rule (Clause *rule, FILE *file);
extern void print_pred (Literal *pred, FILE *file, int head=0);
extern void print_adornment(BitVector& a, FILE *file);

/* defined in util.C */
extern Literal * AllocLiteral(ParserStruct&, Name name, int arg_count);
extern Predicate *FindPredicate ARGS((ParserStruct&, Name name, int arity)); 
     // Find /Allocate

extern Predicate *LookupPredicate ARGS((ParserStruct&, Name name, int arity));
     // Find / NULL

extern void AddClauseToPredicate ARGS((Predicate *predicate, Clause *clause));
extern struct rule *copy_rule ARGS((struct rule *prototype));
extern void alloc_preds ARGS((struct rule *rule, int count));
extern void add_to_array ARGS((struct array *a, int x));
extern Literal *copy_pred ARGS((Literal*));
extern struct Relation * AllocRelation(Name name, int arity, 
				int delta_indexed = -1);
extern int ConvertAdornment(BitVector&, char *adorn_string, int adorn_length);
extern void init_coral(char *pgm = NULL) ;
extern void exit_coral() ;
extern int DisplayFile(char *) ;
extern FILE *trace_file ;

/* defined in hashtab.c */
extern struct SymbolTable *
       InitTab (struct SymbolTable *tab, int n, Pointer defaultVal);

/* defined in arg.C */

extern ArgList* SimplifyVars(BindEnv *, int num_vars, Symbol** rul_var_names);


extern int using_return_unify();	// in annotations.C

/* defined in interp.C */
class Table;
typedef Table *TablePtr;
/* extern TablePtr TableStack[]; */
extern TablePtr * TableStack;
extern int TableStackCount;
/* points to the current moduleInfo defaults */
extern ModuleInfo *CurrModuleInfo;

#define USING_RETURN_UNIFY (CurrModuleInfo->UseReturnUnify)

#endif /*!CORAL_EXTERNS_H*/
