/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	derived-rel.h : Header file

	Defines an interative relation, i.e. a derived relation.
	Each DerivedRelation is associated with an DerivedMethod,
	which provides a means of executing the rules that define
	the derived relation.

	Contains the following class/type  declarations	 :
	  DerivedRelation
	  DerivedMethod

 ***********************************************************************/

#ifndef CORAL_DERIVED_REL_H
#define CORAL_DERIVED_REL_H

#include "generic-rel.h"
#include "bitvector.h"
#include "interp.h"


typedef Relation * (*InterpDerivedSolver)(QFModuleData *md, 
					    Relation *magic,
					    int old_magic_relation,
					    TupleIterator* iterator=NULL);

typedef Relation * (*CompiledDerivedSolver)(Relation* magic);

// Map adornment to a routine for solving a query with that adornment.
struct DerivedMethod {
    DerivedMethod* next;
    BitVector& adornment;
    InterpDerivedSolver interp_solver;
    CompiledDerivedSolver compiled_solver;
    QFModuleData *md ;           // Redundant when using the compiled form 
    int valid_method;
    DerivedMethod(Name, BitVector&, InterpDerivedSolver, QFModuleData *) ;
    DerivedMethod(Name, BitVector&, CompiledDerivedSolver);
    ~DerivedMethod();
};

class DerivedRelation : public Relation {
  public:
    DerivedRelation(Name name, int arity);
    DerivedRelation() { }
    ~DerivedRelation();
    DerivedMethod *methods;
    virtual BindEnv *get_next(TupleIterator&);
    virtual Tuple  *get_next_tuple(TupleIterator& it) ;
    virtual void release(TupleIterator&);
    virtual void print_name(FILE *file);
    virtual void print_facts(FILE *file, ArgList *arglist = NULL) const ;
    virtual int insert_new(ArgList& args, BindEnv* env,
				BindEnv *dont_rename_env = NULL,
				Tuple *parent_goal = NULL,
				int dont_rename = 0); 
    virtual void empty_relation(int ) { };
};

#endif /* !CORAL_DERIVED_REL_H */
