/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	cor_error.h : Header file

	Set of constants that define error conditions in CORAL.

 ***********************************************************************/

#ifndef CORERROR_H
#define CORERROR_H

// err_codes are defined below.
// msg is any additional error message to be printed
// fn_name is the name of the function calling CORAL_error.
extern void CORAL_error(int err_code, char *msg, char *fn_name) ;


// WARNING : These two constants will have to be redefined as the
// number of constants increases !
#define WARNING_MESSAGE_INDEX  30
#define ERROR_TABLE_SIZE 50

#define COR_OK                  0

// Errors in program definition syntax
#define COR_BAD_SYNTAX            -1
#define COR_BAD_ANNO              -2
#define COR_QUIT_IN_MODULE        -3

// Errors during execution
#define COR_NOT_IMPLEMENTED       -4
#define COR_BAD_TUPLE_INSERT      -5
#define COR_BAD_EMPTY_REL         -6
#define COR_BAD_ARGLIST           -7
#define COR_BAD_ARG_TYPE          -8
#define COR_NON_NUMERIC_ARGS      -9
#define COR_NON_NUMERIC_COMP      -10
#define COR_BAD_ARITY             -11
#define COR_BAD_REL_NAME          -12
#define COR_BAD_GLOBAL_VAR        -13
#define COR_EMPTY_ARGLIST         -14
#define COR_NON_STRING_ARG        -15
#define COR_FILE_NOT_FOUND        -16
#define COR_FAILED_COMMAND        -17
#define COR_NESTED_SET_NOT_GROUND -18
#define COR_BAD_SCHEMA            -19
#define COR_TOO_MANY_ARGS	  -20
#define COR_INDEX_ERR             -21
#define COR_BAD_TUPLE             -22
#define COR_ESM_ERR               -23
#define COR_MULTIPLE_DB_ERR       -24
#define COR_GROUPING_ON_RHS       -25

#define COR_NO_MEMORY             -28
#define COR_INTERNAL_ERROR            -(WARNING_MESSAGE_INDEX - 1)

// Warnings
#define COR_REL_NOT_FOUND          -(WARNING_MESSAGE_INDEX)
#define COR_CANNOT_OPEN_FILE       -(WARNING_MESSAGE_INDEX+1)
#define COR_SIGNAL_RECEIVED        -(WARNING_MESSAGE_INDEX+2)
#define COR_DUP_SCHEMA             -(WARNING_MESSAGE_INDEX+3)

#endif /* !CORERROR_H */
