/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	collection.h : Header file

	Declarations for a structure to handle collections of objects
	in an easy fashion. It is used to handle the collection of rules
	generated by the parser while parsing the rules in a module.

	Contains the following class/type  declarations	 :
	  struct collection

 ***********************************************************************/

#ifndef COLLECTION_H
#define COLLECTION_H
#include "hash.h"
#include "rules.h"

/* Macros for iterating over collections of rules:
 * Example usage:
 * FOR_EACH_RULE(rule, ruleset) {
 *     do_someting(rule);
 * } END_EACH_RULE
 * The curly braces are optional, but otherwise tools which
 * do program indentation (e.g. Emacs C-mode) do the wrong thing.
 * Note: 'struct rule *rule' is implicitly declared by the macros.
 * 'ruleset' is a (pointer to) a 'struct collection' of rules.
 */

#define FOR_EACH_RULE(RULE, RULESET)\
  { struct rule *RULE = (struct rule*)(RULESET)->chain;\
    for ( ; RULE; RULE = (struct rule*)RULE->link.next) {

/*
 * Iterate over query+rules 
 */
#define FOR_ALL_RULES(RULE)\
  { struct rule *RULE = parserStruct.rule_list;\
    for ( ; RULE; RULE = (struct rule*)RULE->link.next) {

/* Iterate over RULESET (which must be hashable),
 * selecting only rules whose head match teh name PRED.
 */
#define FOR_EACH_RULE_FOR(RULE, PRED, RULESET)\
  { struct rule *RULE; Name NAME = PRED;\
    Association *PTR = SymbolLookup((RULESET)->tab, NAME);\
    if (HashNone(PTR->arg)) RULE = NULL;\
    else RULE = (struct rule*)PTR->val;\
    for (;RULE && RULE->link.name==NAME; RULE = (struct rule*)RULE->link.next){

#define END_EACH_RULE }}

/** the following four #define's are because FOR_EACH_RULE, etc. are being
 ** misused to store collections of predicates rather than rules.
 ** NOTE: this is a hack, and should be cleaned up to properly use
 ** predicate structures rather than rule structures.
**/

#define FOR_EACH_PRED FOR_EACH_RULE
#define FOR_ALL_PREDS FOR_ALL_RULES
#define FOR_EACH_PRED_FOR FOR_EACH_RULE_FOR
#define END_EACH_PRED END_EACH_RULE

EXTERN void init_collection ARGS((struct collection*, int));
EXTERN void add_member ARGS((Link *member, struct collection *collection));
EXTERN Link * pop_member ARGS((struct collection *collection));
EXTERN void add_rule ARGS((struct Clause*, struct collection*));

/*
 * A collection is a set (list) of struct that contain 'Link' fields.
 * An object can be in at most one collection.
 * A collection is linked in a linear list (using the 'next' field of
 * each link, and head by the 'chain' field of the collection).
 * A collection can optionally be hashed, in which case
 * all objects with the same link->name are consequtive in the list.
 * Objects (in a hashed colection) can be accessed by the 'tab' hash table,
 * which is indexed on each link's name field. Because there can be multiple
 * objects with the same name, the hash table points to the
 * first such object. Subsequent ones can be found by following
 * the 'next' field (until next is NULL or next->name differs).
 */
struct collection {
    struct SymbolTable tab[1]; /* hash table */
    Link *chain; /* list of rules (linked by each rule's next field) */
    Link **lastptr;
    int count;
    int hashable;
};

#endif /*!COLLECTION_H*/
