/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	bitvector.h : Header file
	A bitvector is an array of bits whose length is given by the 'length'
	field. Bit 'i' is true iff:
	    words[i>>BIT_VECTOR_WORD_LOG] & (1<<(i & BIT_VECTOR_WORD-1)).
	If length<=BIT_VECTOR_WORD, words == &word0;
	otherwise words points to a malloc'd buffer.

	Contains the following class/type  declarations	 :
	  BitVector

 ***********************************************************************/

#ifndef BITVECTOR_H
#define BITVECTOR_H

#define BIT_VECTOR_WORD 32
#define BIT_VECTOR_WORD_LOG 5 /* log2(BIT_VECTOR_WORD) */
typedef unsigned long BitWord;

struct BitVector {
  private:
    inline BitWord * words()
	{ return length <= BIT_VECTOR_WORD ? &u.word0 : u.words; }

  public :
    int		length;
    union {
	BitWord	*words;      // if length > BIT_VECTOR_WORD 
	BitWord	word0;
    } u;

    void init() { length = 0; u.word0 = 0; }
    void init(int len) { init(); setlen(len); }
    void init(BitVector&);

    BitVector() { init(); }
    BitVector(int len) { init(len); }
    BitVector(int l, BitWord w) { length = l; u.word0 = w; }
    BitVector(int l, BitWord* wp) { length = l; u.words = wp; }
    BitVector(BitVector& bv) { init(bv); } // Copy constructor.
    ~BitVector();

    void clear(); // Make all bits false, without adjusting length
    void setlen(int l); // Change length to 'l'
    void set(int index, int value = 1); // Set bit 'index' to 'value'

    // Return 1 iff bit 'index' is true.
    inline int test(int index) const
      {
	if (index >= length) return 0;
	else if (length <= BIT_VECTOR_WORD) {
		return (u.word0 & (1<<(index & BIT_VECTOR_WORD-1))) ? 1 : 0;
	}
	else { return (u.words[index>>BIT_VECTOR_WORD_LOG] & 
			(1<<(index & BIT_VECTOR_WORD-1))) ? 1 : 0;
	}
      }

    int next(int i) const; // Return next true bit, after 'i'; or -1 if none.
    int count() const; // Return number of true bits.
    int any(); // True if any bit is true.
    inline int len() const { return length; }
    void printon(FILE* file); // Print on 'file' using format "110010"

    inline int operator[](int index) { return test(index); }
    int operator==(BitVector& b2); // True iff '*this' and 'b2' are equal.
    int operator&(BitVector& b2); // True iff both args have common true bits.
    void operator=(BitVector& b2);
    void or_bits(BitVector *b); // Set all bits in this that are set in *b
    int implies(BitVector& b2); // True iff all set bits in this are set in b2
};

#define BITVECTOR_TEST(bv,index)	 				\
	( ((index) >= (bv)->length) ? 0: 					\
	    ((bv)->length <= BIT_VECTOR_WORD) ?				\
		(( (bv)->u.word0 & (1<<((index) & BIT_VECTOR_WORD-1))) ? 1 : 0 )\
	      : ( ((bv)->u.words[(index)>>BIT_VECTOR_WORD_LOG] & 	\
		(1<<((index) & BIT_VECTOR_WORD-1))) ? 1 : 0) )
#endif /*!BITVECTOR_H*/
