\begin{tt}
\begin{verbatim}

/*
 * Example of a C++ program that uses declarative CORAL.
 */

#include <stdio.h>

main(int argc, char**argv)
{
  int i = 2; double j = 4.23;
  printf("hello there\n");
  init_coral(argv[0]);

  for (i = 0; i < 3; i++) {
    fprintf(stderr, "entering iteration %d\n", i);
    /*
     * here is the embedded CORAL code !
     *
     * note that the start and end markers must each be
     * on a separate line that has no other non-whitespace
     * characters. 
     *
     * Each time through the loop, the parameter i
     * that is passed to the declarative CORAL code will
     * vary, while j remains the same. Hence the query
     * ?grows(X,Y) will give successively increasing answers
     * as more facts are added to the grows() relation.
     * The query ?static(X,Y) returns the same answer each
     * time through the loop.
     */

    \[
      grows(($int)$i, 1).
      static(2, ($double)$j).
      ?grows(X,Y).
      ?static(X,Y).
        \]
  }
  printf("bye there\n");
  exit_coral();
}

\end{verbatim}
\end{tt}
