
\begin{tt}
\begin{verbatim}

module extens_eg2.
export cumsum(bf).

% Adds up the elements of input array, and stores the cumulative sum 
% of elements 0 through I in the I+1 st element of the result array.
% The destructive-assignment array data structure is used.
% A sample session is included below:
%
%---------------------------------
% store(X) := array(X,5), bind(X,0,0), bind(X,1,1), bind(X,2,2), bind(X,3,3),
%        bind(X,4,4).   
% consult(extens2.P).
% ?store(X), cumsum(X,Y).
%
%----------------------------------

% Just as a contrast to extens_eg1, this is written with materialized 
% evaluation in mind.  (Pipelining will lead to non-termination.)

cumsum(OldArray,NewArray) :- array(OldArray,Size),
	 	tempcumsum(OldArray,Size, NewArray,Size-1).

tempcumsum(OldArray,Size, NewArray,0) :- newzeroedarray(NewArray,Size), 
         lookup(OldArray,0,V1), bind(NewArray,0,V1).
tempcumsum(OldArray,Size, NewArray,I+1) :- 
		tempcumsum(OldArray,Size, NewArray,I),
		I < Size,
               	lookup(OldArray,I+1,Val),
               	lookup(NewArray,I,Sum),
               	bind(NewArray,I+1,Sum+Val).

newzeroedarray(NewArray,Size) :- array(NewArray,Size),
		bindzero(NewArray,Size,Size).

bindzero(NewArray,Size,0) :- Size > 0, bind(NewArray,0,0).
bindzero(NewArray,Size, I+1) :- bindzero(NewArray,Size,I), I < Size,
		bind(NewArray,I,0).

end_module.



\end{verbatim}
\end{tt}

