
/*
 * Example of a builtin relation definition that is to be incrementally loaded.
 * This builtin demonstrates the use of Arg * to allow arbitrary CORAL
 * structured arguments to be manipulated by user-defined code.
 */

#include <stdio.h>

/*
 * The builtin sum_list(X, Y) takes a list X as its first argument and 
 * returns the summation of the list in the second argument.
 */

_coral_export int sum_list(Arg *);

int sum_list(Arg *input_list)
{
  int sum = 0;
  Arg *list_head;
  Arg *list_tail;

  /* check that the input argument is indeed a non-empty list */
  if (!input_list || !is_list(input_list)) 
    return 0;

  /* iterate through the list, summing the elements */
  while (1) {

    list_head = make_car(input_list);

    /* break out of the loop at the end of the list */
    if (!(list_tail = make_cdr(input_list))) break;;

    /* check that each list element is an integer */
    if (!list_head || !is_int(list_head)) {
      fprintf(stderr, "WARNING ! : non-integer list member \n");
      fprintf(stderr, "Sum so far is %d\n", sum);
      return -1;
    }

    sum += make_int(list_head);
    input_list = list_tail;
  }

  return sum;
}

