

\begin{tt}
\begin{verbatim}

module declse_eg7a.
export bom(bf,ff).

/* This program computes the total cost of a composite part by summing
the total costs of its subparts.  This is often called the bill-of-materials
problem. Note that the program is not stratified.  It will work correctly as
long as the assembly relation is acyclic (i.e. the part-subpart relationship,
closed transitively, is acyclic).  There are input data sets in declse7.F 
and declse72.F */

bom(Part,sum(<C>)) :- subpart_cost(Part,SubPart,C).

subpart_cost(Part,Part,Cost) :- basic_part(Part,Cost).
subpart_cost(Part,Subpart,Cost) :- assembly(Part,Subpart,Quantity), 
	bom(Subpart, TotalSubcost),
	Cost = Quantity * TotalSubcost.

end_module.

\end{verbatim}
\end{tt}


