


module seqanal5.

@index_deltas-.
@multiset.
@check_subsumption swing[bffff].
@check_subsumption avgvalue[bbbf].
@check_subsumption diff[bbbff].

export swing(bffff), avgswing(bbbf), countswings(bbbf), avgvalue(bbbf), 
	avgdiff(bbbf), diff(bbbff).

/* run is defined in run.P  */

/* Several measures of volatility are defined below.  The input is in seq1.F
and seq2.F */

/* Measures magnitude of each up or down swing.  */

swing(Sname,Date,nondec,L,V) :- run(Sname,Date,nondec,L),
	sequence(Sname,Date,V1), sequence(Sname,Date+L,V2), V=V2-V1.

swing(Sname,Date,dec,L,V) :- run(Sname,Date,dec,L),
	sequence(Sname,Date,V1), sequence(Sname,Date+L,V2), V=V1-V2.

/* Measures the average swing in the period from D1 to D2.  */

avgswing(Sname,D1,D2,A) :- 
	sumswings(Sname,D1,D2,S), countswings(Sname,D1,D2,C), A=S/C.

sumswings(Sname,D1,D2,sum(<V>)) :- 
	swing(Sname,Date,_,_,V), D1<=Date, Date<=D2.

countswings(Sname,D1,D2,count(<V>)) :- 
	swing(Sname,Date,_,_,V), D1<=Date, Date<=D2.


/*  The average value in the period D1 to D2.  */

avgvalue(Sname,D1,D2,A) :- 
	sumvalues(Sname,D1,D2,S), countvalues(Sname,D1,D2,C), A=S/C.

sumvalues(Sname,D1,D2,sum(<V>)) :- 
	sequence(Sname,Date,V), D1<=Date, Date<=D2.

countvalues(Sname,D1,D2,count(<V>)) :- 
	sequence(Sname,Date,V), D1<=Date, Date<=D2.

/*  The daily difference wrt the average value.  */


diff(Sname,D1,D2,Date,V) :-
	sequence(Sname,Date,V1), D1<=Date, Date<=D2,
	avgvalue(Sname,D1,D2,A), V1 >= A, V=V1-A.

diff(Sname,D1,D2,Date,V) :-
	sequence(Sname,Date,V1), D1<=Date, Date<=D2,
	avgvalue(Sname,D1,D2,A), V1 < A, V=A-V1.

/*  The average of the daily difference.  */

avgdiff(Sname,D1,D2,A) :- 
	summdiffs(Sname,D1,D2,S), countdiffs(Sname,D1,D2,C), A=S/C.

summdiffs(Sname,D1,D2,sum(<V>)) :-
	diff(Sname,D1,D2,_,V).

countdiffs(Sname,D1,D2,count(<V>)) :-
	diff(Sname,D1,D2,_,V).

end_module.

