
module seqanal3.
export  peaks(bbff), cross(bbf).


/* Given sequences A and B, finds all peaks of A that 
immediately precede a crossover of A and B.  Input data in peaks1.F 
and peaks2.F.  */

@index_deltas-.
@multiset.
@factoring.

/* find points at which sequences A and B cross over */

cross(A,B,I) :- sequence(A,I,V1), sequence(A,I-1,V2),
	    sequence(B,I,V3), sequence(B,I-1,V4),
	    V2<V4, V1>=V3.

cross(A,B,I) :- sequence(A,I,V1), sequence(A,I-1,V2),
	    sequence(B,I,V3), sequence(B,I-1,V4),
	    V2>V4, V1<=V3.

/* tuple in t for all points immediately before a crossover
such that there is a decreasing subsequence of values until the crossover */

t(A,B,I,V) :- cross(A,B,I), sequence(A,I,V).
t(A,B,J,V) :- t(A,B,I,U), J=I-1, sequence(A,J,V), V>U.


/* finds all peaks of A that immediately precede a crossover of A and B */

peaks(A,B,I,U) :- t(A,B,I,U), J=I-1, sequence(A,J,V), V<=U.

end_module.
