/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	profile.h : Header file

	Declarations for all structures used to generate profiling
	information.

	Contains the following class/type  declarations	 :
	  ProfileInfo
 ***********************************************************************/

#ifndef CORAL_PROFILE_H
#define CORAL_PROFILE_H

#include <stdio.h>

typedef struct ProfileInfo ProfileInfo ;
extern ProfileInfo GlobalProfileInfo;

// This profile structure is associated with each rule.
struct ProfileInfo {
  int       i_newfacts ;     // Set in do_rule()
  int       i_unsuccesful ;  // ditto
  int       i_succesful ;    // ditto

  int       getnexts ;       // Set in get_next_tuple()
  int       non_unifying_tuples ; // ditto
  int       deleted_tuples ; 

  int       unifies ;        // Set in unify_args()
  int       subsumes ;       // Set in subsumes_args()

  char *    rule ;           // Contains the name of the current rule


  // Assigns the name string to this->rule
  inline void set_rule_name(char * name)  { rule = name;}

  // Prints the contents of the object preceded by the str
  void print(FILE *fd, char * str,
	     int *predOrders = NULL, int numpreds = 0) const ;
                                                  
  // Sets all object variablesto zero
  void clear() {
    i_unsuccesful = 0;
    i_succesful = 0;
    i_newfacts = 0;
    getnexts = 0;
    deleted_tuples = 0;
    non_unifying_tuples = 0;
    unifies = 0;
    subsumes = 0;
  }

  // Clears profile info
  void reset() { clear(); rule=NULL;} ;

  // Constructor used for individual rule info variables. The 'name' string 
  // contains the rule in string form
  inline ProfileInfo(char *name) { clear(); rule = name; } 

  // Constructor used for GlobalProfileInfo, where no string is assigned to
  // this->name
  inline ProfileInfo() { clear() ; rule = NULL; } 
};


#endif /* !CORAL_PROFILE_H */
