/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	linked-rel.h : Header file

	Declarations that define a linked relation, which is
	a relation implemented as a linked list.

	Contains the following class/type  declarations	 :
	  TupleList
	  LinkedRelation
	  LinkedRMark

 ***********************************************************************/

#ifndef CORAL_LINKED_REL_H
#define CORAL_LINKED_REL_H

#include "generic-rel.h"

// A TupleLink is used to chain Tuples together to form a LinkedRelation

// A TupleList is a list of Tuples (chained using TupleLink).

struct TupleList {
    TupleLink  *chain; // head of list of (Linked)Tuples
    TupleLink  **lastptr; // points to last pointer of list
    TupleList() { chain = NULL; lastptr = &chain; }
    inline void tlist_insert_tuple(Tuple  *tuple)
	{ if (!tuple->is_deleted()){ // only if tuple not deleted
		TupleLink *node = new TupleLink(tuple,NULL);
		*lastptr = node; lastptr = &node->next; }}
    void free_all();
};

class LinkedRMark : public RMark {
  public:
    TupleLink **lastptr;
		/* (*lastptr) points to a TupleLink.  The semantics of 
		   start and end marks is that tuples after (but not including)
		   the tuple of *(startmark.lastptr) are to be included, up to 
		   (and including) the tuple of *(endmark.lastptr).
		   If *(startmark.lastptr) == *(endmark.lastptr), no tuples
		   are included.
		*/
    LinkedRMark(TupleLink **l);
    LinkedRMark();
};

class LinkedRelation : public Relation, public TupleList {
  public:
    LinkedRelation(int _arity, int _delta = -1);
    virtual RMark * getMark();

    // The two virtual int insert's have been replaced by
    // a virtual int insert_tuple(Tuple *)

    virtual int insert_tuple(Tuple *tuple);

    // virtual int insert(ArgList&, int env_size);
    // virtual int insert(ArgList&, BindEnv *end, int env_size);

    virtual BindEnv *get_next(TupleIterator&);
    virtual Tuple *get_next_tuple(TupleIterator& it) ;
    virtual void release(TupleIterator& it) ;
    virtual int is_subsumed(Tuple *tuple, RMark *startmark= NULL,
					RMark *endmark= NULL);

    void free_linked_tuples();
    virtual void free_all() { TupleList::free_all(); }
    virtual void empty_relation(int deleteTuples=0);
			// See generic-rel.h for semantics of this fn
    virtual ~LinkedRelation() { free_all(); count = 0; }
};



#endif /* !CORAL_LINKED_REL_H */
