
/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	interp.h : contains header information for the code in interp.C
	that 'interprets' modules and generates data structures in which
	rules are stored, so that they can be executed to answer a query.

	Contains the following class/type  declarations	 :
	  Table
	  RelationStruct
	  RMarkArray
	  SemiNaive
	  SccInfo
	  QFModuleData
	  QFMaterializedModuleData
	  QFPipelinedModuleData

 ***********************************************************************/

#ifndef CORAL_INTERP_H
#define CORAL_INTERP_H

#include <stdio.h>
#include "externs.h"
#include "arg.h"
#include "generic-rel.h"
#include "profile.h"
#include "apply.h"
#include "globals.h"
#include "annotations.h"
/* #include "garray.h" */
#include <stdarg.h>

typedef struct RelationStruct RelationStruct ;
typedef struct Table Table ;
typedef struct RuleInfoArray RuleInfoArray ;
class QFModuleData ;
class QFMaterializedModuleData ;
typedef struct SccInfo SccInfo ;
typedef struct SemiNaive SemiNaive ;
typedef struct ModuleExecInfo ModuleExecInfo;

#ifndef COR_INTERPRETER
extern int do_rule(SemiNaive *sn) ;
#endif

typedef enum { COR_MATERIALIZED, COR_PIPELINED, COR_ORDSEARCH,} ModuleKind ;

// Contains a relation pointer and the name of the relation
struct RelationStruct {
  public : 

  Relation * relPtr ;
  Name       relName ;
  int        relArity ;

  RelationStruct(){ relPtr = NULL; relName = NULL; relArity = 0;};
  void AssignVal(Name name, int arity);
  void AssignRel(Relation *rel) { relPtr = rel ;} ;
};

extern class Context;	// 

// Array of relations for a module
struct Table {
  public :

  int            numRels ;
  RelationStruct *rels ;
  int            interrupt_flag;  // used by cut, and single answer
                                  // to interrupt execution of
				  // the current module  

  Context 	*context;	// the stack for ordered search
  QFModuleData  *moduledata;    // data about module 

  Table 	 *next;	// Keeps a list of free initialized table structs 
			// that can be reused.
  Table(int num_rels) 
      {rels=new RelationStruct[num_rels]; numRels=num_rels; context = NULL;};
  Table(Table *F) ;
  ~Table() {delete rels ; };
  void AddValue(int i, Name relName, int arity) ;

};

// Array of rule structures.
struct RuleInfoArray {
  public :

  RuleInfo ** rInfoPtrs ;
  int         numRules  ;

  RuleInfoArray();
  inline int num_rules() { return numRules ; } ;
  void AddRule(RuleInfo *rInfo);
  void printon(FILE *outf);
};


// Array of RMark structures
struct RMarkArray
{
  public :
// NOTE : We have a problem here, because RMarks cannot be statically
// declared, since their type depends on the type of the relation, that
// can only be found at run-time. This should be modified to allow each
// RMark * to point to an allocated RMark of the appropriate type. This
// saves on new() and delete() calls being executed repeatedly in the
// scc evaluation loop.

  RMark    **markList ;
  int        array_size ;

  RMarkArray(int size) ;
  ~RMarkArray() ;
  void New_To_Old(int i) ;

};

// Structure that represents each seminaive rule.
// Each seminaive rule contains the rule from which it is derived
// and also an implicit mechanism of specifying 'old' and 'new'
// relations for literals on the right hand side. This mechanism
// is via the markOffsets array which contains for each rhs literal
// a pair of offsets into an array of RMarks created at runtime.
// Pointers to NULL RMarks (offset of -1) signify that the predicate 
// is base w.r.t the seminaive rule, while for predicates that are recursive
// w.r.t. the seminaive rule, the markOffsets array entries point to RMarks
// that specify the portion of the concerned relation (old or new)
// that is to be considered. The successBacktrack and failureBacktrack
// arrays are used for intelligent backtracking.
struct SemiNaive {
  public :

  SccInfo    *scc ;         // scc to which it belongs
  ModuleKind  module_kind;  // Kind of module to which it belongs
                            // Either COR_ORDSEARCH or COR_MATERIALIZED
  RuleInfo   *rInfo    ;
  int         first    ;    // This field is generalised by predOrders
                            // and should be removed later.

  int        *markOffsets ; // Size of this array is rInfo->num_literals * 2
                            // This array contains offsets into an array of
                            // RMarks that is declared for each Scc at runtime.
                            // A value of -1 implies a NULL RMark ;

  int        *predOrders ;  // Size of this array is rInfo->num_literals
  int 	     *indices;      // Specifies for each literal the offset of the
			    // index that will be tried first for the literal.
			    //  Size of this array is rInfo->num_literals

  int        successBacktrack;
			    //  Used for intelligent backtracking and choice.
  int        *firstFailureBacktrack;
			    //  Size of this array is rInfo->num_literals
			    //  Used for get-first intelligent backtracking.
  int        *nextFailureBacktrack;
			    //  Size of this array is rInfo->num_literals
			    //  Used for get-first intelligent backtracking.

  int        recursive   ;
  int        ignore_this_rule ;  // if this flag is set, (when the execution
                                 // mode is supplementary magic with indexing)
				 // then this rule is ignored for evaluation.
				 // It is however used for scc analysis, etc.
				 // This flag is set only for rules of the
				 // form m_p() :- sup_i().

  SemiNaive() ;
  void Add_Rule_Info(SccInfo *, RuleInfo *, Clause *, int);
  void clean_cache();
  int evaluate(Table *F, RMarkArray *rm_array);
};

struct SccInfo {
  public :

  QFMaterializedModuleData  *module ;  // Module to which it belongs.
  Scc           *scc ;
  SemiNaive     *sn_rules ;      // Array of seminaive rules
  int            numSNRules ;
  Predicate    **pred_ptrs;      // Array of preds corresponding to the scc
  int            numPreds ;	 // number of preds in this SCC
  int            num_lowerPreds; // number of preds in all previous SCCs
  int           *offset_arr ;    // Offsets of preds in RMarkArray
                                 // Size of this is numPreds
  int           *sn_offset_arr ; // Positions of heads of sn rules in pred_ptrs
  int           *pred_success_arr; // Number of newtuples generated for
                                   // each predicate in the previous iteration
				   // size is : numPreds
  int           *sn_first_offsets; // Positions of the first rhs predicate
                                   // in the pred_success_arr
				   // size is : numSNRules
  int           rec_rule_start ; // Starting position of recursive rules
  int           has_hidden_relations; // True if any relation has a hidden
                                      // part due to prioritize

  SccInfo(ParserStruct&, QFMaterializedModuleData *md, Scc *scc) ;
  void Solve(Table *F, TupleIterator *iterator = NULL);
  void clean_cache() {
	if (sn_rules) sn_rules->clean_cache();
  }

  void clean_hidden_relations(Table *F);
  int iterateRecursiveRules(Table *F, RMarkArray *rm_Arr, int, int);
  private :
  void Create_SN_Structs(ParserStruct&) ;
  RMarkArray *setupSolve(Table *F);
  void display_annotation_info(Table *F);

};
  

// For each exported query form in a user-defined CORAL module, there is
// one QFModuleData structure created. The Solve() method provides a
// mechanism to evaluate the rules defined in the module. Each such
// structure is associated with its exported query form in a table
// of DerivedMethods (see derived-rel.h). QFModuleData is a generic
// class with subclasses for Materialzed and Pipelined modules.

// Sudarshan: This is a static data structure and should not contain
// any fields which differ across different calls to a module

class QFModuleData {
  public :
  Table             *F ;                 // Table for the query
  RuleInfoArray     *ruleArray ;         // Array of rules for the query form
  struct collection *rules ;             // Used for run_time initialisation
                                         // of rule pointers
  ModuleInfo	    module_info;
  PredAnnotations   *index_annotations;
  PredAnnotations   *multiset_annotations;
  PredAnnotations   *agg_sel_annotations;
  PredAnnotations   *prioritize_annotations;

  Predicate         *export_pred ;       // Predicate on which query is asked
  Table 	    *free_table_list;	 // List of (initialized) table structs
					 // that can be reused.
  RelationLink      *free_query_relations;
  RelationLink      *free_answer_relations;

  RelationOptions   rel_options;

  /** for explain  Tarun  **/
  RuleInfo          *curr_rInfo;

  virtual void Solve(Table *F, TupleIterator *iterator = NULL) = 0;

  // This may not be needed. I'm not sure. But I've put it in for now.
  virtual ModuleKind kindof() = 0;
};


class QFMaterializedModuleData : public QFModuleData {
  public :

  int                numSccs ;
  SccInfo          **sccArray ;          // Array of Sccs to evaluate in order
  int                use_psn ;           // Should the module use PSN or not

  // The following two fields are for the use of SaveModules
  // The first field "saved_state" distinguishes between the first 
  // call to a Savemodule and subsequent calls.
  // If the second field "no_magic" is set, only one call to Solve
  // needs to be made since the first call will completely evaluate
  // the save module.
  int 	             saved_state ;	 // has the state been saved already?
  int		     no_magic;

  QFMaterializedModuleData(Table *table, RuleInfoArray *rArray,
					ParserStruct&) ;
  void AddScc(ParserStruct&, Scc *scc) ;
  virtual void Solve(Table *F, TupleIterator *iterator = NULL) ;
  void clean_cache();
  virtual ModuleKind kindof() { return COR_MATERIALIZED; } ;
};


enum PredKind {
	QueryPredKind,
	MagicQueryPredKind,
	LocalPredKind,
	ExternalPredKind
};

#define RulePredKind(rule) ((enum PredKind)(rule)->last_part)
#define SetRulePredKind(rule, kind) (rule)->last_part = (int)(kind)

extern int get_offset(Table *F, Name name, int arity, int print_error = 1);
extern int get_offset(Table *F, Literal *pred, int print_error = 1);

#ifndef OFFSET_HACK
inline int get_offset(Table *F, Predicate *pred, int print_error = 1)
{
	return get_offset(F, pred->name, pred->arity, print_error) ;
}
#else

/*
 * WARNING: This code should only be called after predicates have been
 *   inserted into the frame table. */
inline int get_offset(Table *F, Predicate *pred, int print_error = 1)
{
	ASSERT((pred->frame_offset >= 0) &&
	(pred->frame_offset < F->numRels));
	return pred->frame_offset;
}
#endif

#endif /* !CORAL_INTERP_H */

