
module declad_eg4a.
export sort1(f).
@no_rewriting.

% In each iteration, the old sort1 fact is deleted and a new one, 
% containing exactly one new X-value from p (the least cost tuple), 
% is generated.  Clearly, no additional rewriting is to be performed.  
% Further, if either of these head deletes is omitted, the set of 
% answers changes.  This is a very operational program, and is 
% perhaps best viewed as a production-rule program.  The
% program works correctly if no two facts have the same cost.

sort1([]).
sort1([X|[C|L]]), del sort1(L), del p(X,C) :- 
			sort1(L), choose(C), p(X,C).

% The fixpoint evaluation uses the scc-by-scc optimization:
% predicates are divided into sccs, and are evaluated in scc-by-scc order.
% This has the advantage that at each stage, only a small number of
% rules is examined, and further, a predicate from a lower scc can be
% treated as a base predicate, i.e. assumed to be fully evaluated,
% in higher sccs --- an optimization that significantly reduces
% the number of ``semi-naive'' rules.  In this program, the following 
% (commented out) rule is evaluated just once, prior to application 
% of the sort1 rules.  However, for the program to work as intended, 
% this rule must be re-evaluated after each change to p.  This effect 
% is achieved by placing the rule in a separate module.  Again, the 
% operational nature of this program is underscored.

% choose(min(<C>)) :- p(X,C).

end_module.

module declad_eg4a2.
export choose(f).

choose(min(<C>)) :- p(X,C).

end_module.

% Sample data

p(a,1).
p(b,3).
p(c,2).
%p(d,2).	%  Add this fact and see what happens!
p(e,5).


module declad_eg4b.
export sort2(f).
@no_rewriting.

% In each iteration, the old sort2 fact is deleted and a new one, 
% containing exactly one new X-value from p (the least cost tuple), 
% is generated.  Clearly, no additional rewriting is to be performed.  
% Further, if either head delete is omitted, the set of answers changes.  
% This is a very % operational program, and is perhaps best viewed 
% as a production-rule program.  The prioritize annotation ensures 
% that scc-by-scc evaluation is overridden (i.e. the rules are 
% evaluated together), and that in each iteration,
% the q relation contains a single tuple, with the order in which the
% tuples are seen governed by the min(C) condition.

sort2([]).
sort2([X|[C|L]]), del sort2(L), del q(X,C) :- sort2(L), q(X,C).

% The effect of prioritize is to add exactly one least cost q tuple 
%to the delta in each iteration. (Additional q facts are made 
% available only when no facts can be derived without such an addition.)

@prioritize q(X,C) min(C).

% The following rule is needed since only derived predicates 
% can be prioritized.

q(X,C) :- p(X,C).

end_module.


module declad_eg4c.
export sort3(b).

%  This program takes a binary predicate name as input, and prints 
% the tuples in it, sorted by the second column. Again, there 
% is an operational flavor.

sort3(P) :- q(P,X,C), print(X,C).

@prioritize q(P,X,C) min(C).

q(P,X,C) :- member(P,X,C).

end_module.


