

\begin{tt}
\begin{verbatim}

module declad_eg8.
export coming(f).

/*  This program, due to Ross and Sagiv, illustrates monotonic programs.  
Some rather rude invitees inform the host that they will come only
if they are guaranteed that at least k other guests that they know
are going to come.  The irritated host can use the following program
to determine those guests to whom such a guarantee can be extended.  

The ``knows'' relation need not be acyclic; try this program with different
instances for this relation.  A sample input is in declad8.F */

@monotonic.

coming(X) :-  requires(X,0).
coming(X) :- requires(X,K), kc(X,N), N >= K.

% The monotonic annotation influences the following rule: intermediate
% kc facts could contain underestimates in the second column.  (An
% attempt to obtain an exact count --- which is done by default, in the 
% absence of the monotonic annotation --- would lead to an infinite
% loop if knows contains cycles.)

kc(X, count(<Y>)) :- knows(X,Y), coming(Y).


end_module.

\end{verbatim}
\end{tt}

