
\begin{tt}
\begin{verbatim}

module declad_eg6a.
export mincost(bbf), shortest_path(bbff).

/*  This program illustrates the use of aggregation.
The predicate mincost computes the cost of the shortest path between 
two points; shortest_path computes shortest paths between two points.  
Note that this program works even on cyclic graphs as long as there
are no negative cycles.  The reason is that the min operation in the 
aggregate selection retains only the current shortest paths.

Incidentally, note that making the definition of cost left-linear
would speed the program up.

The input for this program is an edge relation; sample inputs are
provided in files declad6.cyc.F and declad6.acyc.F.  */

cost(X,Y,C) :- edge (X,Y,C).
cost(X,Y,C) :- edge(X,Z,C1), cost(Z,Y,C2), C=C1+C2.

@aggregate_selection cost[bbf] (X,Y,C) (X,Y) min(C).

% The grouping in the following rule ensures that mincost contains, 
% for each X,Y pair, the actual least cost of a connecting path (and 
% not just the cost of a currently known least cost path).

mincost(X,Y,min(<C>)) :- cost(X,Y,C).

shortest_path(X,Y,C,[X,Y]) :- mincost(X,Y,C), edge(X,Y,C).
shortest_path(X,Y,C,[X|P]) :- mincost(X,Y,C), edge(X,Z,C1), 
			shortest_path(Z,Y,C2,P), C=C1+C2.

% The following annotation indicates that for a given cost, we only
% want one path between a given pair of points.

@aggregate_selection shortest_path[bbff] (X,Y,C,P) (X,Y,C) any(P).

end_module.

\end{verbatim}
\end{tt}

