
\begin{tt}
\begin{verbatim}

module declad_eg5b.
export min_spanning_tree2(bfff,ffff).

/*  Selects (in a non-deterministic manner) minimum cost spanning trees.
   	min_spanning_tree2(root, start, end, cost)
    is true if (start, end, cost) is an edge in a selected spanning 
    tree rooted at root.   Can also be queried with root free.

    At each step, the set of edges of the form (from,to) with `from' in
    the current spanning tree is examined.  Of these, the edges with the
    least cost are chosen and added to the tree, subject to an
    aggregate selection on min_spanning_tree that ensures that each 
    node has only one immediate predecessor in a tree.  
    In considering candidate edges for addition to the tree,
    previously chosen edges are ignored in order to allow
    more expensive edges to be considered; the @monotonic
    annotation ensures that the current set of `chosen'
    tuples is used in the negated literal.  (The default is
    to completely evaluate `chosen'; this would be
    inappropriate.)  This definition of `chosen' ensures
    that the current least cost edges are added to the tree at 
    each step.  Contrast this with the min_spanning_tree2 program,
    which is WRONG.

    Assumes a base relation edge(start, end, cost) 

*/ 

min_spanning_tree(R,nil,R,0) :- is_source(R).
min_spanning_tree(R,X,Y,C):- 
	min_spanning_tree(R,Z,X,C1), chosen(R,X,Y,C).

@aggregate_selection min_spanning_tree (R,X,Y,C) (R,Y) any(X,C).

is_source(R) :- edge(nil, R, _).

chosen(R,X,Y,C) :- candidate(R,X,Y,C), not chosen(R,X,Y,_).
candidate(R,X,Y,C) :- min_spanning_tree(R,_,X,_), edge(X,Y,C).

@monotonic.
@aggregate_selection chosen (R,X,Y,C) (R,X,Y) min(C).

end_module.


\end{verbatim}
\end{tt}
