
\begin{tt}
\begin{verbatim}

module declac_eg5a.

export anc(ff).

@allowed_adornments anc[ff].  % keeps the rewritten program simple; the
			      % adorned form anc_bf is not optimized.

/*  This program computes transitive closure.  We use it here to 
illustrate the indexing facilities in CORAL.  Actually, the index 
declarations in this program are not needed, since CORAL automatically 
generates them!  The goal here is to illustrate the syntax.  Inputs 
in declac1a.F and declac1b.F */

@make_index anc[ff] (bf).  % create an index on the first argument 
			   % of the derived predicate anc_ff 
			   % (automatically maintained as tuples are added.)

@make_index anc[ff] (X,Y) (X).	% means the same thing.  even if both 
				% these annotations are specified, 
				% only one copy of the index is created.

@index_deltas +.  	% states that the set of new anc tuples (delta) is to
			% be indexed.  (this is the default.)
			% run ?anc(X,Y) on the data in declac1a.F with
			% @index_deltas+ and @index_deltas- and see the difference!

anc(X,Y) :- parent(X,Y).
anc(X,Z) :- anc(X,Y), anc(Y,Z).

end_module.

\end{verbatim}
\end{tt}
