
module grades.


/*  The input for this program is file grades.F, which contains a relation
grades(LN,FN,SSN,Login,A1,A2,A3,A4,E1,E2,E3), which contains one record
per student, listing marks on four assignments, two mid-term 
exams, and a final exam.  For each, the marks entered are out of 100;
however, the four assignments together account for 35% of the grade,
the two midterms together account for 40%, and the final accounts for 25%. 

The input is in tabular form, in file grades.F,
and must be read in using the read_table command.  */


export print_totals(), % Illustrates use of the printf command; can also use write_table
			% command from the CORAL prompt to print a relation.  
			% No output commands are included for any of the other relations.
			% Compute the desired relation (which will print the tuples
			% on the screen in the form of variable bindings for each record),
			% and then use write_table to create a file.
	totals(ffffff), % Marks on assignments, on exams, and final total.
	classavgs(fff), % Class average on assignments, on exams, and final total.
	relperf(ffff),  % (Student's grade - Class average) on assignments, exams and total.
	finavg(f), finmax(f), finmin(f), % Final exam statistics.
	totmax(f), totmin(f), totavg(f). % Total statistics.


print_totals() :- 
	printf(" LN, 	FN, 	SSN,	A,	E,	T \n \n "),
	totals(LN,FN,SSN,A,E,T),
	printf(" %s,	 %s,	 %f,	 %f,	 %f,	 %f \n", LN,FN,SSN,A,E,T).


% Last name, First name, SSN, marks on Assignments (max 35), Exams (max 65), Total.

totals(LN,FN,SSN,A,E,T) :-
	grades(LN,FN,SSN,Login,A1,A2,A3,A4,E1,E2,E3), 
	A=((A1+A2+A3+A4)*0.25)*0.35, E=(((E1+E2)*0.5)*0.4 + (E3*0.25)), T=A+E.


% The following three relations are intermediate results.

temp1(sum(<A>)) :- totals(LN,FN,SSN,A,E,T). 
temp2(sum(<E>)) :- totals(LN,FN,SSN,A,E,T). 
temp3(count(<SSN>)) :- totals(LN,FN,SSN,A,E,T). 


% Class averages on assignments (35%), exams (65%), and the total.

classavgs(AAvg,EAvg,TAvg) :- 
	temp1(SA), temp2(SE), temp3(C),
	AAvg=(1.0*SA)/C, EAvg=(1.0*SE)/C, TAvg=(1.0*(SA+SE))/C.


% Student's performance relative to class avg on assignments, exams, and the total.

relperf(LN,Adifference,Edifference,Tdifference) :-
	totals(LN,FN,SSN,A,E,T), classavgs(AAvg,EAvg,TAvg),
	Adifference=A-AAvg, Edifference=E-EAvg, Tdifference=T-TAvg.


% The following two relations are intermediate results.

tempfin1(sum(<E3>)) :- grades(LN,FN,SSN,Login,A1,A2,A3,A4,E1,E2,E3). 
tempfin2(count(<E3>)) :- grades(LN,FN,SSN,Login,A1,A2,A3,A4,E1,E2,E3). 

% Statistics for the final exam.

finavg(X) :- 
	tempfin1(SE3), tempfin2(C), X=SE3/C.
finmax(max(<E3>)) :- 
        grades(LN,FN,SSN,Login,A1,A2,A3,A4,E1,E2,E3).
finmin(min(<E3>)) :- 
        grades(LN,FN,SSN,Login,A1,A2,A3,A4,E1,E2,E3).


% The following two relations are intermediate results.

temptot1(sum(<T>)) :-
	totals(LN,FN,SSN,A,E,T).
temptot2(count(<T>)) :-
	totals(LN,FN,SSN,A,E,T).

% Statistics for the total.

totavg(X) :- 
	temptot1(S), temptot2(C), X=S/C.
totmax(max(<T>)) :- 
	totals(LN,FN,SSN,A,E,T).
totmin(min(<T>)) :- 
	totals(LN,FN,SSN,A,E,T).


end_module.



