

module seqanal.
export ndayavg(bbff), movavg(bbff).

/*  The input data is in files seq1.F and seq2.F  */

/*  This version of moving average allows the specification of a sequence name;
    the program can be made faster if there is a single input sequence,
    and the sequence name is not a parameter.  */

@index_deltas -.
@multiset.

/* Finds avg for each N day period beginning from Day1; each period
begins the day after the end of the previous period */

ndayavg(Sname,N,D,A) :- t1(Sname,N,D,N,V), A=V/N.

% For each day that begins an N-day period, the following two rules
% initialize the running total of values seen so far in the period
% to the value on the starting day.  (The third argument is the starting,
% and the fourth argument is the number of days seen so far in the period.)

t1(Sname,N,Day1,1,V) :-
	from(Day1),
	sequence(Sname,Day1,V).

t1(Sname,N,D2,1,V2) :-
	t1(Sname,N,D,M1,V1), M1=N, D2=D+M1,
	sequence(Sname,D2,V2). 

% This rule computes the running total of values seen in a period for
% days in the middle of the period.

t1(Sname,N,D,M,V) :-
	t1(Sname,N,D,M1,V1), M1<N, D2=D+M1,
	sequence(Sname,D2,V2), M=M1+1, V=V1+V2.



/* Computes N day moving avg, beginning from Day1.  Here, successive periods
begin on successive days. */

% These rules use the moving average for the previous period to
% incrementally compute the moving average for the next period.

movavg(Sname,N,Day1,A) :-
	t2(Sname,N,Day1,N,V), A=V/N.

movavg(Sname,N,D,A) :-
	movavg(Sname,N,D1,A1), D=D1+1, D2=D1+N, 
	sequence(Sname,D1,Old),
	sequence(Sname,D2,New), A=A1+(New-Old)/N.

% t2 just computes the average for the first N days.

t2(Sname,N,Day1,1,V) :-
	from(Day1),
	sequence(Sname,Day1,V).

t2(Sname,N,D,M,V) :-
	t2(Sname,N,D,M1,V1), M1<N, D2=D+M1,
	sequence(Sname,D2,V2), M=M1+1, V=V1+V2.

end_module.
