/*
 * plrdwr.h
 *   Header file for use of PLREAD and PLWRITE.
 *
 * Copyright (C) 1990 V.Siebert
 */

#ifndef __PLRDWR_H
#define __PLRDWR_H

/*
 * Operator types
 */
#define OP_FX		0x01
#define OP_FY		0x02
#define OP_PREFIX	0x03

#define OP_XF		0x04
#define OP_YF		0x08
#define OP_POSTFIX	0x0c

#define OP_XFX		0x10
#define OP_XFY		0x20
#define OP_YFX		0x40
#define OP_INFIX	0x70

#define OP_LEFTASSOC	0x48
#define OP_RIGHTASSOC	0x22

#define OP_ATOM		0x80

/*
 * exported functions
 */
#if __STDC__
extern int prolog_read (TERM *result);
extern void prolog_write (TERM *termp);
extern void prolog_writeq (TERM *termp);
extern void prolog_display (TERM *termp);
extern void prolog_displayq (TERM *termp);
#else
extern int prolog_read ();
extern void prolog_write ();
extern void prolog_writeq ();
extern void prolog_display ();
extern void prolog_displayq ();
#endif

/*
 * Set up the default values of some constants
 */
#ifndef C_STYLE_COMMENTS
# define C_STYLE_COMMENTS	0
#endif
#ifndef CONTEXT_ERRORS
# define CONTEXT_ERRORS		1
#endif
#ifndef QUOTED_CAN_BE_OP
# define QUOTED_CAN_BE_OP	1
#endif
#ifndef BUILTIN_FLOATS
# define BUILTIN_FLOATS		0
#endif
#ifndef SIGNED_NUMBERS
# define SIGNED_NUMBERS		0
#endif
#ifndef STRING_SPECIAL
# define STRING_SPECIAL		0
#endif
#ifndef CONDITIONAL_SPECIAL
# define CONDITIONAL_SPECIAL	0
#endif
#ifndef ANONYMOUS_SPECIAL
# define ANONYMOUS_SPECIAL	0
#endif
#ifndef CONVERT_DOT_TO_LIST
# define CONVERT_DOT_TO_LIST	1
#endif
#ifndef TRACK_VARIABLES
# define TRACK_VARIABLES	0
#endif

/*
 * Prototypes for the interface functions.
 * Only declared, if there's no #define for that name
 */
#ifndef create_variable
extern void create_variable PROTO((TERM *result,char *name));
#endif

#if ANONYMOUS_SPECIAL && !defined(create_anonymous)
extern void create_anonymous PROTO((TERM *result));
#endif

#ifndef create_integer
extern void create_integer PROTO((TERM *result,char *value));
#endif

#if STRING_SPECIAL
#ifndef create_string
extern void create_string PROTO((TERM *result,char *string));
#endif
#else
#ifndef create_intfval
extern void create_intfval PROTO((TERM *result,int value));
#endif
#endif

#if CONDITIONAL_SPECIAL && !defined(create_conditional)
extern void create_conditional PROTO((TERM *result,TERM *arg));
#endif

#if BUILTIN_FLOATS && !defined(create_float)
extern void create_float PROTO((TERM *result,char *value));
#endif

#ifndef create_atom
extern void create_atom PROTO((TERM *result,char *name));
#endif

#ifndef create_eof
extern void create_eof PROTO((TERM *result));
#endif

#ifndef create_structure
extern void create_structure PROTO((TERM *result,char *functor,int arity,TERM *arguments));
#endif

#ifndef create_list
extern void create_list PROTO((TERM *result,TERM *head,TERM *tail));
#endif

#ifndef get_operator_type
extern void get_operator_type PROTO((char *operator,int *precedence,int *optypes));
#endif

#endif	/* __PLRDWR_H */
