/*
 *	machine.h
 *		maschinen-spezifische Definitionen
 *
 */

#ifndef __STDC__
#define const
#endif

#ifndef sparc
#define WORD_ALIGNED
#endif

#define WORD	short
#define UWORD	unsigned short

#ifdef sparc

#define GET_LONG(p)	((long)(p) & 2 ? \
			 ((UWORD *)(p))[0] << 16 | ((UWORD *)(p))[1] : \
			 *(long *)(p))
#define SET_LONG(p,l)	((long)(p) & 2 ? \
			 (((UWORD *)(p))[0] = (l) >> 16, ((UWORD *)(p))[1] = (l)) : \
			 (*(long *)(p) = (l)))

#else /* not sparc */

#define GET_LONG(p)	(*(long *)(p))
#define SET_LONG(p,l)	(*(long *)(p) = (l))

#endif /* sparc */

#define GET_WORD(p)	(*(WORD *)(p))
#define SET_WORD(p,l)	(*(WORD *)(p) = (l))
