/*
 *	sowam_debug.h
 *
 */

enum debug_type {		/* Reihenfolge wichtig: */
				/*   Praedikat -> Narrowing -> Rewriting */
    D_CALL,			/* Praedikat-Aufruf */
    D_REDO,
    D_FAIL,
    D_NARROW,			/* Funktionsaufruf, Narrowing */
    D_REWRITE,			/* Funktionsaufruf, Rewriting */
    D_REWRITE_A
};

struct af_entry *find_name PROTO((code_addr));
void	write_with_args PROTO((code_addr));
void	debug PROTO((enum debug_type, code_addr, code_addr));
void	debug_return PROTO((code_addr));
void	install_debug_handler PROTO((void));

#define DEBUG_OPCODE	((short)-1)

#define LAB(adr)	(CODE(adr)-b_code)

#ifndef NO_TRACE

#define TRACE0(f) \
  {if (s_glflags.trace) trace(s_regs.p-1,f);}
#define TRACE1(f,a1) \
  {if (s_glflags.trace) trace(s_regs.p-1,f,a1);}
#define TRACE1L(f,a1) \
  {if (s_glflags.trace) trace(s_regs.p-3,f,LAB(a1));}
#define TRACE1P(f,a1) \
  {if (s_glflags.trace) {struct af_entry *p_ = find_name(CODE(a1)); \
			 trace(s_regs.p-3,f,p_->text_addr,p_->arity);}}
#define TRACE1C(f,a1,a2) \
  {if (s_glflags.trace) trace(s_regs.p-3,f,a1,a2);}
#define TRACE2(f,a1,a2) \
  {if (s_glflags.trace) trace(s_regs.p-2,f,a1,a2);}
#define TRACE2L(f,a1,a2) \
  {if (s_glflags.trace) trace(s_regs.p-3,f,LAB(a1),a2);}
#define TRACE2P(f,a1,a2) \
  {if (s_glflags.trace) {struct af_entry *p_ = find_name(CODE(a1)); \
			 trace(s_regs.p-3,f,p_->text_addr,p_->arity,a2);}}
#define TRACE2C(f,a1,a2,a3) \
  {if (s_glflags.trace) trace(s_regs.p-3,f,a1,a2,a3);}
#define TRACE2T(f,a1) \
  {if (s_glflags.trace) trace(s_regs.p-2,f,a1);}
#define TRACE3L(f,a1,a2,a3) \
  {if (s_glflags.trace) trace(s_regs.p-4,f,LAB(a1),a2,a3);}
#define TRACE4L(f,a1,a2,a3,a4) \
  {if (s_glflags.trace) \
    trace(s_regs.p-1,f,LAB(a1),LAB(a2),LAB(a3),LAB(a4));}

#else /* NO_TRACE */

#define TRACE0(f)		
#define TRACE1(f,a1)		
#define TRACE1L(f,a1)		
#define TRACE1P(f,a1)
#define TRACE1C(f,a1,a2)	
#define TRACE2(f,a1,a2)		
#define TRACE2L(f,a1,a2)	
#define TRACE1P(f,a1,a2)
#define TRACE2C(f,a1,a2,a3)	
#define TRACE2T(f,a1)		
#define TRACE3L(f,a1,a2,a3)	
#define TRACE4L(f,a1,a2,a3,a4)	

#endif
