%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Flat-ALF-Compiler : Abstrakte Flat-ALF-Syntax -> Abstrakte SOWAM-Syntax
%
% Autor: Rudolf Opalla (1990)
%
% Aenderungen:
%  9.10.90	Andreas Schwab
%		Erkennung von eingebauten Praedikaten (built_in)
%
% 19.10.90	Andreas Schwab
%		neue SOWAM-Befehlsnamen
%
% 31.10.90	Andreas Schwab
%		fast vollstaendig neue Code-Erzeugung
%		zu viele Aenderungen um alle aufzuzaehlen
%
% 07.01.91	Andreas Schwab
%		ergaenze_var_info statt concat in
%		umstrukturieren_der_kopf_argumente und verflache_rest_bedingung
%
% 10.01.91	Andreas Schwab
%		veraenderte Variablen-Klassifikation bei Funktionen
%		Neue Variablen werden beim Aufruf der Funktion auf den Heap
%		geschrieben, dadurch nicht mehr lokal beim Rewriting
%		(write_local_value funktioniert bei Rewriting nicht)
%
% 17.01.91	Andreas Schwab
%		put_unsafe_value muss auch erzeugt werden, wenn eine Variable
%		aus dem Kopf des Praedikats als direktes Argument einer
%		Funktion uebergeben wird.
%
% 04.02.91	Andreas Schwab
%		Neuer Term-Konstruktor fNumber fuer Zahlen wird erkannt
%		und in s-Notation uebersetzt
%
% 19.02.91	Andreas Schwab
%		Optimierung in der Code-Erzeugung:
%		etliche concat-Aufrufe ersetzt durch Uebergabe des Listenendes
%		(in den c2_verflache...-Praedikaten)
%
% 29.04.91	Andreas Schwab
%		Fehlende Registerallozierung in c2_var_klass_main
%
% 04.06.91	Andreas Schwab
%		Umstellung auf SB-Prolog:
%		Argument zu fVar ist Variable (nicht mehr Variablenname)
%
% weitere Aenderungen siehe ChangeLog

compiler_version(2, 13).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Anmerkung: Um Speicherplatz und Rechenzeit zu sparen koennen alle
%            Fehlermeldungen geloescht werden, da saemtliche Fehlerquellen
%            schon im Praeprozessor untersucht werden.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Wichtigste Strukturen
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% narrow_unit:
%   maximale Argument-Nr
%   Vorkommende_Variablen,
%   Flach_geklopfte_Terme
%   Occurences,
%   rejection
%
% get_unit:
%   maximale Argument-Nr
%   Vorkommende_Variablen,
%   Flach_geklopfte_Terme
%
% call_unit:
%   maximale Argument-Nr
%   gesicherte Argumente,
%   Vorkommende_Variablen,
%   Flach_geklopfte_Terme
%
% replace_unit:
%   maximale Argument-Nr
%   vorkommende Variablen
%   flachgeklopfte Terme
%   Occurences
%
% var_info:
%   Bezeichner,
%   Anzahl_der_Vorkommen (einzeln | mehrfach),
%   1.Vorkommen_im_Kopf (kopf | rumpf),
%   1.Vorkommen_in_Struktur (struktur | register),
%   Kommt_nur_in_einem_block_vor (lokal | global).
%
% var_entry:
%   Bezeichner,
%   temporaer_permanent_oder_unsicher,
%   Register-Spezifikation,
%   Anzahl_der_vorkommen (einzeln | mehrfach),
%   Nr_des_Auftretens (neu | nichtneu),
%   schon_in_struktur_gewesen.
%
% rule_info:
%   Liste der pro Unit benoetigten maximalen Y-Register
%   Unit-Anzahl
%   allocate-Flag
%   allocate_occ-Flag
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

c2_compile(fProg(fDeclare(PDecl,CDecl,FDecl,TDecl),Regeln,Redus,
                 fGoal([fPredAppl(Goal,_)])),
	   Code,
	   [entry(the_goal/0, pred(Einsprung), nofix, -1),
	    entry('='/2, cons, infixnot, 700) | NeuDecl],
	   Einsprung) :-
    compiler_version(Major,Minor),
    write('FlatALF Compiler Version '),
    write(Major), write('.'), write(Minor), nl,
    c2_uebersetze_praedikate(PDecl, Regeln, 0,
			     PCode, NeuPDecl, LblNr1),
    c2_uebersetze_funktionen(FDecl, Regeln, LblNr1,
			     FCode, NeuFDecl, LblNr2),
    c2_uebersetze_totale_funktionen(TDecl, Regeln, LblNr2,
				    TCode, NeuTDecl, LblNr3),
    c2_uebersetze_redus(FDecl, Redus, LblNr3,
			RCode1, NeuFRDecl, LblNr4),
    c2_uebersetze_redus(TDecl, Redus, LblNr4,
			RCode2, NeuTRDecl, LblNr5),
    c2_uebersetze_praedikate([fPredDecl(Goal, 0, parameter)], Regeln, LblNr5,
			     GCode, _, _),
    c2_transformiere_cons_decl(CDecl, NeuConsDecl),
    c2_vervollstaendige_func_decl(NeuTDecl, NeuTRDecl),
    c2_vervollstaendige_func_decl(NeuFDecl, NeuFRDecl),
    c2_erstelle_name('glbl_', LblNr5, Einsprung),
    c2_concat(NeuFDecl, NeuTDecl, NeuDecl2),
    c2_concat(NeuPDecl, NeuDecl2, NeuDecl3),
    c2_concat(NeuConsDecl, NeuDecl3, NeuDecl),
    c2_concat(RCode2, GCode, ZCode1),
    c2_concat(RCode1, ZCode1, ZCode2),
    c2_concat(TCode, ZCode2, ZCode3),
    c2_concat(FCode, ZCode3, ZCode4),
    c2_concat(PCode, ZCode4, Code).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% uebersetze_praedikate: Liefert die Prozeduren fuer alle Praedikate
%   ein> Flat_ALF_Praedikat_Deklarationen
%        Flat_ALF_Regeln
%        Nummer_des_globalen_Labels_fuer_die_Prozedur
%   aus> SOWAM_Code
%        SOWAM_Deklarationen
%        Niedrigste_freie_globale_Labelnr
% 1) Keine weiteren Deklarationen
c2_uebersetze_praedikate([], _, LNr, [], [], LNr).
% 2) Rekursives abarbeiten der Deklarationen
% 2a) fuer eingebaute Praedikate gibt nichts zu tun - (as)
c2_uebersetze_praedikate([fPredDecl(Symbol,Stell,_)|RestDecl],
                         Regeln,
                         LabelNr,
                         Codes, NeuDecl, NeuLabelNr) :-
    sowam_builtin(Symbol,Stell,_),
    c2_uebersetze_praedikate(RestDecl, Regeln, LabelNr,
			     Codes, NeuDecl, NeuLabelNr).
% 2b) fuer die anderen wird's etwas schwerer...
c2_uebersetze_praedikate([fPredDecl(Symbol,Stell,Optype)|RestDecl],
                         Regeln,
                         LabelNr,
                         [proc(LabelName,Code)|RestCodes],
                         [NeuDecl|RestNeuDecl], NeuLabelNr) :-
    c2_uebersetze_ein_praedikat(Regeln, Symbol, Stell,
				LocalCode, ErstArgumente),
    c2_erstelle_name('glbl_', LabelNr, LabelName),
    c2_transformiere_optyp(Optype, -1, NeuOptype, NeuPrec),
    NeuDecl = entry(Symbol/Stell, pred(LabelName), NeuOptype, NeuPrec),
    c2_transformiere_erste_args(ErstArgumente, GeruestArgumente),
    c2_berechne_element_anzahl(GeruestArgumente, ErstArgAnzahl),
    c2_baue_geruest_fuer_pred(ErstArgAnzahl, Stell, GeruestArgumente, Geruest),
    c2_vereinige_geruest_mit_pred(Geruest, LocalCode, Code),
    HilfsLabelNr is LabelNr + 1,
    c2_uebersetze_praedikate(RestDecl, Regeln, HilfsLabelNr,
			     RestCodes, RestNeuDecl, NeuLabelNr).

%uebersetze_ein_praedikat: Uebersetzt alle Regeln eines Praedikats
%  ein> Flat_ALF_Regeln
%       Praedikat_Symbol
%       Stelligkeit
%  aus> SOWAM_Code_Liste_ohne_Geruest
%       Liste_der_ersten_Argumente
% 1) Keine Regeln mehr
c2_uebersetze_ein_praedikat([], _, _, [], []).
% 2) Passende Regel gefunden
c2_uebersetze_ein_praedikat([fPredRule(fPredAppl(Symbol,Args),Bedingungen)|Rest],
                            Symbol, Stell,
                            [LocalCode|RestCode],
                            [FirstArg|RestFirstArgListe]) :-
    c2_pruefe_argumente(Args, Stell, FirstArg),
    c2_uebersetze_eine_praedikat_regel(Args, Bedingungen,
				       LocalCode),
    c2_uebersetze_ein_praedikat(Rest, Symbol, Stell,
				RestCode, RestFirstArgListe).
% 3) Ansonsten weiter mit Rest
c2_uebersetze_ein_praedikat([_|Rest], Symbol, Stell, Code, Args) :-
    c2_uebersetze_ein_praedikat(Rest, Symbol, Stell, Code, Args).

%uebersetze_eine_praedikat_regel: Uebersetzt eine Praedikatregel
%  ein> Flat_ALF_Argument_Liste
%       Flat_ALF_Anfrage_Liste
%  aus> SOWAM_Code
c2_uebersetze_eine_praedikat_regel(Argumente, Bedingungen, Code) :-
    c2_analysiere_literale(Bedingungen, NeuBedingungen),
    c2_umstrukturieren_der_kopf_argumente(Argumente, GetUnit, HVarNr),
    c2_umstrukturieren_der_literale(NeuBedingungen, HVarNr, FlatBedingungen, VarNr),
    c2_get_unit_einordnen(get_unit(0, [], [alloc_occ]), FlatBedingungen, Units1),
    c2_get_unit_einordnen(GetUnit, Units1, Units),
%    drucke_befehle(Units),
    c2_var_sammeln(Units, 0, VarNr, VarEntries, RuleInfo),
    c2_uebersetze_praedikat_zu_instruktionen(Units, 1, VarEntries, RuleInfo,
					     VorCode),
    c2_pruefe_allocate(RuleInfo, AllocCode),
    c2_concat(AllocCode, VorCode, Code).

% uebersetze_praedikat_zu_instruktionen: SOWAM-Instruktionsfolge wird generiert
%   ein> Unit_Liste,
%        Aktuelle_Unit_Nr
%        VarEntry_Liste,
%        rule_info(MaxYListe, UnitAnzahl, AllocNoetig, AllocOccNoetig)
%   aus> Liste von Instruktionen
c2_uebersetze_praedikat_zu_instruktionen([get_unit(MA, _, FT)], 1,
                                         VarEntries, RuleInfo,
                                         Code) :-
    c2_uebersetze_letzte_praedikat_unit(FT, 1, VarEntries, RuleInfo, [],
					temp(MA, []),
					HCode),
    c2_eliminiere_doppelvoid(HCode, Code).
c2_uebersetze_praedikat_zu_instruktionen([call_unit(MA, Sich, _, FT)],
                                         UnitAnz,
                                         VarEntries, RuleInfo,
                                         Code) :-
    c2_pruefe_deallocate_occ(RuleInfo, AOCode),
    c2_concat(AOCode, AktCode, Code),
    c2_uebersetze_letzte_praedikat_unit(FT, UnitAnz, VarEntries,
					RuleInfo, Sich, temp(MA, []),
					HCode),
    c2_eliminiere_doppelvoid(HCode, AktCode).
c2_uebersetze_praedikat_zu_instruktionen([narrow_unit(MA, _, FT, Occ, Rej)|Rest],
					 UnitNr,
                                         VarEntries, RuleInfo,
					 Code) :-
    c2_uebersetze_narrow_unit(FT, UnitNr, Occ, Rej,
			      VarEntries, RuleInfo, temp(MA, []), pred,
			      HCode, NeuVarEntries),
    c2_eliminiere_doppelvoid(HCode, AktCode),
    c2_concat(AktCode, RestCode, Code),
    NeuUnitNr is UnitNr + 1,
    c2_uebersetze_praedikat_zu_instruktionen(Rest, NeuUnitNr,
					     NeuVarEntries, RuleInfo,
					     RestCode).
c2_uebersetze_praedikat_zu_instruktionen([call_unit(MA, Sich, _, FT)|Rest],
					 UnitNr,
					 VarEntries, RuleInfo,
					 Code) :-
    c2_uebersetze_call_unit(FT, UnitNr, VarEntries, RuleInfo,
			    Sich, temp(MA, []), pred,
			    HCode, NeuVarEntries),
    c2_eliminiere_doppelvoid(HCode, AktCode),
    c2_concat(AktCode, RestCode, Code),
    NeuUnitNr is UnitNr + 1,
    c2_uebersetze_praedikat_zu_instruktionen(Rest, NeuUnitNr,
					     NeuVarEntries, RuleInfo,
					     RestCode).
c2_uebersetze_praedikat_zu_instruktionen(FT, _, _, _, []) :-
    write('*** Fehler bei uebersetze_praedikat_zu_instruktionen:'), nl,
    write(FT), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% uebersetze_totale_funktionen: Liefert alle Prozeduren fuer totale Funktionen
%   ein> Flat_ALF_Praedikat_Deklarationen
%        Flat_ALF_Regeln
%        Nummer_des_globalen_Labels_fuer_die_Prozedur
%   aus> SOWAM_Code
%        SOWAM_Deklarationen
%        Niedrigste_freie_globale_Labelnr
c2_uebersetze_totale_funktionen([], _, LNr, [], [], LNr).
c2_uebersetze_totale_funktionen([fFuncDecl(Symbol,Stell,Optype,Prec)|RestDecl],
                                Regeln,
                                LabelNr, [proc(LabelName,Code)|RestCodes],
                                [NeuDecl|RestSDecl],
                                NeuLabelNr) :-
    c2_uebersetze_eine_funktion(Regeln, Symbol, Stell,
				LocalCode, Argumente),
    c2_erstelle_name('glbl_', LabelNr, LabelName),
    c2_transformiere_optyp(Optype, Prec, NeuOptype, NeuPrec),
    NeuDecl = entry(Symbol/Stell, func(LabelName, _), NeuOptype, NeuPrec),
    c2_transformiere_erste_args(Argumente, GeruestArgumente),
    c2_berechne_element_anzahl(GeruestArgumente, ArgAnzahl),
    c2_baue_geruest_fuer_total(ArgAnzahl, Stell, GeruestArgumente, Geruest),
    c2_vereinige_geruest_mit_total(Geruest, LocalCode, Code),
    HilfsLabelNr is LabelNr + 1,
    c2_uebersetze_totale_funktionen(RestDecl, Regeln, HilfsLabelNr,
				    RestCodes, RestSDecl, NeuLabelNr).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% uebersetze_funktionen: Nicht totale Funktionen
%   ein> Flat_ALF_Praedikat_Deklarationen
%        Flat_ALF_Regeln
%        Nummer_des_globalen_Labels_fuer_die_Prozedur
%   aus> SOWAM_Code
%        SOWAM_Deklarationen
%        Niedrigste_freie_globale_Labelnr
c2_uebersetze_funktionen([], _, LabelNr, [], [], LabelNr).
c2_uebersetze_funktionen([fFuncDecl(Symbol,Stell,Optype,Prec)|RestDecl],
                         Regeln,
                         LabelNr,
                         [proc(LabelName,Code)|RestCodes],
                         [entry(Symbol/Stell, func(LabelName, _),
				NeuOptype, NeuPrec) | RestSDecl],
			 OutLabelNr) :-
    c2_uebersetze_eine_funktion(Regeln, Symbol, Stell,
				LocalCode, Argumente),
    c2_erstelle_name('glbl_', LabelNr, LabelName),
    c2_transformiere_optyp(Optype, Prec, NeuOptype, NeuPrec),
    c2_transformiere_erste_args(Argumente, GeruestArgumente),
    c2_berechne_element_anzahl(GeruestArgumente, ArgAnzahl),
    c2_baue_geruest_fuer_nicht_total(ArgAnzahl, Stell, GeruestArgumente,
				     Geruest),
    c2_vereinige_geruest_mit_nicht_total(Geruest, LocalCode, Code),
    LabelNrRest is LabelNr + 1,
    c2_uebersetze_funktionen(RestDecl, Regeln, LabelNrRest,
			     RestCodes, RestSDecl, OutLabelNr).

%uebersetze_eine_funktion: Uebersetzt alle Regeln einer Funktion
%  ein> Flat_ALF_Regeln
%       Symbol
%       Stelligkeit
%  aus> SOWAM_Code_Liste_ohne_Geruest
%       Liste_der_ersten_Argumente
c2_uebersetze_eine_funktion([], _, _, [], []).
c2_uebersetze_eine_funktion([fFuncRule(fFuncAppl(Symbol, Args), Ersetzung,
				       Bedingungen)|Rest],
			    Symbol, Stell,
                            [LocalCode|RestCode],
                            [FirstArg|RestFAListe]) :-
    c2_pruefe_argumente(Args, Stell, FirstArg),
    c2_uebersetze_eine_funktions_regel(Args, Bedingungen, Ersetzung,
				       LocalCode),
    c2_uebersetze_eine_funktion(Rest, Symbol, Stell,
				RestCode, RestFAListe).
c2_uebersetze_eine_funktion([_|Rest], Symbol, Stell,
                            Code, Argumente) :-
    c2_uebersetze_eine_funktion(Rest, Symbol, Stell, Code, Argumente).

%uebersetze_eine_funktions_regel: Uebersetzt eine Funktions_regel
%  ein> Flat_ALF_Argument_Liste (Linke Seite)
%       Flat_ALF_Anfrage_Liste (Bedingungen)
%       Ersetzung (rechte Seite)
%  aus> SOWAM_Code
c2_uebersetze_eine_funktions_regel(Argumente, Bedingungen, Ersetzung,
                                   Code) :-
    c2_concat(Bedingungen, [fReplace(Ersetzung)], HBedingungen),
    c2_analysiere_literale(HBedingungen, NeuBedingungen),
    c2_umstrukturieren_der_kopf_argumente(Argumente, GetUnit, HVarNr),
    c2_umstrukturieren_der_literale(NeuBedingungen, HVarNr, FlatBedingungen, VarNr),
    c2_get_unit_einordnen(get_unit(0, [], [alloc_occ]), FlatBedingungen, Units1),
    c2_get_unit_einordnen(GetUnit, Units1, Units),
%    drucke_befehle(Units),			%%% debugging
    c2_var_sammeln(Units, 0, VarNr, VarEntries, RuleInfo),
    c2_uebersetze_funktion_zu_instruktionen(Units, 1, VarEntries, RuleInfo,
					    VorCode),
    c2_pruefe_allocate(RuleInfo, AllocCode),
    c2_concat(AllocCode, VorCode, Code).

% uebersetze_funktion_zu_instruktionen: SOWAM-Instruktionsfolge wird generiert
%   ein> Unit_Liste,
%        Aktuelle_Unit_Nr
%        VarEntry_Liste,
%        rule_info(MaxYListe, UnitAnzahl, AllocNoetig, AllocOccNoetig)
%   aus> Liste von Instruktionen
c2_uebersetze_funktion_zu_instruktionen([replace_unit(MA, _, FT, Occ)],
                                        UnitAnz, VarEntries, RuleInfo,
                                        Code) :-
    c2_pruefe_deallocate_occ(RuleInfo, AOCode),
    c2_concat(AOCode, AktCode, Code),
    c2_uebersetze_letzte_funktions_unit(FT, UnitAnz, Occ, VarEntries,
					RuleInfo, temp(MA, []),
					HCode),
    c2_eliminiere_doppelvoid(HCode, AktCode).
c2_uebersetze_funktion_zu_instruktionen([narrow_unit(MA, _, FT, Occ, Rej)|Rest],
                                        UnitNr, VarEntries, RuleInfo,
                                        Code) :-
    c2_uebersetze_narrow_unit(FT, UnitNr, Occ, Rej,
			      VarEntries, RuleInfo, temp(MA, []), func,
			      HCode, NeuVarEntries),
    c2_eliminiere_doppelvoid(HCode, AktCode),
    c2_concat(AktCode, RestCode, Code),
    NeuUnitNr is UnitNr + 1,
    c2_uebersetze_funktion_zu_instruktionen(Rest, NeuUnitNr,
					    NeuVarEntries, RuleInfo,
					    RestCode).
c2_uebersetze_funktion_zu_instruktionen([call_unit(MA, Sich, _, FT)|Rest],
                                        UnitNr, VarEntries, RuleInfo,
                                        Code) :-
    c2_uebersetze_call_unit(FT, UnitNr, VarEntries, RuleInfo,
			    Sich, temp(MA, []), func,
			    HCode, NeuVarEntries),
    c2_eliminiere_doppelvoid(HCode, AktCode),
    c2_concat(AktCode, RestCode, Code),
    NeuUnitNr is UnitNr + 1,
    c2_uebersetze_funktion_zu_instruktionen(Rest, NeuUnitNr,
					    NeuVarEntries, RuleInfo,
					    RestCode).
c2_uebersetze_funktion_zu_instruktionen(FT, _, _, _, []) :-
    write('*** Fehler bei uebersetze_funktion_zu_instruktionen:'), nl,
    write(FT), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% uebersetze_redus: Liefert Rewrite-Prozeduren zu den Deklarationen
%   ein> Flat_ALF_Funktions_Deklarationen
%        Flat_ALF_Regeln
%        Nummer_des_globalen_Labels_fuer_die_Prozedur
%   aus> SOWAM_Code
%        SOWAM_Deklarationen
%        naechste_freie_globale_Labelnr
c2_uebersetze_redus([], _, LabelNr, [], [], LabelNr).
c2_uebersetze_redus([fFuncDecl(Symbol,Stell,_,_)|RestDecl],
                    Regeln,
                    LabelNr,
                    [proc(LabelName,Code)|RestCodes],
                    [LabelName|RestSDecl], OutLabelNr) :-
    c2_uebersetze_eine_redu(Regeln, 1, Symbol, Stell,
			    LocalCode, Argumente),
    c2_erstelle_name('glbl_', LabelNr, LabelName),
    c2_transformiere_erste_args(Argumente, GeruestArgumente), %r_prepare
    c2_berechne_element_anzahl(GeruestArgumente, ArgAnzahl),
    c2_baue_geruest_fuer_redu(ArgAnzahl, Stell, GeruestArgumente, Geruest),
    c2_vereinige_geruest_mit_redu(Geruest, LocalCode, (Symbol/Stell), Code),
    LabelNrRest is LabelNr + 1,
    c2_uebersetze_redus(RestDecl, Regeln, LabelNrRest,
			RestCodes, RestSDecl, OutLabelNr).

%uebersetze_eine_redu: Uebersetzt alle Regeln einer Funktion
%  ein> Flat_ALF_Regeln
%       RegelNr
%       Symbol
%       Stelligkeit
%  aus> SOWAM_Code_Liste_ohne_Geruest
%       Liste_der_ersten_Argumente
c2_uebersetze_eine_redu([], _, _, _, [], []).
c2_uebersetze_eine_redu([fFuncRedu(fFuncAppl(Symbol, Args), Ersetzung,
				   Bedingungen)|Rest],
                        RNr, Symbol, Stell,
                        [LocalCode|RestCode],
                        [FirstArg|RestFAListe]) :-
    c2_pruefe_argumente(Args, Stell, FirstArg),
    c2_erstelle_name(lt, RNr, RealLLName),
    c2_uebersetze_eine_redus_regel(Stell, Args, Bedingungen, Ersetzung,
				   RealLLName, LocalCode),
    NeuRNr is RNr + 1,
    c2_uebersetze_eine_redu(Rest, NeuRNr, Symbol, Stell,
			    RestCode, RestFAListe).
c2_uebersetze_eine_redu([_|Rest], RNr, Symbol, Stell, Code, Argumente) :-
    c2_uebersetze_eine_redu(Rest, RNr, Symbol, Stell, Code, Argumente).

%uebersetze_eine_redus_regel: Uebersetzt eine Reduktionsregel
%  ein> Stelligkeit
%       Flat_ALF_Argument_Liste
%       Flat_ALF_Anfrage_Liste
%       Ersetzung
%       Hilfs_LabelName
%  aus> SOWAM_Code
c2_uebersetze_eine_redus_regel(Stell, Argumente, Bedingungen, Ersetzung,
                               LocLblName, Code) :-
    c2_concat(Bedingungen, [fReplace(Ersetzung)], HBedingungen),
    c2_analysiere_literale(HBedingungen, NeuBedingungen),
    c2_umstrukturieren_der_kopf_argumente(Argumente, GetUnit, HVarNr),
    c2_umstrukturieren_der_literale(NeuBedingungen, HVarNr, FlatBedingungen,
				    VarNr),
    c2_get_unit_einordnen(get_unit(0, [], [l_try_me_else(LocLblName, Stell),
					   alloc_occ]),
			  FlatBedingungen, Units1),
    c2_get_unit_einordnen(GetUnit, Units1, Units),
%    drucke_befehle(Units),
    c2_var_sammeln(Units, 1, VarNr, VarEntries, RuleInfo),
    c2_uebersetze_redu_zu_instruktionen(Units, 1, VarEntries, RuleInfo,
					VorCode),
    c2_pruefe_allocate(RuleInfo, AllocCode),
    c2_pruefe_l_trust(RuleInfo, LocLblName, LTryCode),
    c2_concat(VorCode, LTryCode, HCode),
    c2_concat(AllocCode, HCode, Code).

% uebersetze_redu_zu_instruktionen: SOWAM-Instruktionsfolge wird generiert
%   ein> Unit_Liste,
%        Aktuelle_Unit_Nr
%        VarEntry_Liste,
%        rule_info(MaxYListe, UnitAnzahl, AllocNoetig, AllocOccNoetig)
%   aus> Liste von Instruktionen
c2_uebersetze_redu_zu_instruktionen([replace_unit(MA, _, FT, Occ)],
				    UnitAnz, VarEntries, RuleInfo,
                                    Code) :-
    c2_pruefe_deallocate_occ(RuleInfo, AOCode),
    c2_pruefe_l_try_me_else(RuleInfo, l_trust_me_else_fail, BOCode),
    c2_concat(AOCode, BOCode, COCode),
    c2_concat(COCode, AktCode, Code),
    c2_uebersetze_letzte_redu_unit(FT, UnitAnz, Occ, VarEntries,
				   RuleInfo, temp(MA, []), HCode),
    c2_eliminiere_doppelvoid(HCode, AktCode).
c2_uebersetze_redu_zu_instruktionen([narrow_unit(MA, _, FT, Occ, Rej)|Rest],
                                    UnitNr, VarEntries, RuleInfo,
                                    Code) :-
    c2_uebersetze_narrow_unit(FT, UnitNr, Occ, Rej, VarEntries, RuleInfo,
			      temp(MA, []), redu,
			      HCode, NeuVarEntries),
    c2_eliminiere_doppelvoid(HCode, AktCode),
    c2_concat(AktCode, RestCode, Code),
    NeuUnitNr is UnitNr + 1,
    c2_uebersetze_redu_zu_instruktionen(Rest, NeuUnitNr,
					NeuVarEntries, RuleInfo,
					RestCode).
c2_uebersetze_redu_zu_instruktionen([call_unit(MA, Sich, _, FT)|Rest],
                                    UnitNr, VarEntries, RuleInfo,
                                    Code) :-
    c2_uebersetze_call_unit(FT, UnitNr, VarEntries, RuleInfo,
			    Sich, temp(MA, []), redu,
			    HCode, NeuVarEntries),
    c2_eliminiere_doppelvoid(HCode, AktCode),
    c2_concat(AktCode, RestCode, Code),
    NeuUnitNr is UnitNr + 1,
    c2_uebersetze_redu_zu_instruktionen(Rest, NeuUnitNr,
					NeuVarEntries, RuleInfo,
					RestCode).
c2_uebersetze_redu_zu_instruktionen(FT, _, _, _, []) :-
    write('*** Fehler bei uebersetze_redu_zu_instruktionen:'), nl,
    write(FT), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% uebersetze_narrow_unit: Verwandelt die gesammelten Daten in SOWAM-Instr
%  ein> FlatTerme,
%       UnitNr
%	Occurences
%       Rejekt
%       VarEntries,
%       RuleInfo,
%	temporaere Variablen
%       pred/func/redu
%  aus> Code,
%       NeuVarEntries,
% 1a) Abschliessen mit narrow-Aufruf
c2_uebersetze_narrow_unit([], UnitNr, Occ, nein, VarEntries,
                          rule_info(MYL,_,_,_), TempVars, _,
                          Code, VarEntries) :-
    c2_baue_occ_stack(Occ, VarEntries, TempVars, OccCode),
    c2_concat(OccCode, [call_rewriting(ao,Hilf), rebuild_occ_stack,
			call_narrowing(ao,Hilf)],
	      Code),
    c2_finde_max_perm_in_unit(UnitNr, MYL, Hilf).
c2_uebersetze_narrow_unit([call_rewriting(Name,Stell)], UnitNr, Occ, nein, VarEntries,
                          rule_info(MYL,_,_,_), TempVars, _,
                          Code, VarEntries) :-
    c2_baue_occ_stack(Occ, VarEntries, TempVars, OccCode),
    c2_concat(OccCode,
	      [call_rewriting(Name/Stell,Hilf), rebuild_occ_stack,
	       call_narrowing(ao,Hilf)],
	      Code),
    c2_finde_max_perm_in_unit(UnitNr, MYL, Hilf).
% 1b) Abschliessen mit reject und reflection
c2_uebersetze_narrow_unit([], UnitNr, Occ, reject, VarEntries,
                          rule_info(MYL,_,_,_), TempVars, _,
                          Code, VarEntries) :-
    c2_baue_occ_stack(Occ, VarEntries, TempVars, OccCode),
    c2_concat(OccCode,
	      [call_rewriting(ao,Hilf), rebuild_occ_stack, reject,
	       call_narrowing(ao,Hilf), reflection],
	      Code),
    c2_finde_max_perm_in_unit(UnitNr, MYL, Hilf).
c2_uebersetze_narrow_unit([call_rewriting(Name,Stell)], UnitNr, Occ,
			  reject, VarEntries,
                          rule_info(MYL,_,_,_), TempVars, _,
                          Code, VarEntries) :-
    c2_baue_occ_stack(Occ, VarEntries, TempVars, OccCode),
    c2_concat(OccCode,
	      [call_rewriting(Name/Stell,Hilf), rebuild_occ_stack, reject,
	       call_narrowing(ao,Hilf), reflection],
	      Code),
    c2_finde_max_perm_in_unit(UnitNr, MYL, Hilf).
% 3) allocate_occ einfuegen
c2_uebersetze_narrow_unit([alloc_occ|FT], UnitNr, Occ, Rej, VarEntries,
                          RuleInfo, TempVars, PFR,
                          Code, NeuVarEntries) :-
    c2_pruefe_allocate_occ(RuleInfo, AOCode),
    c2_concat(AOCode, RestCode, Code),
    c2_uebersetze_narrow_unit(FT, UnitNr, Occ, Rej, VarEntries,
			      RuleInfo, TempVars, PFR,
			      RestCode, NeuVarEntries).
% 4) l_try_me_else einfuegen
c2_uebersetze_narrow_unit([l_try_me_else(L,ST)|FT], UnitNr, Occ,
                          Rej, VarEntries, rule_info(MYL,A1,A2,A3), TempVars, PFR,
                          Code, NeuVarEntries) :-
    c2_finde_max_perm_in_unit(1, MYL, Hilf),
    c2_pruefe_l_try_me_else(rule_info(MYL,A1,A2,A3),
			    l_try_me_else(L,ST, Hilf), AOCode),
    c2_concat(AOCode, RestCode, Code),
    c2_uebersetze_narrow_unit(FT, UnitNr, Occ, Rej, VarEntries,
			      rule_info(MYL,A1,A2,A3), TempVars, PFR,
			      RestCode,
			      NeuVarEntries).
% 5) call_rewriting nach hinten stellen
c2_uebersetze_narrow_unit([call_rewriting(Symb,ArgAnz)|FT], UnitNr, Occ,
			  Rej, VarEntries, RuleInfo, TempVars, PFR,
			  Code, NeuVarEntries) :-
    c2_concat(FT,[call_rewriting(Symb,ArgAnz)],NeuFT),
    c2_uebersetze_narrow_unit(NeuFT, UnitNr, Occ, Rej, VarEntries,
			      RuleInfo, TempVars, PFR,
			      Code, NeuVarEntries).
% 6) Ansonsten Instruktionen abarbeiten
c2_uebersetze_narrow_unit([X|FT], UnitNr, Occ, Rej, VarEntries,
                          RuleInfo, TempVars, PFR,
                          [Ins | RestCode], NeuVarEntries) :-
    c2_uebersetze_instruktion(X, UnitNr, VarEntries, TempVars, PFR,
			      Ins, ZwVarEntries, NeuTempVars),
    c2_uebersetze_narrow_unit(FT, UnitNr, Occ, Rej, ZwVarEntries,
			      RuleInfo, NeuTempVars, PFR,
			      RestCode,
			      NeuVarEntries).
c2_uebersetze_narrow_unit(FT, _, _, _, VarEntries, _, _, _,
                          [], VarEntries) :-
    write('*** Fehler bei uebersetze_narrow_unit:'), nl,
    write(FT), nl.


% uebersetze_call_unit: Verwandelt die gesammelten Daten in SOWAM-Instr
%  ein> UnitNr
%       FlatTerme,
%       VarEntries,
%       RuleInfo,
%       Gesichert,s
%	temporaere Variablen
%       pred/func/redu
%  aus> Code,
%       NeuVarEntries
c2_uebersetze_call_unit(FT, UnitNr, VarEntries, RuleInfo, Sich, TempVars, PFR,
                        Code, NeuVarEntries) :-
    c2_hole_gesicherte(Sich, UnitNr, VarEntries, SCode),
    c2_concat(SCode, RestCode, Code),
    c2_uebersetze_call_unit(FT, UnitNr, VarEntries, RuleInfo, TempVars, PFR,
			    RestCode, NeuVarEntries).

% 1) allocate_occ Einfuegen
c2_uebersetze_call_unit([alloc_occ|FT], UnitNr, VarEntries,
			RuleInfo, TempVars, PFR,
                        Code, NeuVarEntries) :-
    c2_pruefe_allocate_occ(RuleInfo, AOCode),
    c2_concat(AOCode, RestCode, Code),
    c2_uebersetze_call_unit(FT, UnitNr, VarEntries, RuleInfo, TempVars, PFR,
			    RestCode, NeuVarEntries).
% 2) l_try_me_else Einfuegen
c2_uebersetze_call_unit([l_try_me_else(L,ST)|FT], UnitNr, VarEntries,
                        rule_info(MYL, A1, A2, A3), TempVars, PFR,
                        Code, NeuVarEntries) :-
    c2_finde_max_perm_in_unit(1, MYL, Hilf),
    c2_pruefe_l_try_me_else(rule_info(MYL,A1,A2,A3),
			    l_try_me_else(L,ST,Hilf), AOCode),
    c2_concat(AOCode, RestCode, Code),
    c2_uebersetze_call_unit(FT, UnitNr, VarEntries,
			    rule_info(MYL, A1, A2, A3), TempVars, PFR,
			    RestCode, NeuVarEntries).
% 3) Abschluss mit call-Aufruf
% 3a) Eingebautes Praedikat - (as)
c2_uebersetze_call_unit([pred(Praedikat, Stell)], _, VarEntries,
			_, _, _,
                        [built_in(Praedikat/Stell)], VarEntries) :-
    sowam_builtin(Praedikat, Stell, _).
% 3b) sonstige Praedikate
c2_uebersetze_call_unit([pred(Praedikat, Stell)], UnitNr, VarEntries,
                        rule_info(MYL,_,_,_), _, _,
                        [call(Praedikat/Stell, ZuSichern)], VarEntries) :-
    c2_finde_max_perm_in_unit(UnitNr, MYL, ZuSichern).
% 4) Abschluss (z.B. bei equation)
c2_uebersetze_call_unit([], _, VarEntries, _, _, _, [], VarEntries).
% 5) Ansonsten Instruktionen abarbeiten
c2_uebersetze_call_unit([X|FT], UnitNr, VarEntries, 
                        RuleInfo, TempVars, PFR,
                        [Ins | RestCode], NeuVarEntries) :-
    c2_uebersetze_instruktion(X, UnitNr, VarEntries, TempVars, PFR,
			      Ins, ZwVarEntries, NeuTempVars),
    c2_uebersetze_call_unit(FT, UnitNr, ZwVarEntries,
			    RuleInfo, NeuTempVars, PFR,
			    RestCode, NeuVarEntries).
c2_uebersetze_call_unit(FT, _, VarEntries, _, _, _, [], VarEntries) :-
    write('*** Fehler bei uebersetze_call_unit:'), nl,
    write(FT), nl.

% uebersetze_letzte_praedikat_unit: Verwandelt die Daten in SOWAM-Instr
%  ein>	FlatTerme
%	UnitNr
%	VarEntries
%	RuleInfo
%	Gesichert
%	temporaere Variablen
%  aus>	Code
c2_uebersetze_letzte_praedikat_unit(FT, UnitNr, VarEntries, RuleInfo, Sich,
				    TempVars, Code) :-
    c2_hole_gesicherte(Sich, UnitNr, VarEntries, SCode),
    c2_concat(SCode, RestCode, Code),
    c2_uebersetze_letzte_praedikat_unit(FT, UnitNr, VarEntries, RuleInfo,
					TempVars, RestCode).

% 1) Letzter Befehl (Abschluss mit proceed)
c2_uebersetze_letzte_praedikat_unit([], _, _, RuleInfo, _, Code) :-
    c2_pruefe_deallocate(RuleInfo, ACode),
    c2_concat(ACode, [proceed], Code).
% 3) Abschluss mit execute
% 3a) eingebaute Praedikate - (as)
c2_uebersetze_letzte_praedikat_unit([pred(Praedikat, Stell)], _, _,
                                    RuleInfo, _, Code) :-
    sowam_builtin(Praedikat, Stell, _), !,
    c2_pruefe_deallocate(RuleInfo, ACode),
    c2_concat(ACode, [built_in(Praedikat/Stell),proceed], Code).
% 3b) sonstige Praedikate
c2_uebersetze_letzte_praedikat_unit([pred(Praedikat, Stell)], _, _,
                                    RuleInfo, _, Code) :-
    c2_pruefe_deallocate(RuleInfo, ACode),
    c2_concat(ACode, [execute(Praedikat/Stell)], Code).
% 4) Ansonsten Instruktionen bearbeiten
c2_uebersetze_letzte_praedikat_unit([X|FT], UnitNr, VarEntries,
				    RuleInfo, TempVars,
				    [Ins | RestCode]) :-
    c2_uebersetze_instruktion(X, UnitNr, VarEntries, TempVars, pred,
			      Ins, NeuVarEntries, NeuTempVars),
    c2_uebersetze_letzte_praedikat_unit(FT, UnitNr, NeuVarEntries,
					RuleInfo, NeuTempVars,
					RestCode).
c2_uebersetze_letzte_praedikat_unit(FT, _, _, _, _, []) :-
    write('*** Fehler bei uebersetze_letzte_praedikat_unit:'), nl,
    write(FT), nl.

% uebersetze_letzte_funktions_unit:
%  ein> FlatTerme,
%       UnitNr
%	Occurences,
%       VarEntries,
%       RuleInfo,
%	temporaere Variablen
%  aus> Code,
% 1) Abschliessen mit leerem Occ-Stack
c2_uebersetze_letzte_funktions_unit([], _, [], _, RuleInfo, _, Code) :-
    c2_pruefe_deallocate(RuleInfo, ACode),
    c2_concat(ACode, [pop_occ, call_rewriting(ao), 
		      rebuild_occ_stack, reject, execute_narrowing(ao)], Code).
% 2) Abschliessen mit belegtem Occ-Stack
c2_uebersetze_letzte_funktions_unit([call_rewriting(Symb,ArgAnz)], _, Occ,
				    VarEntries, RuleInfo, TempVars, Code) :-
    c2_pruefe_deallocate(RuleInfo, ACode),
    c2_baue_occ_stack(Occ, VarEntries, TempVars, OccCode),
    c2_concat(OccCode,
	      [call_rewriting(Symb/ArgAnz), rebuild_occ_stack, reject,
	       execute_narrowing(ao)],
	      HCode),
    c2_concat(ACode, HCode, Code).
% 3) call_rewriting nach hinten stellen
c2_uebersetze_letzte_funktions_unit([call_rewriting(Symb,ArgAnz)|FT], UnitNr, Occ,
				    VarEntries, RuleInfo, TempVars, Code) :-
    c2_concat(FT,[call_rewriting(Symb,ArgAnz)],NeuFT),
    c2_uebersetze_letzte_funktions_unit(NeuFT, UnitNr, Occ, VarEntries,
					RuleInfo, TempVars,
					Code).
% 4) Ansonsten Instruktionen abarbeiten
c2_uebersetze_letzte_funktions_unit([X|FT], UnitNr, Occ, VarEntries,
                                    RuleInfo, TempVars,
                                    [Ins | RestCode]) :-
    c2_uebersetze_instruktion(X, UnitNr, VarEntries, TempVars, func,
			      Ins, ZwVarEntries, NeuTempVars),
    c2_uebersetze_letzte_funktions_unit(FT, UnitNr, Occ, ZwVarEntries,
					RuleInfo, NeuTempVars,
					RestCode).
c2_uebersetze_letzte_funktions_unit(FT, _, _, _, _, _, []) :-
    write('*** Fehler bei uebersetze_letzte_funktions_unit:'), nl,
    write(FT), nl.

% uebersetze_letzte_redu_unit:
%  ein> FlatTerme,
%       UnitNr,
%	Occurences
%       VarEntries,
%       RuleInfo,
%	temporaere Variablen
%  aus> Code
% 1) Abschliessen mit leerem Occ-Stack
c2_uebersetze_letzte_redu_unit([], _, [], _, RuleInfo, _, Code) :-
    c2_pruefe_deallocate(RuleInfo, ACode),
    c2_concat(ACode, [invalid_os, pop_occ, execute_rewriting(ao)], Code).
% 2) Abschliessen mit belegtem Occ-Stack
c2_uebersetze_letzte_redu_unit([call_rewriting(Symb,ArgAnz)], _, Occ,
			       VarEntries, RuleInfo, TempVars,
                               Code) :-
    c2_pruefe_deallocate(RuleInfo, ACode),
    c2_baue_occ_stack(Occ, VarEntries, TempVars, OccCode),
    c2_concat(OccCode,
	      [invalid_os, execute_rewriting(Symb/ArgAnz)],
	      HCode),
    c2_concat(ACode, HCode, Code).
% 3) call_rewriting nach hinten stellen
c2_uebersetze_letzte_redu_unit([call_rewriting(Symb,ArgAnz)|FT], UnitNr, Occ,
			       VarEntries, RuleInfo, TempVars,
                               Code) :-
    c2_concat(FT,[call_rewriting(Symb,ArgAnz)],NeuFT),
    c2_uebersetze_letzte_redu_unit(NeuFT, UnitNr, Occ, VarEntries,
				   RuleInfo, TempVars, Code).
% 4) Ansonsten Instruktionen abarbeiten
c2_uebersetze_letzte_redu_unit([X|FT], UnitNr, Occ, VarEntries,
                               RuleInfo, TempVars, [Ins | RestCode]) :-
    c2_uebersetze_instruktion(X, UnitNr, VarEntries, TempVars, redu,
			      Ins, ZwVarEntries, NeuTempVars),
    c2_uebersetze_letzte_redu_unit(FT, UnitNr, Occ, ZwVarEntries,
				   RuleInfo, NeuTempVars, RestCode).
c2_uebersetze_letzte_redu_unit(FT, _, _, _, _, _, []) :-
    write('*** Fehler bei uebersetze_letzte_redu_unit:'), nl,
    write(FT), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% uebersetze_instruktion: Ueberprueft einzelne SOWAM-Instruktionen
%  ein> FlatInstruktion
%       UnitNr
%       VarEntries
%	temporaere Variablen
%       pred/func/redu
%  aus> SOWAM-Instruktionen
%       Veraenderte VarEntries
%	veraenderte temporaere Variablen
c2_uebersetze_instruktion(nop, _, VarEntries, TempVars, _,
			  nop, VarEntries, TempVars).
c2_uebersetze_instruktion(get(A1, A2), UnitNr, VarEntries, TempVars, redu,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_bestimme_register(A2, VarEntries, TempVars, HVarEntries, Reg),
    c2_uebersetze_match_instruktion(A1, Reg, UnitNr, HVarEntries, TempVars, 
				    Inst, NeuVarEntries, NeuTempVars).
c2_uebersetze_instruktion(get(A1, A2), UnitNr, VarEntries, TempVars, PFR,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_bestimme_register(A2, VarEntries, TempVars, HVarEntries, Reg),
    c2_uebersetze_get_instruktion(A1, Reg, UnitNr, HVarEntries, TempVars, PFR, 
				  Inst, NeuVarEntries, NeuTempVars).
c2_uebersetze_instruktion(put(A1, A2), UnitNr, VarEntries, TempVars, _,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_bestimme_register(A2, VarEntries, TempVars, HVarEntries, Reg),
    c2_uebersetze_put_instruktion(A1, Reg, UnitNr, HVarEntries, TempVars, 
				  Inst, NeuVarEntries, NeuTempVars).
c2_uebersetze_instruktion(put_unsafe(A1, A2), UnitNr, VarEntries, TempVars, _,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_bestimme_register(A2, VarEntries, TempVars, HVarEntries, Reg),
    c2_uebersetze_put_unsafe_instruktion(A1, Reg, UnitNr, HVarEntries, TempVars, 
					 Inst, NeuVarEntries, NeuTempVars).
c2_uebersetze_instruktion(put_occ(A1), UnitNr, VarEntries, TempVars, _,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_uebersetze_put_occ_instruktion(A1, UnitNr, VarEntries, TempVars, 
				      Inst, NeuVarEntries, NeuTempVars).
c2_uebersetze_instruktion(write(A1), UnitNr, VarEntries, TempVars, _,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_uebersetze_write_instruktion(A1, UnitNr, VarEntries, TempVars, 
				    Inst, NeuVarEntries, NeuTempVars).
c2_uebersetze_instruktion(unify(A1), UnitNr, VarEntries, TempVars, redu,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_uebersetze_read_instruktion(A1, UnitNr, VarEntries, TempVars, 
				   Inst, NeuVarEntries, NeuTempVars).
c2_uebersetze_instruktion(unify(A1), UnitNr, VarEntries, TempVars, _,
			  Inst, NeuVarEntries, NeuTempVars) :-
    c2_uebersetze_unify_instruktion(A1, UnitNr, VarEntries, TempVars, 
				    Inst, NeuVarEntries, NeuTempVars).
% Pseudo-Befehle
c2_uebersetze_instruktion(alloc_temp(VarNr), _, VarEntries, TempVars, _,
			  nop, VarEntries, NeuTempVars) :-
    c2_allocate_temp(VarNr, TempVars, NeuTempVars).
c2_uebersetze_instruktion(free_temp(VarNr), _, VarEntries, TempVars, _,
			  nop, VarEntries, NeuTempVars) :-
    c2_deallocate_temp(VarNr, TempVars, NeuTempVars).
% Diverse Befehle
c2_uebersetze_instruktion(equation, _, VarEntries, TempVars, _,
                          get_value(x(1), x(2)), VarEntries, TempVars).
c2_uebersetze_instruktion(reflection, _, VarEntries, TempVars, _,
                          reflection, VarEntries, TempVars).
c2_uebersetze_instruktion(write_and_ask, _, VarEntries, TempVars, _,
                          write_and_ask(x(1)), VarEntries, TempVars).
c2_uebersetze_instruktion(set_begin_of_term(Arg), _, VarEntries, TempVars, _,
                          set_begin_of_term(Reg), NeuVarEntries, TempVars) :-
    c2_bestimme_register(Arg, VarEntries, TempVars, NeuVarEntries, Reg).
c2_uebersetze_instruktion(l_try_me_else(_,_), _, VarEntries, TempVars, _,
                          nop, VarEntries, TempVars).
c2_uebersetze_instruktion(alloc_occ, _, VarEntries, TempVars, _,
                          nop, VarEntries, TempVars).
c2_uebersetze_instruktion(X, _, VarEntries, TempVars, _, nop, VarEntries, TempVars) :-
    write('*****Fehler bei uebersetze Instruktion***'), nl,
    write(X), nl.


c2_uebersetze_get_instruktion(nil, Reg, _, VarEntries, TempVars, _,
			      get_nil(Reg), VarEntries, TempVars).
c2_uebersetze_get_instruktion(list, Reg, _, VarEntries, TempVars, _,
			      get_list(Reg), VarEntries, TempVars).
c2_uebersetze_get_instruktion(const(Name), Reg, _, VarEntries, TempVars, _,
			      get_constant(Name, Reg), VarEntries, TempVars).
c2_uebersetze_get_instruktion(struct(Name, Stell), Reg, _, VarEntries, TempVars, _,
			      get_structure(Name/Stell, Reg), VarEntries, TempVars).
c2_uebersetze_get_instruktion(var(Name), Reg, UnitNr, VarEntries, TempVars, pred,
			      Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, nein, nein,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_g_var(Klassifikation, Reg, Inst).
c2_uebersetze_get_instruktion(var(Name), Reg, UnitNr, VarEntries, TempVars, func,
			      Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, nein, ja,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_g_var(Klassifikation, Reg, Inst).


c2_uebersetze_match_instruktion(nil, Reg, _, VarEntries, TempVars,
				match_nil(Reg), VarEntries, TempVars).
c2_uebersetze_match_instruktion(list, Reg, _, VarEntries, TempVars,
				match_list(Reg), VarEntries, TempVars).
c2_uebersetze_match_instruktion(const(Name), Reg, _, VarEntries, TempVars,
				match_constant(Name, Reg), VarEntries, TempVars).
c2_uebersetze_match_instruktion(struct(Name, Stell), Reg, _, VarEntries, TempVars,
				match_structure(Name/Stell, Reg), VarEntries, TempVars).
c2_uebersetze_match_instruktion(var(Name), Reg, UnitNr, VarEntries, TempVars,
				Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, nein, ja,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_m_var(Klassifikation, Reg, Inst).


c2_uebersetze_put_instruktion(nil, Reg, _, VarEntries, TempVars,
			      put_nil(Reg), VarEntries, TempVars).
c2_uebersetze_put_instruktion(list, Reg, _, VarEntries, TempVars,
			      put_list(Reg), VarEntries, TempVars).
c2_uebersetze_put_instruktion(const(Name), Reg, _, VarEntries, TempVars,
			      put_constant(Name, Reg), VarEntries, TempVars).
c2_uebersetze_put_instruktion(struct(Name, Stell), Reg, _, VarEntries, TempVars,
			      put_structure(Name/Stell, Reg), VarEntries, TempVars).
c2_uebersetze_put_instruktion(var(Name), Reg, UnitNr, VarEntries, TempVars,
			      Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, nein, nein,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_p_var(Klassifikation, Reg, Inst).
c2_uebersetze_put_instruktion(xvar(VarNr), Reg, _, VarEntries, TempVars,
			      put_variable(x(XNr), Reg), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).
c2_uebersetze_put_instruktion(val(VarNr), Reg, _, VarEntries, TempVars,
			      put_value(x(XNr), Reg), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).


c2_uebersetze_put_unsafe_instruktion(var(Name), Reg, UnitNr, VarEntries, TempVars,
				     Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, vielleicht, nein,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_pu_var(Klassifikation, Reg, Inst).


c2_uebersetze_put_occ_instruktion(nil, _, VarEntries, TempVars,
				  put_nil_occ, VarEntries, TempVars).
c2_uebersetze_put_occ_instruktion(list, _, VarEntries, TempVars,
				  put_list_occ, VarEntries, TempVars).
c2_uebersetze_put_occ_instruktion(const(Name), _, VarEntries, TempVars,
				  put_const_occ(Name), VarEntries, TempVars).
c2_uebersetze_put_occ_instruktion(struct(Name, Stell), _, VarEntries, TempVars,
				  put_struct_occ(Name/Stell), VarEntries, TempVars).
c2_uebersetze_put_occ_instruktion(var(Name), UnitNr, VarEntries, TempVars,
				  Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, nein, nein,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_rp_var(Klassifikation, Inst).
c2_uebersetze_put_occ_instruktion(xvar(VarNr), _, VarEntries, TempVars,
				  put_var_occ(x(XNr)), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).


c2_uebersetze_write_instruktion(nil, _, VarEntries, TempVars,
				write_nil, VarEntries, TempVars).
c2_uebersetze_write_instruktion(list, _, VarEntries, TempVars,
				write_list, VarEntries, TempVars).
c2_uebersetze_write_instruktion(const(Name), _, VarEntries, TempVars,
				write_constant(Name), VarEntries, TempVars).
c2_uebersetze_write_instruktion(var(Name), UnitNr, VarEntries, TempVars,
				Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, ja, nein,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_w_var(Klassifikation, Inst).
c2_uebersetze_write_instruktion(xvar(VarNr), _, VarEntries, TempVars,
				write_variable(x(XNr)), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).
c2_uebersetze_write_instruktion(val(VarNr), _, VarEntries, TempVars,
				write_value(x(XNr)), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).


c2_uebersetze_unify_instruktion(nil, _, VarEntries, TempVars,
				unify_nil, VarEntries, TempVars).
c2_uebersetze_unify_instruktion(list, _, VarEntries, TempVars,
				unify_list, VarEntries, TempVars).
c2_uebersetze_unify_instruktion(const(Name), _, VarEntries, TempVars,
				unify_constant(Name), VarEntries, TempVars).
c2_uebersetze_unify_instruktion(var(Name), UnitNr, VarEntries, TempVars,
				Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, ja, nein,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_u_var(Klassifikation, Inst).
c2_uebersetze_unify_instruktion(xvar(VarNr), _, VarEntries, TempVars,
				unify_variable(x(XNr)), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).
c2_uebersetze_unify_instruktion(val(VarNr), _, VarEntries, TempVars,
				unify_value(x(XNr)), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).


c2_uebersetze_read_instruktion(nil, _, VarEntries, TempVars,
			       read_nil, VarEntries, TempVars).
c2_uebersetze_read_instruktion(list, _, VarEntries, TempVars,
			       read_list, VarEntries, TempVars).
c2_uebersetze_read_instruktion(const(Name), _, VarEntries, TempVars,
			       read_constant(Name), VarEntries, TempVars).
c2_uebersetze_read_instruktion(var(Name), UnitNr, VarEntries, TempVars,
			       Inst, NeuVarEntries, NeuTempVars) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, UnitNr, ja, nein,
			  NeuVarEntries, NeuTempVars, Klassifikation),
    c2_konkret_r_var(Klassifikation, Inst).
c2_uebersetze_read_instruktion(xvar(VarNr), _, VarEntries, TempVars,
			       read_variable(x(XNr)), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).
c2_uebersetze_read_instruktion(val(VarNr), _, VarEntries, TempVars,
			       read_value(x(XNr)), VarEntries, TempVars) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% konkret_rp_var: falls bei einer replace Unit eine Variable als Ersetzung
%                 auftritt, wird hier die Klassifikation bestimmt
%   ein> Klassifikation
%   aus> SOWAM-Instruktion
c2_konkret_rp_var(void(X), put_var_occ(X)).
c2_konkret_rp_var(variable(X), put_var_occ(X)).
c2_konkret_rp_var(value(X), put_value_occ(X)).
c2_konkret_rp_var(unsafe(X), put_unsafe_value_occ(X)).
c2_konkret_rp_var(X, nop) :-
    write('***Fehler bei konkret_rp_var: '), nl,
    write(X), nl.


% konkret_u_var: Klassifikation von Variablen in unify-Instruktionen
%   ein> Klassifikation
%   aus> SOWAM-Instruktion
c2_konkret_u_var(variable(X), unify_variable(X)).
c2_konkret_u_var(value(X), unify_value(X)).
c2_konkret_u_var(local(X), unify_local_value(X)).
c2_konkret_u_var(void(_), unify_void(1)).
c2_konkret_u_var(X, nop) :-
    write('***Fehler bei konkret_u_var: '), nl,
    write(X), nl.


% konkret_r_var: Klassifikation von Variablen in read-Instruktionen
%   ein> Klassifikation
%   aus> SOWAM-Instruktion
c2_konkret_r_var(variable(X), read_variable(X)).
c2_konkret_r_var(value(X), read_value(X)).
c2_konkret_r_var(local(X), read_value(X)).
c2_konkret_r_var(void(_), read_void(1)).
c2_konkret_r_var(X, nop) :-
    write('***Fehler bei konkret_u_var: '), nl,
    write(X), nl.


% konkret_w_var: Klassifikation von Variablen in write-Instruktionen
%   ein> Klassifikation
%   aus> SOWAM-Instruktion
c2_konkret_w_var(variable(X), write_variable(X)).
c2_konkret_w_var(value(X), write_value(X)).
c2_konkret_w_var(local(X), write_local_value(X)).
c2_konkret_w_var(void(_), write_void(1)).
c2_konkret_w_var(X, nop) :-
    write('***Fehler bei konkret_w_var: '), nl,
    write(X), nl.


% konkret_g_var: Klassifikation von Variablen in get-Instruktionen
%   ein> Klassifikation
%	 Ziel-Register
%   aus> SOWAM-Instruktion
c2_konkret_g_var(void(_), _, nop).
c2_konkret_g_var(variable(X), Reg, get_variable(X, Reg)).
c2_konkret_g_var(value(X), Reg, get_value(X, Reg)).
c2_konkret_g_var(X, _, nop) :-
    write('***Fehler bei konkret_g_var: '), nl,
    write(X), nl.


% konkret_m_var: Klassifikation von Variablen in match-Instruktionen
%   ein> Klassifikation
%	 Ziel-Register
%   aus> SOWAM-Instruktion
c2_konkret_m_var(void(_), _, nop).
c2_konkret_m_var(variable(X), Reg, get_variable(X, Reg)).
c2_konkret_m_var(value(X), Reg, match_value(X, Reg)).
c2_konkret_m_var(X, _, nop) :-
    write('***Fehler bei konkret_m_var: '), nl,
    write(X), nl.


% konkret_p_var: Klassifikation von Variablen in put-Instruktionen
%   ein> Klassifikation
%	 Ziel-Register
%   aus> SOWAM-Instruktion
c2_konkret_p_var(void(X), Reg, put_variable(X, Reg)).
c2_konkret_p_var(variable(X), Reg, put_variable(X, Reg)).
c2_konkret_p_var(value(X), Reg, put_value(X, Reg)).
c2_konkret_p_var(unsafe(X), Reg, put_unsafe_value(X, Reg)).
c2_konkret_p_var(X, _, nop) :-
    write('***Fehler bei konkret_p_var: '), nl,
    write(X), nl.


% konkret_pu_var: Generierung von put_unsafe-Instruktion oder nop
%   ein> Klassifikation
%	 Ziel-Register
%   aus> SOWAM-Instruktion
c2_konkret_pu_var(value(X), Reg, put_value(X, Reg)).
c2_konkret_pu_var(varunsafe(X), Reg, [put_variable(X, Reg), put_unsafe_value(X, Reg)]).
c2_konkret_pu_var(unsafe(X), Reg, put_unsafe_value(X, Reg)).
c2_konkret_pu_var(X, _, nop) :-
    write('***Fehler bei konkret_pu_var: '), nl,
    write(X), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% analysiere_literale: Analysiert alle Literale einer Regel
%		       und markiert innere Funktionen
c2_analysiere_literale([], []).
c2_analysiere_literale([fReplace(Arg)|Rest],
		       [fReplace(NeuArg, MaxA)|NeuRest]) :-
    c2_markiere_innerste_funktion(Arg, NeuArg, MaxA, _),
    c2_analysiere_literale(Rest, NeuRest).
c2_analysiere_literale([fEquation(Arg1, Arg2)|Rest],
		       [fEquation(NeuArg1, NeuArg2, IsFunc)|NeuRest]) :-
    c2_analysiere_equation(Arg1, Arg2, NeuArg1, NeuArg2, IsFunc),
    c2_analysiere_literale(Rest, NeuRest).
c2_analysiere_literale([fPredAppl(write_and_ask, Argumente) | Rest],
		       [fPredAppl(write_and_ask, [NeuArg]) | NeuRest]) :-
    c2_analysiere_write_and_ask(Argumente, NeuArg),
    c2_analysiere_literale(Rest, NeuRest).
c2_analysiere_literale([fPredAppl(Praedikat, Argumente) | Rest],
		       [fPredAppl(Praedikat, NeuArgumente) | NeuRest]) :-
    c2_analysiere_bedingung(Argumente, 1, HArgumente),
    c2_sortiere_argumente(HArgumente, NeuArgumente),
    c2_analysiere_literale(Rest, NeuRest).

c2_analysiere_equation(Arg1, Arg2, arg(NeuArg1, MaxA1),
		       NeuArg2, IsFunc) :-
    c2_markiere_innerste_funktion(Arg1, NeuArg1, MaxA1, IsFunc1),
    c2_analysiere_equation(IsFunc1, Arg2, NeuArg2, IsFunc).

c2_analysiere_equation(ja, Arg2, arg(Arg2, 0), ja).
c2_analysiere_equation(nein, Arg2, arg(NeuArg2, MaxA2), IsFunc) :-
    c2_markiere_innerste_funktion(Arg2, NeuArg2, MaxA2, IsFunc).


c2_analysiere_bedingung([], _, []).
c2_analysiere_bedingung([Arg|ArgRest], ArgNr,
			[arg(NeuArg,ArgNr,MaxA,IsFunc)|NeuArgRest]) :-
    c2_markiere_innerste_funktion(Arg, NeuArg, MaxA, IsFunc),
    NeuArgNr is ArgNr + 1,
    c2_analysiere_bedingung(ArgRest, NeuArgNr, NeuArgRest).

% sortiere_argumente: Stellt Argumente ohne Funktionen nach hinten
c2_sortiere_argumente(Args, NeuArgs) :-
    c2_sortiere_argumente(Args, NoFunc, NoFunc, NeuArgs).

c2_sortiere_argumente([], NoFunc, [], NoFunc).
c2_sortiere_argumente([arg(PredArg,Nr,MaxA,ja) | RestArgs], NoFunc, NoFuncRest,
		      [arg(PredArg,Nr,MaxA,ja) | NeuRestArgs]) :-
    c2_sortiere_argumente(RestArgs, NoFunc, NoFuncRest, NeuRestArgs).
c2_sortiere_argumente([arg(PredArg,Nr,MaxA,nein) | RestArgs], NoFunc,
		      [arg(PredArg,Nr,MaxA,nein) | NoFuncRest],
		      NeuArgs) :-
    c2_sortiere_argumente(RestArgs, NoFunc, NoFuncRest, NeuArgs).
    
% analysiere_write_and_ask: Schliesst Liste zu einem Element zusammen
%   ein> Argumentliste von write_and_ask
%   aus> Listenkonstruktor mit Argumenten
c2_analysiere_write_and_ask([], fConsAppl('[]', [])).
c2_analysiere_write_and_ask([Arg|Rest], fConsAppl('.', [NeuArg, HRest])) :-
    c2_analysiere_write_and_ask_argument(Arg, NeuArg),
    c2_analysiere_write_and_ask(Rest, HRest).

c2_analysiere_write_and_ask_argument(fEquation(Arg1, Arg2),
				     fConsAppl('=', NeuArgumente)) :-
    c2_veraendere_write_and_ask_argumente([Arg1, Arg2], NeuArgumente).
c2_analysiere_write_and_ask_argument(fPredAppl(Praedikat, Argumente),
				     fConsAppl(Praedikat,NeuArgumente)) :-
    c2_veraendere_write_and_ask_argumente(Argumente, NeuArgumente).
c2_analysiere_write_and_ask_argument(X,X) :-
    write('*** Fehler bei write_and_ask-Argument: '), write(X), nl.


c2_veraendere_write_and_ask_argumente([], []).
c2_veraendere_write_and_ask_argumente([fFuncAppl(Name, Argumente) | Rest],
				      [fConsAppl(Name, NeuArgumente) | NeuRest]) :-
    c2_veraendere_write_and_ask_argumente(Argumente, NeuArgumente),
    c2_veraendere_write_and_ask_argumente(Rest, NeuRest).
c2_veraendere_write_and_ask_argumente([fConsAppl(Name, Argumente) | Rest],
				      [fConsAppl(Name, NeuArgumente) | NeuRest]) :-
    c2_veraendere_write_and_ask_argumente(Argumente, NeuArgumente),
    c2_veraendere_write_and_ask_argumente(Rest, NeuRest).
c2_veraendere_write_and_ask_argumente([Term | Rest], [Term | NeuRest]) :-
    c2_veraendere_write_and_ask_argumente(Rest, NeuRest).


% markiere_innerste_funktion: markiert die leftmost-innermost Funktion mit
%			      fIFuncAppl - (as)
%  ein> Term
%  aus> evtl. veraenderter Term
%	Argumentzahl der innersten Funktion
%	Funktion vorhanden?
c2_markiere_innerste_funktion(Term, NeuTerm, MaxA, ja) :-
    c2_mark_inner(Term, NeuTerm, MaxA).
c2_markiere_innerste_funktion(Term, Term, 0, nein).

c2_mark_inner(fFuncAppl(Name, Args), fFuncAppl(Name, NeuArgs), MaxA) :-
    c2_args_mark_inner(Args, NeuArgs, MaxA).
c2_mark_inner(fFuncAppl(Name, Args), fIFuncAppl(Name, Args), MaxA) :-
    length(Args, MaxA).
c2_mark_inner(fConsAppl(Name, [Arg|RArgs]), fConsAppl(Name, NeuArgs), MaxA) :-
    c2_args_mark_inner([Arg|RArgs], NeuArgs, MaxA).

c2_args_mark_inner([Arg|RArgs],[NeuArg|RArgs], MaxA) :-
    c2_mark_inner(Arg, NeuArg, MaxA).
c2_args_mark_inner([Arg|RArgs],[Arg|NeuRArgs], MaxA) :-
    c2_args_mark_inner(RArgs, NeuRArgs, MaxA).


% umstrukturieren_der_kopf_argumente: Klopft alle Argumente flach
%  ein> Argumente
%  aus> get-unit
%	neue Variablen-Nr
c2_umstrukturieren_der_kopf_argumente(Argumente,
				      get_unit(MaxA, VarInfos, FlatArgumente),
				      VarNr) :-
    c2_umstrukturieren_der_kopf_argumente(Argumente, 0, 0, [], MaxA,
					  VarInfos, FlatArgumente, VarNr).

% umstrukturieren_der_kopf_argumente: Hilfspraedikat
%  ein> Argumente
%	Argument-Nr
%	Variablen-Nr
%	Listenende der FlatArgumente
%  aus> Anzahl Argumente
%	var_info's
%	FlatArgumente
%	neue Variablen-Nr
c2_umstrukturieren_der_kopf_argumente([], MaxA, VarNr, EFT, MaxA, [], EFT, VarNr).
c2_umstrukturieren_der_kopf_argumente([Argument|Rest], ArgNr, VarNr, EFT, MaxA,
				      VarInfos, FlatArgumente, NeuVarNr) :-
    NeuArgNr is ArgNr + 1,
    c2_verflache_kopf_argumente(Argument, NeuArgNr, VarNr, RestFlatArgumente,
				UVarInfos, FlatArgumente, HVarNr),
    c2_umstrukturieren_der_kopf_argumente(Rest, NeuArgNr, HVarNr, EFT,
					  MaxA, RestVarInfos, 
					  RestFlatArgumente, NeuVarNr),
    c2_ergaenze_var_info(RestVarInfos, UVarInfos, VarInfos).

% umstrukturieren_der_literale: Klopft alle Anfragen flach
%  ein> Praedikat_liste
%	Variablen-Nr
%  aus> Flachgeklopfte_Untereinheiten
%	neue Variablen-Nr
c2_umstrukturieren_der_literale([], VNr, [], VNr).
c2_umstrukturieren_der_literale([fReplace(Arg, MaxA)], VNr,
				[replace_unit(MaxA, VI, FT, Occ)],
				NeuVNr) :-
    c2_verflache_replace_term(Arg, VNr, [], VI, FT, Occ, NeuVNr).
c2_umstrukturieren_der_literale([fEquation(Arg1,Arg2,IsFunc)|Rest], VNr,
				FlatUnits, NeuVNr) :-
    c2_verflache_eine_equation(IsFunc, Arg1, Arg2, VNr, Einheiten, HVNr),
    c2_concat(Einheiten, RestFlatUnits, FlatUnits),
    c2_umstrukturieren_der_literale(Rest, HVNr, RestFlatUnits, NeuVNr).
c2_umstrukturieren_der_literale([fPredAppl(write_and_ask, [Argument])|Rest], VNr,
                                [Unit | RestUnits], NeuVNr) :-
    c2_verflache_write_and_ask(Argument, VNr, Unit, HVNr),
    c2_umstrukturieren_der_literale(Rest, HVNr, RestUnits, NeuVNr).
c2_umstrukturieren_der_literale([fPredAppl(Praedikat, Argumente)|Rest], VNr,
                                FlatUnits, NeuVNr) :-
    c2_verflache_eine_bedingung(Argumente, Praedikat, VNr,
				Einheiten, HVNr),
    c2_concat(Einheiten, RestFlatUnits, FlatUnits),
    c2_umstrukturieren_der_literale(Rest, HVNr, RestFlatUnits, NeuVNr).
c2_umstrukturieren_der_literale(X, VNr, [], VNr) :-
    write('*** Fehler beim umstrukturieren_der_literale:'), nl,
    write(X), nl.

% verflache_eine_bedingung: Klopft eine Bedingung flach
%  ein> Flat_ALF_Term
%       Praedikat_Name
%	Variablen-Nr
%  aus> Flachgeklopfte_Untereinheiten
%	neue Variablen-Nr
c2_verflache_eine_bedingung(Argumente, Praedikat, VNr, Units, NeuVNr) :-
    c2_verflache_narrow_bedingung(Argumente, VNr, 0, N,
				  RestArgs, NarrowUnits, TS, HVNr),
    c2_verflache_rest_bedingung(RestArgs, HVNr, N, [pred(Praedikat, Stell)],
				Stell, FlatArgumente, UVarInfos, NeuVNr),
    c2_save_einordnen(TS, UVarInfos, VarInfos),
    c2_concat(NarrowUnits,
	      [call_unit(Stell, TS, VarInfos, FlatArgumente)], Units).

c2_verflache_narrow_bedingung([], VNr, N, N, [], [], [], VNr).
c2_verflache_narrow_bedingung([arg(FirstArg,ArgNr,MaxA,nein)|Argumente],
			      VNr, N, N,
			      [arg(FirstArg,ArgNr,MaxA,nein)|Argumente],
			      [], [], VNr).
c2_verflache_narrow_bedingung([arg(FirstArg,ArgNr,MaxA,ja)|Argumente],
			      VNr, N, NOut, RestArgs,
			      [narrow_unit(MaxA,VI,FT,Occ,nein)|Units],
			      [TS|RestTS], NeuVNr) :-
    N1 is N+1,
    c2_verflache_narrow_argumente(FirstArg, ArgNr, VNr, [], TS, VI, FT, Occ, HVNr),
    c2_verflache_narrow_bedingung(Argumente, HVNr, N1, NOut, RestArgs,
				  Units, RestTS, NeuVNr).

c2_verflache_rest_bedingung([], VNr, N, EFT, N, EFT, [], VNr).
c2_verflache_rest_bedingung([arg(Arg, ArgNr, _, nein) | RestArgs], VNr, N, EFT,
			    NOut, FlatTerme, VarInfos, NeuVNr) :-
    c2_verflache_rumpf_argumente(Arg, ArgNr, VNr, FTRest,
				 VI1, FlatTerme, HVNr),
    N1 is N + 1,
    c2_verflache_rest_bedingung(RestArgs, HVNr, N1, EFT, NOut, FTRest, VI2, NeuVNr),
    c2_ergaenze_var_info(VI2, VI1, VarInfos).


%c2_verflache_write_and_ask: Klopft write_and_ask-Anfrage flach
%  ein> Flat_ALF_Term
%	Variablen-Nr
%  aus> Unit
%	neue Variablen-Nr
c2_verflache_write_and_ask(Argument, VNr, call_unit(1, [], VI, FT), NeuVNr) :-
    c2_verflache_rumpf_argumente(Argument, 1, VNr, [write_and_ask],
				 VI, FT, NeuVNr).

%c2_verflache_eine_equation: Klopft eine Bedingung flach
%  ein> Funktion vorhanden?
%	1._Argument_der_Gleichung
%       2._Argument_der_Gleichung
%	Variablen-Nr
%  aus> Units
%	neue Variablen-Nr
c2_verflache_eine_equation(nein, arg(FirstArg, _), arg(SecondArg, _), VNr,
			   [call_unit(2, [], VI, FT)], NeuVNr) :-
    c2_verflache_rumpf_argumente(FirstArg, 1, VNr, HFT, VI1, FT, HVNr),
    c2_verflache_rumpf_argumente(SecondArg, 2, HVNr, [equation],
				 VI2, HFT, NeuVNr),
    c2_ergaenze_var_info(VI2, VI1, VI).
c2_verflache_eine_equation(ja, arg(FirstArg, MaxA1), arg(SecondArg, MaxA2), VNr,
			   [narrow_unit(MaxA, Variablen, Konstrukte,
					OccStack, reject),
			    call_unit(0, [], [], [])],
			   NeuVNr) :-
    c2_berechne_groessere_zahl(MaxA1, MaxA2, MaxA),
    UVNr is VNr + 1,
    c2_verflache_rumpf_substrukturen([FirstArg, SecondArg], UVNr,
				     [alloc_temp(UVNr),
				      put(struct('=', 2), x(UVNr)),
				      set_begin_of_term(x(UVNr)),
				      free_temp(UVNr) | NeuArgs],
				     NeuVNr, _, NeuArgs,
				     Konstrukte, Variablen, OccStack).
c2_verflache_eine_equation(_, arg(FirstArg, _), arg(SecondArg, _), VNr, [], VNr) :-
    write('*** verflache_eine_equation:'), nl,
    write([FirstArg, SecondArg]), nl.


% verflache_rumpf_argumente:
%  ein> Term,
%       Argument_Nr;
%	Variablen-Nr
%	Listenende der FlatTerme
%  aus> var_info's
%	FlatTerme
%	neue Variablen-Nr
%c2_verflache_rumpf_argumente(fVar('_'), Nr, VNr, EFT,
%			     [var_info(NeuVNr, einzeln, rumpf, register, lokal)],
%			     [put(var(NeuVNr), a(Nr)) | EFT], NeuVNr) :-
%    NeuVNr is VNr + 1.
c2_verflache_rumpf_argumente(fVar(Var), Nr, VNr, EFT,
			     Variablen,
			     [put(var(Var), a(Nr)) | EFT], VNr) :-
    c2_ergaenze_variable(Var, einzeln, rumpf, register, [], Variablen).
c2_verflache_rumpf_argumente(fNumber(0), Nr, VNr, EFT,
			     [], [put(const('0'), a(Nr)) | EFT], VNr).
c2_verflache_rumpf_argumente(fNumber(Zahl), Nr, VNr, EFT,
			     [], Konstrukte, NeuVNr) :-
    c2_verflache_rumpf_zahl(Zahl, VNr, [put(struct('s', 1), a(Nr)) | EFT1],
			    NeuVNr, NeuArgs, Konstrukte),
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_rumpf_argumente(fConsAppl('[]', []), Nr, VNr, EFT,
                             [], [put(nil, a(Nr)) | EFT], VNr).
c2_verflache_rumpf_argumente(fConsAppl(Symbol,[]), Nr, VNr, EFT,
			     [], [put(const(Symbol), a(Nr)) | EFT], VNr).
c2_verflache_rumpf_argumente(fConsAppl('.', [Arg1,Arg2]), Nr, VNr, EFT,
                             Variablen, Konstrukte, NeuVNr) :-
    c2_verflache_rumpf_substrukturen([Arg1,Arg2], VNr,
				     [put(list, a(Nr)) | EFT1],
				     NeuVNr, 2, NeuArgs,
				     Konstrukte, Variablen, []),
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_rumpf_argumente(fConsAppl(Symbol, Args), Nr, VNr, EFT,
                             Variablen, Konstrukte, NeuVNr) :-
    c2_verflache_rumpf_substrukturen(Args, VNr,
				     [put(struct(Symbol, ArgAnz), a(Nr)) | EFT1],
				     NeuVNr, ArgAnz, NeuArgs,
				     Konstrukte, Variablen, []),
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_rumpf_argumente(X, _, VNr, EFT, [], EFT, VNr) :-
    write('****Fehler - nur Schrott bei verflache_rumpf_argumente:****'), nl,
    write(X), nl.


% verflache_narrow_argumente:
%  ein> Term,
%       Argument_Nr;
%	Variablen-Nr
%	Listenende der FlatTerme
%  aus> to_save
%	var_info's
%	FlatTerme
%	Liste der Occurences
%	neue Variablen-Nr
c2_verflache_narrow_argumente(fConsAppl('.', [Arg1,Arg2]), Nr, VNr, EFT,
			      to_save(Nr, NeuVNr),
			      [var_info(NeuVNr,mehrfach,rumpf,
					struktur,lokal)|Variablen],
			      Konstrukte, OccStack, NeuVNr) :-
    c2_verflache_rumpf_substrukturen([Arg1,Arg2], VNr,
				     [put(list, y(NeuVNr)),
				      set_begin_of_term(y(NeuVNr)) | EFT1],
				     UVNr, 2, NeuArgs, Konstrukte, Variablen,
				     OccStack),
    NeuVNr is UVNr + 1,
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_narrow_argumente(fConsAppl(Symbol, Args), Nr, VNr, EFT,
			      to_save(Nr, NeuVNr),
			      [var_info(NeuVNr,mehrfach,rumpf,
					struktur,lokal)|Variablen],
			      Konstrukte, OccStack, NeuVNr) :-
    c2_verflache_rumpf_substrukturen(Args, VNr,
				     [put(struct(Symbol, ArgAnz), y(NeuVNr)),
				      set_begin_of_term(y(NeuVNr)) | EFT1],
				     UVNr, ArgAnz, NeuArgs, Konstrukte, Variablen,
				     OccStack),
    NeuVNr is UVNr + 1,
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_narrow_argumente(fIFuncAppl(Symbol, Args), Nr, VNr, EFT,
			      to_save(Nr, NeuVNr),
			      [var_info(NeuVNr,mehrfach,rumpf,
					struktur,lokal)|Variablen],
			      Konstrukte, [load(y(NeuVNr))], NeuVNr) :-
    c2_verflache_innere_args(Args, 1, VNr,
			     [write(var(NeuVNr)),
			      set_begin_of_term(y(NeuVNr)),
			      call_rewriting(Symbol,ArgAnz) | EFT],
			     UVNr, ArgAnz, Konstrukte, Variablen),
    NeuVNr is UVNr + 1.
c2_verflache_narrow_argumente(fFuncAppl(Symbol, [Arg1|ArgsRest]), Nr, VNr, EFT,
			      to_save(Nr, NeuVNr),
			      [var_info(NeuVNr,mehrfach,rumpf,
					struktur,lokal)|Variablen],
			      Konstrukte,
			      [push(y(NeuVNr))|NeuOccStack],
			      NeuVNr) :-
    c2_verflache_rumpf_substrukturen([Arg1|ArgsRest], VNr,
				     [put(struct(Symbol, ArgAnz), y(NeuVNr)),
				      set_begin_of_term(y(NeuVNr)) | EFT1],
				     UVNr, ArgAnz, NeuArgs,
				     Konstrukte, Variablen, NeuOccStack),
    NeuVNr is UVNr + 1,
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_narrow_argumente(X, _, VNr, EFT, to_save(0, 0), [], EFT, [], VNr) :-
    write('****Fehler - nur Schrott bei verflache_narrow_argumente:****'), nl,
    write(X), nl.


% verflache_rumpf_substrukturen:
%  ein> Terme,
%       Aktuelle_Variablen_Nr-1,
%	Listenende der flachgeklopften Terme,
%  aus> Neue_Variablen_Nr_nach_dem_Aufruf,
%       Argument-Anzahl_der_uebergeordneten_Struktur,
%       Liste_der_neuen_Argumente_fuer_die_uebergeordnete_Struktur,
%       Liste_der_flachgeklopften_Terme,
%       Liste_aller_nichtlokalen_Variablen,
%       Liste_der_Occurrences;
c2_verflache_rumpf_substrukturen([], VNr, EFT, VNr, 0, [], EFT, [], []).
% Void
%c2_verflache_rumpf_substrukturen([fVar('_')|Rest], VNr, EFT,
%                                 NeuVNr, ArgAnz, [write(var(UVNr))|NeuArgs],
%                                 FlatTerms,
%				 [var_info(UVNr,einzeln,rumpf,
%					   struktur,lokal)|Variablen],
%				 OccStack) :-
%    UVNr is VNr + 1,
%    c2_verflache_rumpf_substrukturen(Rest, UVNr, EFT,
%				     NeuVNr, ArgAnzDummy, NeuArgs,
%				     FlatTerms, Variablen, OccStack),
%    ArgAnz is ArgAnzDummy+1.
c2_verflache_rumpf_substrukturen([fVar(Var)|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz, [write(var(Var))|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    c2_verflache_rumpf_substrukturen(Rest, VNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     FlatTerms, VarDummy, OccStack),
    ArgAnz is ArgAnzDummy+1,
    c2_ergaenze_variable(Var, einzeln, rumpf, struktur, VarDummy, Variablen).
c2_verflache_rumpf_substrukturen([fNumber(0)|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz, [write(const('0'))|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    c2_verflache_rumpf_substrukturen(Rest, VNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     FlatTerms, Variablen, OccStack),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_rumpf_substrukturen([fNumber(Zahl)|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz,
				 [write(val(UVNr)), free_temp(UVNr)|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    UVNr is VNr+1,
    c2_verflache_rumpf_zahl(Zahl, UVNr,
			    [alloc_temp(UVNr),
			     put(struct('s', 1), x(UVNr)) | LocFTerms],
			    NeuUVNr, NeuUArgs, FlatTerms),
    c2_concat(NeuUArgs, NeuFlatTerms, LocFTerms),
    c2_verflache_rumpf_substrukturen(Rest, NeuUVNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     NeuFlatTerms, Variablen, OccStack),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_rumpf_substrukturen([fConsAppl('[]', [])|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz, [write(nil)|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    c2_verflache_rumpf_substrukturen(Rest, VNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     FlatTerms, Variablen, OccStack),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_rumpf_substrukturen([fConsAppl(Symbol, [])|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz, [write(const(Symbol))|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    c2_verflache_rumpf_substrukturen(Rest, VNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     FlatTerms, Variablen, OccStack),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_rumpf_substrukturen([fConsAppl('.', [Arg1,Arg2])|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz,
				 [write(val(UVNr)),free_temp(UVNr)|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    UVNr is VNr+1,
    c2_verflache_rumpf_substrukturen([Arg1,Arg2], UVNr,
				     [alloc_temp(UVNr),
				      put(list, x(UVNr)) | LocFTerms],
				     NeuUVNr, 2, NeuUArgs,
				     FlatTerms, UVariablen, UOccStack),
    c2_concat(NeuUArgs, NeuFlatTerms, LocFTerms),
    c2_verflache_rumpf_substrukturen(Rest, NeuUVNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     NeuFlatTerms, VarDummy, NeuOccStack),
    ArgAnz is ArgAnzDummy+1,
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen),
    c2_concat(NeuOccStack, UOccStack, OccStack).
c2_verflache_rumpf_substrukturen([fConsAppl(Symbol, UArgs)|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz,
				 [write(val(UVNr)),free_temp(UVNr)|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    UVNr is VNr+1,
    c2_verflache_rumpf_substrukturen(UArgs, UVNr,
				     [alloc_temp(UVNr),
				      put(struct(Symbol, UArgAnz), x(UVNr))|LocFTerms],
				     NeuUVNr, UArgAnz, NeuUArgs,
				     FlatTerms, UVariablen, UOccStack),
    c2_concat(NeuUArgs, NeuFlatTerms, LocFTerms),
    c2_verflache_rumpf_substrukturen(Rest, NeuUVNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     NeuFlatTerms, VarDummy, NeuOccStack),
    ArgAnz is ArgAnzDummy+1,
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen),
    c2_concat(NeuOccStack, UOccStack, OccStack).
c2_verflache_rumpf_substrukturen([fIFuncAppl(Symbol, UArgs)|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz,
				 [alloc_temp(UVNr),
				  write(xvar(UVNr))|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    UVNr is VNr+1,
    c2_verflache_innere_args(UArgs, 1, UVNr, NeuFlatTerms,
			     NeuUVNr, UArgsAnz, FlatTerms, UVariablen),
    c2_verflache_rumpf_substrukturen(Rest, NeuUVNr,
				     [call_rewriting(Symbol,UArgsAnz) | EFT],
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     NeuFlatTerms, VarDummy, NeuOccStack),
    ArgAnz is ArgAnzDummy+1,
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen),
    c2_concat(NeuOccStack, [load(x(UVNr))], OccStack).
c2_verflache_rumpf_substrukturen([fFuncAppl(Symbol, UArgs)|Rest], VNr, EFT,
                                 NeuVNr, ArgAnz,
				 [write(val(UVNr))|NeuArgs],
                                 FlatTerms, Variablen, OccStack) :-
    UVNr is VNr+1,
    c2_verflache_rumpf_substrukturen(UArgs, UVNr,
				     [alloc_temp(UVNr),
				      put(struct(Symbol, UArgAnz), x(UVNr))
					  | LocFTerms],
				     NeuUVNr, UArgAnz, NeuUArgs,
				     FlatTerms, UVariablen, UOccStack),
    c2_concat(NeuUArgs, NeuFlatTerms, LocFTerms),
    c2_verflache_rumpf_substrukturen(Rest, NeuUVNr, EFT,
				     NeuVNr, ArgAnzDummy, NeuArgs,
				     NeuFlatTerms, VarDummy, NeuOccStack),
    ArgAnz is ArgAnzDummy+1,
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen),
    c2_concat(NeuOccStack, [push(x(UVNr))|UOccStack], OccStack).
c2_verflache_rumpf_substrukturen([X|_], VNr, EFT, VNr, 0, [], EFT, [], []) :-
    write('*** Fehler - nur Unterschrott bei verflache_rumpf_substrukturen:'), nl,
    write(X), nl.

% verflache_innere_args - (as)
%  ein> Argumente,
%	Argument-Nummer,
%	Aktuelle_Variablen_Nr-1,
%	Listenende der flachgeklopften Terme,
%  aus> Neue_Variablen_Nr_nach_dem_Aufruf,
%	Argument-Anzahl_der_uebergeordneten_Struktur,
%       Liste_der_flachgeklopften_Terme,
%       Liste_aller_nichtlokalen_Variablen:
c2_verflache_innere_args([], ArgNr, VNr, EFT, VNr, ArgAnz, EFT, []) :-
    ArgAnz is ArgNr-1.
%c2_verflache_innere_args([fVar('_')|Rest], ArgNr, VNr, EFT,
%			 NeuVNr, ArgAnz,
%			 [put_unsafe(var(UVNr),a(ArgNr))|FlatTerms],
%			 [var_info(UVNr,mehrfach,rumpf,
%				   register,lokal)|Variablen]) :-
%    NeuArgNr is ArgNr + 1,
%    UVNr is VNr + 1,
%    c2_verflache_innere_args(Rest, NeuArgNr, UVNr, EFT,
%			     NeuVNr, ArgAnz, FlatTerms, Variablen).
c2_verflache_innere_args([fVar(Var)|Rest], ArgNr, VNr, EFT,
			 NeuVNr, ArgAnz,
			 [put_unsafe(var(Var),a(ArgNr))|FlatTerms],
			 Variablen) :-
    NeuArgNr is ArgNr + 1,
    c2_verflache_innere_args(Rest, NeuArgNr, VNr, EFT,
			     NeuVNr, ArgAnz, FlatTerms, VarDummy),
    c2_ergaenze_variable(Var, mehrfach, rumpf, register, VarDummy, Variablen).
c2_verflache_innere_args([fNumber(0)|Rest], ArgNr, VNr, EFT,
			 NeuVNr, ArgAnz,
			 [put(const('0'),a(ArgNr))|FlatTerms], Variablen) :-
    NeuArgNr is ArgNr + 1,
    c2_verflache_innere_args(Rest, NeuArgNr, VNr, EFT,
			     NeuVNr, ArgAnz, FlatTerms, Variablen).
c2_verflache_innere_args([fNumber(Zahl)|Rest], ArgNr, VNr, EFT,
			 NeuVNr, ArgAnz, FlatTerms, Variablen) :-
    c2_verflache_rumpf_zahl(Zahl, VNr, [put(struct('s', 1), a(ArgNr)) | LocFTerms],
			    NeuUVNr, NeuUArgs, FlatTerms),
    c2_concat(NeuUArgs, NeuFlatTerms, LocFTerms),
    NeuArgNr is ArgNr + 1,
    c2_verflache_innere_args(Rest, NeuArgNr, NeuUVNr, EFT,
			     NeuVNr, ArgAnz, NeuFlatTerms, Variablen).
c2_verflache_innere_args([fConsAppl('[]', [])|Rest], ArgNr, VNr, EFT,
			 NeuVNr, ArgAnz,
			 [put(nil, a(ArgNr))|FlatTerms], Variablen) :-
    NeuArgNr is ArgNr + 1,
    c2_verflache_innere_args(Rest, NeuArgNr, VNr, EFT,
			     NeuVNr, ArgAnz, FlatTerms, Variablen).
c2_verflache_innere_args([fConsAppl(Symbol, [])|Rest], ArgNr, VNr, EFT,
			 NeuVNr, ArgAnz,
			 [put(const(Symbol),a(ArgNr))|FlatTerms], Variablen) :-
    NeuArgNr is ArgNr + 1,
    c2_verflache_innere_args(Rest, NeuArgNr, VNr, EFT,
			     NeuVNr, ArgAnz, FlatTerms, Variablen).
c2_verflache_innere_args([fConsAppl('.', [Arg1,Arg2])|Rest], ArgNr, VNr, EFT,
			 NeuVNr, ArgAnz, FlatTerms, Variablen) :-
    c2_verflache_rumpf_substrukturen([Arg1,Arg2], VNr,
				     [put(list, a(ArgNr)) | LocFTerms],
				     NeuUVNr, 2, NeuUArgs,
				     FlatTerms, UVariablen, []),
    c2_concat(NeuUArgs, NeuFlatTerms, LocFTerms),
    NeuArgNr is ArgNr + 1,
    c2_verflache_innere_args(Rest, NeuArgNr, NeuUVNr, EFT,
			     NeuVNr, ArgAnz, NeuFlatTerms, VarDummy),
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen).
c2_verflache_innere_args([fConsAppl(Symbol, UArgs)|Rest], ArgNr, VNr, EFT,
			 NeuVNr, ArgAnz, FlatTerms, Variablen) :-
    c2_verflache_rumpf_substrukturen(UArgs, VNr,
				     [put(struct(Symbol, UArgAnz), a(ArgNr))
					  | LocFTerms],
				     NeuUVNr, UArgAnz, NeuUArgs,
				     FlatTerms, UVariablen, []),
    c2_concat(NeuUArgs, NeuFlatTerms, LocFTerms),
    NeuArgNr is ArgNr + 1,
    c2_verflache_innere_args(Rest, NeuArgNr, NeuUVNr, EFT,
			     NeuVNr, ArgAnz, NeuFlatTerms, VarDummy),
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen).
c2_verflache_innere_args([X|_], _, VNr, EFT, VNr, 0, EFT, []) :-
    write('*** Fehler - nur Innerschrott bei verflache_innere_args:'), nl,
    write(X), nl.


% verflache_kopf_argumente:
%  ein> Term,
%       Argument_Nr;
%	Variablen-Nr
%	Listenende der FlatTerme
%  aus> VarInfos
%	FlatTerme
%	neue Variablen-Nr
%c2_verflache_kopf_argumente(fVar('_'), Nr, VarNr, EFT,
%			    [var_info(NeuVarNr,einzeln,kopf,register,lokal)],
%			    [get(var(NeuVarNr), a(Nr)) | EFT],
%			    NeuVarNr) :-
%    NeuVarNr is VarNr + 1.
c2_verflache_kopf_argumente(fVar(Var), Nr, VarNr, EFT,
			    Variablen,
			    [get(var(Var), a(Nr)) | EFT], VarNr) :-
    c2_ergaenze_variable(Var, einzeln, kopf, register, [], Variablen).
c2_verflache_kopf_argumente(fNumber(0), Nr, VarNr, EFT,
                            [], [get(const('0'), a(Nr)) | EFT], VarNr).
c2_verflache_kopf_argumente(fNumber(Zahl), Nr, VarNr, EFT,
			    [], [get(struct('s', 1), a(Nr)) | Konstrukte],
			    NeuVarNr) :-
    c2_verflache_kopf_zahl(Zahl, VarNr, EFT, NeuVarNr, Konstrukte).
c2_verflache_kopf_argumente(fConsAppl('[]', []), Nr, VarNr, EFT,
                            [], [get(nil, a(Nr)) | EFT], VarNr).
c2_verflache_kopf_argumente(fConsAppl(Symbol,[]), Nr, VarNr, EFT,
                            [], [get(const(Symbol), a(Nr)) | EFT], VarNr).
c2_verflache_kopf_argumente(fConsAppl('.', [Arg1|Arg2]), Nr, VarNr, EFT,
                            Variablen, [get(list, a(Nr))|Konstrukte],
			    NeuVarNr) :-
    c2_verflache_kopf_substrukturen([Arg1|Arg2], VarNr, EFT,
				    NeuVarNr, 2, NeuArgs,
				    FlatTerms, Variablen),
    c2_concat(NeuArgs, FlatTerms, Konstrukte).
c2_verflache_kopf_argumente(fConsAppl(Symbol, Args), Nr, VarNr, EFT,
                            Variablen,
			    [get(struct(Symbol, ArgAnz), a(Nr)) | Konstrukte],
			    NeuVarNr) :-
    c2_verflache_kopf_substrukturen(Args, VarNr, EFT,
				    NeuVarNr, ArgAnz, NeuArgs,
				    FlatTerms, Variablen),
    c2_concat(NeuArgs, FlatTerms, Konstrukte).
c2_verflache_kopf_argumente(fFuncAppl(Symbol, Args), Nr, VarNr, EFT,
                            Variablen,
			    [get(struct(Symbol, ArgAnz), a(Nr)) | Konstrukte],
			    NeuVarNr) :-
    c2_verflache_kopf_substrukturen(Args, VarNr, EFT,
				    NeuVarNr, ArgAnz, NeuArgs,
				    FlatTerms, Variablen),
    c2_concat(NeuArgs, FlatTerms, Konstrukte).
c2_verflache_kopf_argumente(X, _, VarNr, EFT, [], EFT, VarNr) :-
    write('****Fehler - nur Schrott bei verflache_kopf_argumente:****'), nl,
    write(X), nl.

% verflache_kopf_substrukturen:
%  ein>	Terme,
%	Aktuelle_Variablen_Nr;
%	Listenende der flachgeklopften Terme,
%  aus>	Neue_Variablen_Nr_nach_dem_Aufruf,
%	Argument-Anzahl_der_uebergeordneten_Struktur,
%	Liste_der_neuen_Argumente_fuer_die_uebergeordnete_Struktur,
%	Liste_der_flachgeklopften_Terme,
%	Liste_aller_nichtlokalen_Variablen,
c2_verflache_kopf_substrukturen([], VNr, EFT, VNr, 0, [], EFT, []).
%c2_verflache_kopf_substrukturen([fVar('_')|Rest], VNr, EFT,
%                                NeuVNr, ArgAnz, [unify(var(UVNr))|NeuArgs],
%                                FlatTerms, Variablen) :-
%    UVNr is VNr + 1,
%    c2_verflache_kopf_substrukturen(Rest, UVNr, EFT,
%				    NeuVNr, ArgAnzDummy, NeuArgs,
%				    FlatTerms, VarDummy),
%    ArgAnz is ArgAnzDummy+1,
%    c2_ergaenze_var_info([var_info(UVNr,einzeln,kopf,struktur,lokal)],
%			 VarDummy, Variablen).
c2_verflache_kopf_substrukturen([fVar(Var)|Rest], VNr, EFT,
                                NeuVNr, ArgAnz, [unify(var(Var))|NeuArgs],
                                FlatTerms, Variablen) :-
    c2_verflache_kopf_substrukturen(Rest, VNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    FlatTerms, VarDummy),
    ArgAnz is ArgAnzDummy+1,
    c2_ergaenze_variable(Var, einzeln, kopf, struktur, VarDummy, Variablen).
c2_verflache_kopf_substrukturen([fNumber(0)|Rest], VNr, EFT,
                                NeuVNr, ArgAnz, [unify(const('0'))|NeuArgs],
                                FlatTerms, Variablen) :-
    c2_verflache_kopf_substrukturen(Rest, VNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    FlatTerms, Variablen),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_kopf_substrukturen([fNumber(Zahl)|Rest], VNr, EFT,
                                NeuVNr, ArgAnz,
				[alloc_temp(UVNr),unify(xvar(UVNr))|NeuArgs],
                                [get(struct('s', 1), x(UVNr)),
				 free_temp(UVNr) | FlatTerms],
				Variablen) :-
    UVNr is VNr+1,
    c2_verflache_kopf_zahl(Zahl, UVNr, NeuFlatTerms, NeuUVNr, FlatTerms),
    c2_verflache_kopf_substrukturen(Rest, NeuUVNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    NeuFlatTerms, Variablen),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_kopf_substrukturen([fConsAppl('[]', [])|Rest], VNr, EFT,
                                NeuVNr, ArgAnz, [unify(nil)|NeuArgs],
                                FlatTerms, Variablen) :-
    c2_verflache_kopf_substrukturen(Rest, VNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    FlatTerms, Variablen),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_kopf_substrukturen([fConsAppl(Symbol, [])|Rest], VNr, EFT,
                                NeuVNr, ArgAnz, [unify(const(Symbol))|NeuArgs],
                                FlatTerms, Variablen) :-
    c2_verflache_kopf_substrukturen(Rest, VNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    FlatTerms, Variablen),
    ArgAnz is ArgAnzDummy+1.
c2_verflache_kopf_substrukturen([fConsAppl('.', [Arg1,Arg2])|Rest], VNr, EFT,
                                NeuVNr, ArgAnz,
				[alloc_temp(UVNr),unify(xvar(UVNr))|NeuArgs],
                                [get(list, x(UVNr)), free_temp(UVNr)|FlatTerms],
				Variablen) :-
    UVNr is VNr+1,
    c2_verflache_kopf_substrukturen([Arg1,Arg2], UVNr, NeuFlatTerms,
				    NeuUVNr, 2, NeuUArgs,
				    LocFTerms, UVariablen),
    c2_verflache_kopf_substrukturen(Rest, NeuUVNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    NeuFlatTerms, VarDummy),
    ArgAnz is ArgAnzDummy+1,
    c2_concat(NeuUArgs, LocFTerms, FlatTerms),
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen).
c2_verflache_kopf_substrukturen([fConsAppl(Symbol, UArgs)|Rest], VNr, EFT,
                                NeuVNr, ArgAnz,
				[alloc_temp(UVNr),unify(xvar(UVNr))|NeuArgs],
                                [get(struct(Symbol, UArgAnz), x(UVNr)),
				 free_temp(UVNr)|FlatTerms],
				Variablen) :-
    UVNr is VNr+1,
    c2_verflache_kopf_substrukturen(UArgs, UVNr, NeuFlatTerms,
				    NeuUVNr, UArgAnz, NeuUArgs,
				    LocFTerms, UVariablen),
    c2_verflache_kopf_substrukturen(Rest, NeuUVNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    NeuFlatTerms, VarDummy),
    ArgAnz is ArgAnzDummy+1,
    c2_concat(NeuUArgs, LocFTerms, FlatTerms),
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen).
c2_verflache_kopf_substrukturen([fFuncAppl(Symbol, UArgs)|Rest], VNr, EFT,
                                NeuVNr, ArgAnz,
				[alloc_temp(UVNr),unify(xvar(UVNr))|NeuArgs],
                                [get(struct(Symbol, UArgAnz), x(UVNr)),
				 free_temp(UVNr)|FlatTerms],
				Variablen) :-
    UVNr is VNr+1,
    c2_verflache_kopf_substrukturen(UArgs, UVNr, NeuFlatTerms,
				    NeuUVNr, UArgAnz, NeuUArgs,
				    LocFTerms, UVariablen),
    c2_verflache_kopf_substrukturen(Rest, NeuUVNr, EFT,
				    NeuVNr, ArgAnzDummy, NeuArgs,
				    NeuFlatTerms, VarDummy),
    ArgAnz is ArgAnzDummy+1,
    c2_concat(NeuUArgs, LocFTerms, FlatTerms),
    c2_ergaenze_var_info(UVariablen, VarDummy, Variablen).
c2_verflache_kopf_substrukturen([X|_], VNr, EFT, VNr, 0, [], EFT, []) :-
    write('*** Fehler - nur Unterschrott bei verflache_kopf_substrukturen:'), nl,
    write(X), nl.


% verflache_replace_term:
%  ein> Term,
%	Variablen-Nr
%	Listenende der FlatTerme
%  aus> var_info's
%	FlatTerme
%       Liste_der_Occurrences;
%	neue Variablen-Nr
%c2_verflache_replace_term(fVar('_'), VNr, EFT,
%			  [var_info(NeuVNr,einzeln,rumpf,struktur,lokal)],
%			  [put_occ(var(NeuVNr)) | EFT], [], NeuVNr) :-
%    NeuVNr is VNr + 1.
c2_verflache_replace_term(fVar(Var), VNr, EFT,
			  Variablen,
			  [put_occ(var(Var)) | EFT], [], VNr) :-
    c2_ergaenze_variable(Var, einzeln, rumpf, struktur, [], Variablen).
c2_verflache_replace_term(fNumber(0), VNr, EFT,
			  [], [put_occ(const('0')) | EFT], [], VNr).
c2_verflache_replace_term(fNumber(Zahl), VNr, EFT,
			  [], Konstrukte, [], NeuVNr) :-
    c2_verflache_rumpf_zahl(Zahl, VNr, [put_occ(struct('s', 1)) | EFT1],
			    NeuVNr, NeuArgs, Konstrukte),
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_replace_term(fConsAppl('[]', []), VNr, EFT,
			  [], [put_occ(nil) | EFT], [], VNr).
c2_verflache_replace_term(fConsAppl(Symbol,[]), VNr, EFT,
			  [], [put_occ(const(Symbol)) | EFT], [], VNr).
c2_verflache_replace_term(fConsAppl('.', [Arg1,Arg2]), VNr, EFT,
			  Variablen, Konstrukte, OccStack, NeuVNr) :-
    c2_verflache_rumpf_substrukturen([Arg1,Arg2], VNr,
				     [put_occ(list) | EFT1],
				     NeuVNr, 2, NeuArgs, Konstrukte, Variablen,
				     OccStack),
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_replace_term(fConsAppl(Symbol, Args), VNr, EFT,
			  Variablen, Konstrukte, OccStack, NeuVNr) :-
    c2_verflache_rumpf_substrukturen(Args, VNr,
				     [put_occ(struct(Symbol, ArgAnz)) | EFT1],
				     NeuVNr, ArgAnz, NeuArgs,
				     Konstrukte, Variablen, OccStack),
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_replace_term(fIFuncAppl(Symbol, Args), VNr, EFT,
			  Variablen, Konstrukte, [load(x(UVNr))], NeuVNr) :-
    UVNr is VNr + 1,
    c2_verflache_innere_args(Args, 1, UVNr,
			     [alloc_temp(UVNr), put_occ(xvar(UVNr)),
			      call_rewriting(Symbol,ArgAnz) | EFT],
			     NeuVNr, ArgAnz, Konstrukte, Variablen).
c2_verflache_replace_term(fFuncAppl(Symbol, [Arg1|ArgsRest]), VNr, EFT,
			  Variablen, Konstrukte,
			  [push(ao)|NeuOccStack], NeuVNr) :-
    c2_verflache_rumpf_substrukturen([Arg1|ArgsRest], VNr,
				     [put_occ(struct(Symbol, ArgAnz)) | EFT1],
				     NeuVNr, ArgAnz, NeuArgs,
				     Konstrukte, Variablen, NeuOccStack),
    c2_concat(NeuArgs, EFT, EFT1).
c2_verflache_replace_term(X, VNr, EFT, [], EFT, [], VNr) :-
    write('****Fehler - nur Schrott bei verflache_replace_term:****'), nl,
    write(X), nl.


% verflache_kopf_zahl: verflacht eine Zahl >= 1 im Kopf einer Regel
%  ein>	Zahl,
%	Aktuelle_Variablen_Nr;
%	Listenende_der_flachgeklopften_Terme 
%  aus>	Neue_Variablen_Nr_nach_dem_Aufruf,
%	Liste_der_flachgeklopften_Terme,
c2_verflache_kopf_zahl(0, VNr, ListEnde, VNr, ListEnde) :-
    write('****Fehler bei verflache_kopf_zahl, Zahl < 1****'), nl.
c2_verflache_kopf_zahl(1, VNr, ListEnde, VNr, [unify(const('0')) | ListEnde]).
c2_verflache_kopf_zahl(Zahl_plus_1, VNr, ListEnde, NeuVNr,
		       [alloc_temp(UVNr), unify(xvar(UVNr)),
			get(struct('s', 1), x(UVNr)),
			free_temp(UVNr) | FlatTerms]) :-
    UVNr is VNr + 1,
    Zahl is Zahl_plus_1 - 1,
    c2_verflache_kopf_zahl(Zahl, UVNr, ListEnde, NeuVNr, FlatTerms).


% verflache_rumpf_zahl: verflacht eine Zahl >= 1 im Rumpf einer Regel
%  ein>	Zahl,
%	Aktuelle_Variablen_Nr;
%	Listenende_der_flachgeklopften_Terme 
%  aus>	Neue_Variablen_Nr_nach_dem_Aufruf,
%	Liste_der_Argumente_fuer_die_uebergeordnete_Struktur,
%	Liste_der_flachgeklopften_Terme,
c2_verflache_rumpf_zahl(0, VNr, ListEnde, VNr, [], ListEnde) :-
    write('****Fehler bei verflache_rumpf_zahl, Zahl < 1****'), nl.
c2_verflache_rumpf_zahl(Zahl, VNr, ListEnde, NeuVNr,
			[NeuArg1, NeuArg2], FlatTerms) :-
    c2_verflache_rumpf_zahl(Zahl, VNr, ListEnde, NeuVNr,
			    NeuArg1, NeuArg2, FlatTerms).

c2_verflache_rumpf_zahl(1, VNr, ListEnde, VNr, write(const('0')), nop, ListEnde).
c2_verflache_rumpf_zahl(Zahl_plus_1, VNr, ListEnde, NeuVNr,
		       write(val(UVNr)), free_temp(UVNr), FlatTerms) :-
    UVNr is VNr + 1,
    Zahl is Zahl_plus_1 - 1,
    c2_verflache_rumpf_zahl(Zahl, UVNr,
			    [alloc_temp(UVNr), put(struct('s', 1), x(UVNr)),
			     NeuArg1, NeuArg2 | ListEnde],
			    NeuVNr, NeuArg1, NeuArg2, FlatTerms).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% get_unit_einordnen: Verbindet eine get_unit ggf. mit der ersten Unit einer
%		      Liste
%  ein> Get-Unit
%       Unit-Liste
%  aus> Ergenis-Liste
c2_get_unit_einordnen(get_unit(MA1, V1, T1),
		      [narrow_unit(MA2, V2, T2, O2, R2)|Rest],
		      [narrow_unit(MA, VL, TL, O2, R2)|Rest]) :-
    c2_ergaenze_var_info(V1, V2, VL),
    c2_berechne_groessere_zahl(MA1, MA2, MA),
    c2_concat(T1, T2, TL).
c2_get_unit_einordnen(get_unit(MA1, V1, T1),
		      [call_unit(MA2, NL, V2, T2)|Rest],
		      [call_unit(MA, NL, VL, TL)|Rest]) :-
    c2_ergaenze_var_info(V1, V2, VL),
    c2_berechne_groessere_zahl(MA1, MA2, MA),
    c2_concat(T1, T2, TL).
c2_get_unit_einordnen(get_unit(MA1, V1, T1),
		      [replace_unit(MA2, V2, T2, O2)|Rest],
		      [replace_unit(MA, VL, TL, O2)|Rest]) :-
    c2_ergaenze_var_info(V1, V2, VL),
    c2_berechne_groessere_zahl(MA1, MA2, MA),
    c2_concat(T1, T2, TL).
c2_get_unit_einordnen(get_unit(MA1, V1, T1),
		      [get_unit(MA2, V2, T2)|Rest],
		      [get_unit(MA, VL, TL)|Rest]) :-
    c2_ergaenze_var_info(V1, V2, VL),
    c2_berechne_groessere_zahl(MA1, MA2, MA),
    c2_concat(T1, T2, TL).
c2_get_unit_einordnen(get_unit(MA1, V1, T1),
		      Rest,
		      [get_unit(MA1, V1, T1) | Rest]).


% save_einordnen: ergaenzt VarInfo um die zu gesicherten Argumente
%  ein> gesicherte Argumentregister
%       VarInfo's
%  aus> Veraenderte VarInfo's
c2_save_einordnen([], X, X).
c2_save_einordnen([to_save(_, YReg)|TSRest], VarInfo, NeuVarInfo) :-
    c2_save_einordnen(TSRest, [var_info(YReg,einzeln,rumpf,struktur,lokal)|VarInfo],
		      NeuVarInfo).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c2_var_sammeln: dient dazu Informationen ueber alle vorkommenden Variablen
%              zusammenzustellen.
%  ein> Units nach dem ersten Schritt
%       Minimale Permanente Variable
%	Variablen-Nr
%  aus> Liste von "var_entry,s"
%       Liste der maximalen Globalen Variablen die man in den Units benoetigt
%       Anzahl der Units
%       Ist allocate noetig
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c2_var_sammeln(Units, StartY, VarNr,
	       variablen(UnitAnzahl, EntryListe),
	       rule_info(MaxYListe, UnitAnzahl, AllocNoetig, AllocOccNoetig)) :-
    c2_var_sammeln_vorbereitung(Units, 0, [],
				VorVarListe, UnitAnzahl,
				AllocOccNoetig),
    c2_var_sammeln_global(VorVarListe, UnitAnzahl, StartY, VarNr, [],
			  EntryListe, MaxYListe),
    c2_var_sammeln_allocate_test(UnitAnzahl, AllocNoetig).

% var_sammeln_allocate_test
%  ein> UnitAnzahl
%  aus> ist allocate noetig
c2_var_sammeln_allocate_test(1, nein).
c2_var_sammeln_allocate_test(_, ja).

% var_sammeln_vorbereitung: holt alle Variablenvorkommen aus den Units
%  ein> Units nach dem ersten Schritt
%	Unit_Nr
%	Listenende
%  aus> Liste von Listen aus 'eintrag(...)'
%	UnitAnzahl
%	Ist allocate-occ noetig
c2_var_sammeln_vorbereitung([], Nr, L, L, Nr, nein).
c2_var_sammeln_vorbereitung([get_unit(_, VL, _)|Rest], Nr, EndL,
			    Liste, MaxUnit, AllocOccNoetig) :-
    NeuNr is Nr + 1,
    c2_var_sammeln_vorbereitung(Rest, NeuNr, [eintrag(NeuNr, VL)|EndL],
				Liste, MaxUnit, AllocOccNoetig).
c2_var_sammeln_vorbereitung([narrow_unit(_, VL, _, _, _)|Rest], Nr, EndL,
			    Liste, MaxUnit, ja) :-
    NeuNr is Nr + 1,
    c2_var_sammeln_vorbereitung(Rest, NeuNr, [eintrag(NeuNr, VL)|EndL],
				Liste, MaxUnit, _).
c2_var_sammeln_vorbereitung([replace_unit(_, VL, _, _)|Rest], Nr, EndL,
			    Liste, MaxUnit, AllocOccNoetig) :-
    NeuNr is Nr + 1,
    c2_var_sammeln_vorbereitung(Rest, NeuNr, [eintrag(NeuNr, VL)|EndL],
				Liste, MaxUnit, AllocOccNoetig).
c2_var_sammeln_vorbereitung([call_unit(_, _, VL, _)|Rest], Nr, EndL,
			    Liste, MaxUnit, AllocOccNoetig) :-
    NeuNr is Nr + 1,
    c2_var_sammeln_vorbereitung(Rest, NeuNr, [eintrag(NeuNr, VL)|EndL],
				Liste, MaxUnit, AllocOccNoetig).


% var_sammeln_global: Liefert Informationen zu allen Variablen
%  ein> Liste_von_eintraegen_fuer_alle_Units,
%       Anzahl_der_Units,
%       Minimale_Y_Variable,
%	Variablen-Nr
%	MYL-Ende
%  aus> Liste_von_'var_Entries',
%       Liste_der_maximalen_globalen_Variablen_die_in_der_Unit_noch_gebraucht_werden
c2_var_sammeln_global([], _, _, _, MYL, [], MYL).
c2_var_sammeln_global([eintrag(_, [])|Rest], UnitAnzahl, Maxy, VarNr, MYL_Ende,
                      Ausgabe, MaxYList) :-
    c2_var_sammeln_global(Rest, UnitAnzahl, Maxy, VarNr, [Maxy|MYL_Ende],
			  Ausgabe, MaxYList).
c2_var_sammeln_global([eintrag(UnitNr, [X|RestInfo])|Rest],
		      UnitAnzahl, MaxY, VarNr, MYL_Ende,
		      [VarEntry|VorAusgabe], MaxYList) :-
    c2_var_sammeln_eine_global(X, Rest, UnitAnzahl, UnitNr, MaxY, VarNr,
			       VarEntry, NeuRest, NeuMaxY, NeuVarNr),
    c2_var_sammeln_global([eintrag(UnitNr, RestInfo)|NeuRest],
			  UnitAnzahl, NeuMaxY, NeuVarNr, MYL_Ende,
			  VorAusgabe, MaxYList).

% var_sammeln_eine_global: Liefert Informationen zu einer Variable
%  ein> var_info(...),
%       Var_Informationen_der_vorangegangenen_Units,
%       Anzahl_der_Units,
%       Aktuelle_UnitNr,(wird heruntergezaehlt)
%       Maximale_Y_Variable,
%       Variablen-Nr
%  aus> var_entry(...),
%       Modifizierte_Var_Informationen_der_vorangegangenen_Units,
%       Neue_Maximale_Y_Variable.
%	neue Variablen-Nr
c2_var_sammeln_eine_global(VarInfo, EL, MaxUnitNr, UnitNr,
			   MaxY, VarNr,
			   VarEntry, NeuEL, NeuMaxY, NeuVarNr) :-
    c2_var_sammeln_lokal(EL, VarInfo, NeuEL, NeuVarInfo),
    c2_var_sammeln_hilf(NeuVarInfo, MaxUnitNr, UnitNr, MaxY, VarNr,
			VarEntry, NeuMaxY, NeuVarNr).
c2_var_sammeln_eine_global(X, Y, _, _, MaxY, VarNr,
			   _, [], MaxY, VarNr) :-
    write('var_sammeln gescheitert: '), write(X), nl, write(Y), nl.


% 1. mal im Kopf
c2_var_sammeln_hilf(var_info(X, Anz, kopf, _, lokal), _, _,
		    MaxY, VarNr,
		    var_entry(X, temporaer, x(NeuVarNr), Anz, neu, nein),
		    MaxY, NeuVarNr) :-
    NeuVarNr is VarNr + 1.
% 1. mal in Struktur
c2_var_sammeln_hilf(var_info(X, Anz, _, struktur, lokal), _, _,
		    MaxY, VarNr,
		    var_entry(X, temporaer, x(NeuVarNr), Anz, neu, nein),
		    MaxY, NeuVarNr) :-
    NeuVarNr is VarNr + 1.
% Nur im letzten Block
c2_var_sammeln_hilf(var_info(X, Anz, _, _, lokal), UnitNr, UnitNr,
		    MaxY, VarNr,
		    var_entry(X, temporaer, x(NeuVarNr), Anz, neu, nein),
		    MaxY, NeuVarNr) :-
    NeuVarNr is VarNr + 1.
% 1. mal weder im Kopf noch in Struktur
c2_var_sammeln_hilf(var_info(X, Anz, rumpf, register, _), _, _,
		    MaxY, VarNr,
		    var_entry(X, unsicher, y(NeuMaxY), Anz, neu, nein),
		    NeuMaxY, VarNr) :-
    NeuMaxY is MaxY + 1.
% Ansonsten
c2_var_sammeln_hilf(var_info(X, Anz, _, _, _), _, _,
		    MaxY, VarNr,
		    var_entry(X, permanent, y(NeuMaxY), Anz, neu, nein),
		    NeuMaxY, VarNr) :-
    NeuMaxY is MaxY + 1.


c2_var_sammeln_lokal([], X, [], X).
c2_var_sammeln_lokal([eintrag(N, InfoList)|Rest], X,
		     [eintrag(N, NeuInfoList)|NeuRest], NeuX) :-
    c2_var_sammeln_eine_lokal(InfoList, X, HNeuX, NeuInfoList),
    c2_var_sammeln_lokal(Rest, HNeuX, NeuRest, NeuX).


% var_sammeln_eine_lokal: Findet Informationen zu einer Variable und bindet sie
%                         ggf. ein
%   ein> Var_Informationen_einer_Unit,
%        var_info(...),
%   aus> Modifiziertes_var_info(...),
%        Modifizierte_Var_Informationen_einer_Unit.
c2_var_sammeln_eine_lokal([], VI, VI, []).
c2_var_sammeln_eine_lokal([var_info(VI, _, IK, IS, _)|InfoList],
			  var_info(VI, _, _, _, _),
			  var_info(VI, mehrfach, IK, IS, global), InfoList).
c2_var_sammeln_eine_lokal([VI2|InfoList], VI, NeuVarInfo, [VI2|NeuInfoList]) :-
    c2_var_sammeln_eine_lokal(InfoList, VI, NeuVarInfo, NeuInfoList).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% var_klassifikation:
%  ein> Liste_aller_var_Entries
%       Var_Bezeichner
%	temporaere Variablen
%       aktuelle_Unit_Nr
%       Ist_die_Var_in_einer_Struktur,
%       War in Struktur -> setzen,
%  aus> modifizierte_Liste_aller_var_Entries,
%	neue Temporaere Variablen
%       Klassifikation.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c2_var_klassifikation(variablen(MaxUnits, VarEntries), TempVars,
		      Var, AktUnitNr, InStrukt, WarInStrukt,
		      variablen(MaxUnits, NeuVarEntries), NeuTempVars,
		      Klassifikation) :-
    c2_var_klassifikation(VarEntries, TempVars, Var, AktUnitNr, MaxUnits,
			  InStrukt, WarInStrukt,
			  NeuVarEntries, NeuTempVars, Klassifikation).


c2_var_klassifikation([], Var, TempVars, _, _, _, _, [], TempVars, void(x(0))) :-
    write('*** Fehler bei var_klassifikation mit: '), write(Var), nl.
c2_var_klassifikation([var_entry(Var, Art, Nr, Anz, Auftr, _)|Rest],
		      Var, TempVars, AktUnitNr, MaxUnits, InStrukt, ja,
		      [Modifiziertes_var_entry|Rest], NeuTempVars,
		      Klassifikation) :-
    c2_var_klass_main(var_entry(Var, Art, Nr, Anz, Auftr, ja),
		      TempVars, AktUnitNr, MaxUnits, InStrukt,
		      Modifiziertes_var_entry, NeuTempVars,
		      Klassifikation).
c2_var_klassifikation([var_entry(Var, Art, Nr, Anz, Auftr, WarInS)|Rest],
		      Var, TempVars, AktUnitNr, MaxUnits, InStrukt, nein,
		      [Modifiziertes_var_entry|Rest], NeuTempVars,
		      Klassifikation) :-
    c2_var_klass_main(var_entry(Var, Art, Nr, Anz, Auftr, WarInS),
		      TempVars, AktUnitNr, MaxUnits, InStrukt,
		      Modifiziertes_var_entry, NeuTempVars,
		      Klassifikation).
c2_var_klassifikation([Var2|Rest],
		      Var, TempVars, AktUnitNr, MaxUnits, InStrukt, WarInStrukt,
		      [Var2|NeuRest], NeuTempVars,
		      Klassifikation) :-
    c2_var_klassifikation(Rest,
			  Var, TempVars, AktUnitNr, MaxUnits, InStrukt, WarInStrukt,
			  NeuRest, NeuTempVars,
			  Klassifikation).

% var_klass_main: Nimmt die eigentliche Klassifikation der Variablen vor
%  ein> var_entry;
%	temporaere Variablen
%       aktuelle_Unit_Nr
%	maximale Unit-Nr
%       Ist_die_Var_in_einer_Struktur,
%  aus> modifiziertes_var_entry,
%	neue temporaere Variablen
%       Klassifikation.
c2_var_klass_main(var_entry(Bezeichner, temporaer, RegSpec, einzeln, neu, _),
                  TempVars, _, _, _,
                  var_entry(Bezeichner, temporaer, Reg, einzeln, nichtneu, ja),
		  NeuTempVars,
                  void(Reg)) :-
    c2_hole_neues_register(RegSpec, TempVars, NeuTempVars, Reg).

% Fuer Funktionsaufrufe:
c2_var_klass_main(var_entry(Bezeichner, Art, RegSpec, Anzahl, neu, nein),
		  TempVars, _, _, vielleicht,
		  var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, ja),
		  NeuTempVars,
		  varunsafe(Reg)) :-
    c2_hole_neues_register(RegSpec, TempVars, NeuTempVars, Reg).

c2_var_klass_main(var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, nein),
		  TempVars, _, _, vielleicht,
		  var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, ja),
		  TempVars,
		  unsafe(Reg)).

c2_var_klass_main(var_entry(Bezeichner, Art, RegSpec, Anzahl, neu, WasInStrukt),
                  TempVars, _, _, IsInStrukt,
                  var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, AktInStrukt),
		  NeuTempVars,
		  variable(Reg)) :-
    c2_hole_neues_register(RegSpec, TempVars, NeuTempVars, Reg),
    c2_get_instrukt(IsInStrukt, WasInStrukt, AktInStrukt).

c2_var_klass_main(var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, nein),
                  TempVars, _, _, ja,
                  var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, ja),
		  TempVars,
		  local(Reg)).

c2_var_klass_main(var_entry(Bezeichner, unsicher, Reg, Anzahl, nichtneu, nein),
		  TempVars, BlockNr, BlockNr, nein,
		  var_entry(Bezeichner, unsicher, Reg, Anzahl, nichtneu, ja),
		  TempVars,
		  unsafe(Reg)).

c2_var_klass_main(var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, WasInStrukt),
		  TempVars, _, _, IsInStrukt,
		  var_entry(Bezeichner, Art, Reg, Anzahl, nichtneu, AktInStrukt),
		  TempVars,
		  value(Reg)) :-
    c2_get_instrukt(IsInStrukt, WasInStrukt, AktInStrukt).

c2_var_klass_main(X, TempVars, _, _, _, X, TempVars, void(x(0))) :-
    write('Fehler bei var_klass_main: '), write(X), nl.

c2_get_instrukt(ja, _, ja).
c2_get_instrukt(nein, WasInStrukt, WasInStrukt).
c2_get_instrukt(vielleicht, WasInStrukt, WasInStrukt).

c2_hole_neues_register(y(Nr), TempVars, TempVars, y(Nr)).
c2_hole_neues_register(x(VarNr), TempVars, NeuTempVars, x(XNr)) :-
    c2_allocate_temp(VarNr, TempVars, NeuTempVars),
    c2_suche_temp_var(NeuTempVars, VarNr, XNr).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Verwandelt fConsDecl in entry
c2_transformiere_cons_decl([], []).
c2_transformiere_cons_decl([fFuncDecl(Name, Stell, Art, Prec)|Rest],
			   [entry(Name/Stell,cons, NeuArt,NeuPrec)|NeuRest]):-
    c2_transformiere_optyp(Art, Prec, NeuArt, NeuPrec),
    c2_transformiere_cons_decl(Rest, NeuRest).

% Vereinigt Narrow_Decl und Rewrite_Label
c2_vervollstaendige_func_decl([], []).
c2_vervollstaendige_func_decl([entry(_, func(_, RLbl), _, _)|Rest1],
                              [RLbl|Rest2]):-
    c2_vervollstaendige_func_decl(Rest1, Rest2).
c2_vervollstaendige_func_decl(X, Y):-
    write('Fehler bei vereinige Decl: '), write(X), nl, write(Y), nl.

% Liefert die groessere von zwei Zahlen
c2_berechne_groessere_zahl(Zahl1, Zahl2, Zahl1) :-
    Zahl1 > Zahl2.
c2_berechne_groessere_zahl(_, Zahl2, Zahl2).

% Setzt aus einer Vorsilbe und einer Zahl einen LabelNamen zusammen
c2_erstelle_name(String, Zahl, Name) :-
    name(String, NList1),
    name(Zahl, NList2),
    c2_concat(NList1, NList2, NList),
    name(Name, NList).

% Passt die FlatALF-Typenbezeichnung an
c2_transformiere_optyp(parameter, _, nofix, -1).
c2_transformiere_optyp(Art, Prec, Art, Prec).

% Gibt die Element-Anzahl in einer Liste aus
c2_berechne_element_anzahl(Liste, Anz) :-
    c2_berechne_element_anzahl(Liste, 0, Anz).

c2_berechne_element_anzahl([], Anz, Anz).
c2_berechne_element_anzahl([_|Rest], Anz, NeuAnz) :-
    HAnz is Anz + 1,
    c2_berechne_element_anzahl(Rest, HAnz, NeuAnz).

% Vereinigt zwei Listen
c2_concat([],L,L).
c2_concat([E|R],L,[E|RL]) :-
    c2_concat(R,L,RL).

%  Setzt ein Label vor den Code
c2_verbinde_code_mit_label([X|Code], LblName, [(LblName:X)|Code]).

% Generiert falls noetig einen l_try_me... Befehl
c2_pruefe_l_try_me_else(rule_info(_, 1, _, _), _, []).
c2_pruefe_l_try_me_else(_, X, [X]).

% Gibt den Schluss-Code aus der notwendig wird falls l_try.. vorkommt
c2_pruefe_l_trust(rule_info(_, 1, _, _), _, []).
c2_pruefe_l_trust(RuleInfo, LocLblName, Code):-
%    c2_pruefe_deallocate_occ(RuleInfo, ACode),
    c2_pruefe_deallocate(RuleInfo, BCode),
    c2_concat(BCode, [fail], DCode),
%    c2_concat(ACode, CCode, DCode),
    c2_verbinde_code_mit_label([l_trust_me_else_fail|DCode], LocLblName, Code).

% Generiert falls noetig einen set_begin_of_term-Befehl
c2_pruefe_set_begin_of_term(nein, _, []).
c2_pruefe_set_begin_of_term(ja, Reg, [set_begin_of_term(Reg)]).

% Generiert falls noetig einen allocate Befehl
c2_pruefe_allocate(rule_info(_, _, ja, _), [allocate]).
c2_pruefe_allocate(rule_info(_, _, nein, _), []).

% Generiert falls noetig einen deallocate Befehl
c2_pruefe_deallocate(rule_info(_, _, ja, _), [deallocate]).
c2_pruefe_deallocate(rule_info(_, _, nein, _), []).

% Generiert falls noetig einen allocate_occ Befehl
c2_pruefe_allocate_occ(rule_info(_, _, _, ja), [allocate_occ]).
c2_pruefe_allocate_occ(rule_info(_, _, _, nein), []).

% Generiert falls noetig einen deallocate_occ Befehl
c2_pruefe_deallocate_occ(rule_info(_, _, _, ja), [deallocate_occ]).
c2_pruefe_deallocate_occ(rule_info(_, _, _, nein), []).

% finde_max_perm_in_unit:
%   ein> Unit-Nr
%        Max-Y-Liste
%   aus> Maximal in der Unit gebrauchte Y-Variable
c2_finde_max_perm_in_unit(1, [Erg|_], Erg).
c2_finde_max_perm_in_unit(Nr, [_|Rest], Erg) :-
    Nr>1,
    NrMinusEins is Nr - 1,
    c2_finde_max_perm_in_unit(NrMinusEins, Rest, Erg).

% get_ynr: gibt die Nr eines Y-Registers aus 
%  ein> klassifikation
%  aus> Nr
c2_get_ynr(variable(y(Frei)), Frei).
c2_get_ynr(value(y(Frei)), Frei).
c2_get_ynr(Klassifikation, 0) :-
    write('Fehler in get_ynr: '), write(Klassifikation), nl.


% fasst falls notwendig zwei void Instr. zusammen und schliesst die restl.
% Befehle zusammen
c2_eliminiere_doppelvoid([], []).
c2_eliminiere_doppelvoid([Inst|Rest], NeuCode) :-
    c2_eliminiere_doppelvoid(Inst, Rest, NeuCode).

c2_eliminiere_doppelvoid([Inst|Rest], Code, NeuCode) :-
    c2_concat(Rest, Code, HCode),
    c2_eliminiere_doppelvoid(Inst, HCode, NeuCode).
c2_eliminiere_doppelvoid(nop, [], []).
c2_eliminiere_doppelvoid(nop, [Inst|Rest], NeuCode) :-
    c2_eliminiere_doppelvoid(Inst, Rest, NeuCode).
c2_eliminiere_doppelvoid(unify_void(HVoidAnz), [unify_void(1)|Rest], NeuCode) :-
    VoidAnz is HVoidAnz +1,
    c2_eliminiere_doppelvoid(unify_void(VoidAnz), Rest, NeuCode).
c2_eliminiere_doppelvoid(read_void(HVoidAnz), [read_void(1)|Rest], NeuCode) :-
    VoidAnz is HVoidAnz +1,
    c2_eliminiere_doppelvoid(read_void(VoidAnz), Rest, NeuCode).
c2_eliminiere_doppelvoid(write_void(HVoidAnz), [write_void(1)|Rest], NeuCode) :-
    VoidAnz is HVoidAnz +1,
    c2_eliminiere_doppelvoid(write_void(VoidAnz), Rest, NeuCode).
c2_eliminiere_doppelvoid(Inst, [nop | Rest], NeuCode) :-
    c2_eliminiere_doppelvoid(Inst, Rest, NeuCode).
c2_eliminiere_doppelvoid(Inst1, [Inst2 | Rest], [Inst1 | NeuCode]) :-
    c2_eliminiere_doppelvoid(Inst2, Rest, NeuCode).
c2_eliminiere_doppelvoid(Inst, [], [Inst]).

% Prueft ob die Argument-Anzahl mit der Stelligkeit uebereinstimmt, und
% liefert bei Erfolg das erste Argument zurueck
c2_pruefe_argumente([], 0, fVar(_)).
c2_pruefe_argumente([FirstArgument|Rest], Stell, FirstArgument) :-
    c2_pruefe_argumente_uproc([FirstArgument|Rest], Stell).

% Unterprozedur zu pruefe_argumente
c2_pruefe_argumente_uproc([], 0).
c2_pruefe_argumente_uproc([_|Rest], Stell) :-
    StellDummy is Stell-1,
    c2_pruefe_argumente_uproc(Rest, StellDummy).

% hole_gesicherte: generiert eine put_value-Folge die gesicherte Argumente
%                  erneuert
%   ein> gesicherte Argumente
%	 UnitNr
%        VarEntries (upgedaten unnoetig, da die Var nicht mehr vorkommt)
%   aus> Liste von put_value Instruktionen
c2_hole_gesicherte([],_,_,[]).
c2_hole_gesicherte([to_save(ArgNr, YReg)|Rest], UnitNr, VarEntries,
                   [put_value(y(YNr), x(ArgNr))|Code]) :-
    c2_var_klassifikation(VarEntries, YReg, _, UnitNr, nein, ja,
			  _, _, Klassifikation),
    c2_get_ynr(Klassifikation, YNr),
    c2_hole_gesicherte(Rest, UnitNr, VarEntries, Code).


% allocate_temp: freies X-Register holen und als belegt kennzeichnen
c2_allocate_temp(VarNr, temp(MA, XList), temp(MA, NeuXList)) :-
    c2_allocate_temp(XList, MA, VarNr, NeuXList).

c2_allocate_temp([], LastX, VarNr, [alloc(VarNr, XNr)]) :-
    XNr is LastX + 1.
c2_allocate_temp([free(XNr) | Rest], _, VarNr, [alloc(VarNr, XNr) | Rest]).
c2_allocate_temp([alloc(Var, XNr) | Rest], _, VarNr,
		 [alloc(Var, XNr) | NeuRest]) :-
    c2_allocate_temp(Rest, XNr, VarNr, NeuRest).

% deallocate_temp: X-Register freigeben
c2_deallocate_temp(VarNr, temp(MA, XList), temp(MA, NeuXList)) :-
    c2_gebe_temp_frei(XList, VarNr, NeuXList).

c2_gebe_temp_frei([alloc(VarNr, _)], VarNr, []).
c2_gebe_temp_frei([alloc(VarNr, XNr) | Rest], VarNr, [free(XNr)|Rest]).
c2_gebe_temp_frei([X | Rest], VarNr, [X | NeuRest]) :-
    c2_gebe_temp_frei(Rest, VarNr, NeuRest).
c2_gebe_temp_frei([], VarNr, []) :-
    write('*** Register '), write(VarNr), write(' nicht gefunden!!??!!'), nl.


% bestimme_register: uebersetzt eine Registerspezifikation
c2_bestimme_register(a(Nr), VarEntries, _, VarEntries, x(Nr)).
c2_bestimme_register(x(VarNr), VarEntries, TempVars, VarEntries, x(XNr)) :-
    c2_suche_temp_var(TempVars, VarNr, XNr).
c2_bestimme_register(y(Name), VarEntries, TempVars, NeuVarEntries, y(YNr)) :-
    c2_var_klassifikation(VarEntries, Name, TempVars, 1, nein, ja,
			  NeuVarEntries, _, Klassifikation),
    c2_get_ynr(Klassifikation, YNr).

% baue_occ_stack: Liefert die Instruktionen fuer den OccStack
%  ein> OccStack-Zwischencode
%	Variablen
%	temporaere Variablen
%  aus> OccStack-Instruktionen
c2_baue_occ_stack([], _, _, []).
c2_baue_occ_stack([OccIns | ORest], VarEntries, TempVars, [Ins | Rest]) :-
    c2_occ_stack_instruktion(OccIns, VarEntries, TempVars, Ins),
    c2_baue_occ_stack(ORest, VarEntries, TempVars, Rest).

c2_occ_stack_instruktion(push(ao), _, _,
			 push_act_occ).
c2_occ_stack_instruktion(push(Arg), VarEntries, TempVars,
			 push_occ(Reg)) :-
    c2_bestimme_register(Arg, VarEntries, TempVars, _, Reg).
c2_occ_stack_instruktion(load(Arg), VarEntries, TempVars,
			 load_occ(Reg)) :-
    c2_bestimme_register(Arg, VarEntries, TempVars, _, Reg).


% suche_temp_var: sucht die Nummer einer allozierten temporaeren Variable
c2_suche_temp_var(temp(_, XList), VarNr, XNr) :-
    c2_suche_temp(XList, VarNr, XNr).

c2_suche_temp([alloc(VarNr, XNr)|_], VarNr, XNr).
c2_suche_temp([alloc(_,_) | Rest], VarNr, XNr) :-
    c2_suche_temp(Rest, VarNr, XNr).
c2_suche_temp([free(_) | Rest], VarNr, XNr) :-
    c2_suche_temp(Rest, VarNr, XNr).
c2_suche_temp([], VarNr, 1) :-
    write('*** Temporaeres Register '), write(VarNr),
    write(' nicht gefunden ***'), nl.

% Die VarInfo-Liste wird um neue var_infos erweitert
c2_ergaenze_var_info([], Ziel, Ziel).
c2_ergaenze_var_info([X|Rest], Ziel, Ergebnis) :-
    c2_vergleiche_var_info(Ziel, X, NeuZiel),
    c2_ergaenze_var_info(Rest, NeuZiel, Ergebnis).

% Verhindert das var_infos doppelt vorkommen und bringt ihre Informationen
% auf den neuesten Stand
c2_vergleiche_var_info([], X, [X]).
c2_vergleiche_var_info([var_info(Var, _, _, _, lokal)|Rest],
                       var_info(Var, _, ImKopf, InStrukt, lokal),
                       [var_info(Var, mehrfach, ImKopf, InStrukt, lokal)|Rest]).
c2_vergleiche_var_info([VI1|Rest], VI, [VI1|Erg]) :-
    c2_vergleiche_var_info(Rest, VI, Erg).

% Ergaenzt die VarInfo-Liste um eine neue Variable
%% Falls ungebunden (= erstes Auftreten im Term), wird sie an ein neues
%% Symbol gebunden -> schon beim Einlesen passiert
%c2_ergaenze_variable(Var, Anzahl, ImKopf, InStrukt, VarInfo, NeuVarInfo) :-
%    var(Var), !,
%    gensym(variable, Var),
%    NeuVarInfo = [var_info(Var, Anzahl, ImKopf, InStrukt, lokal) | VarInfo].
c2_ergaenze_variable(Var, Anzahl, ImKopf, InStrukt, VarInfo, NeuVarInfo) :-
    c2_vergleiche_var_info(VarInfo,
			   var_info(Var, Anzahl, ImKopf, InStrukt, lokal),
			   NeuVarInfo).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Geruest-Funktionen

% Die ersten Argumente werden vor der Uebergabe an das Geruest-Modul
% entsprechend modifiziert
%   ein> Flat-ALF Argumente
%   aus> Geruest-spezifische Argumente
c2_transformiere_erste_args([], []).
c2_transformiere_erste_args([fVar(_)|Rest], [var|Ausgabe]) :-
    c2_transformiere_erste_args(Rest, Ausgabe).
%c2_transformiere_erste_args([fConsAppl('[]',[])|Rest], [nil|Ausgabe]) :-
%    c2_transformiere_erste_args(Rest, Ausgabe).
c2_transformiere_erste_args([fConsAppl(Symbol,[])|Rest],
			    [const(Symbol)|Ausgabe]) :-
    c2_transformiere_erste_args(Rest, Ausgabe).
c2_transformiere_erste_args([fFuncAppl(Symbol,[])|Rest],
			    [const(Symbol)|Ausgabe]) :-
    c2_transformiere_erste_args(Rest, Ausgabe).
c2_transformiere_erste_args([fConsAppl('.', [_, _])|Rest], [list|Ausgabe]) :-
    c2_transformiere_erste_args(Rest, Ausgabe).
c2_transformiere_erste_args([fConsAppl(Symbol, Args)|Rest],
			    [struct(Symbol,Stell)|Ausgabe]) :-
    c2_berechne_element_anzahl(Args, Stell),
    c2_transformiere_erste_args(Rest, Ausgabe).
c2_transformiere_erste_args([fFuncAppl(Symbol, Args)|Rest],
			    [struct(Symbol,Stell)|Ausgabe]) :-
    c2_berechne_element_anzahl(Args, Stell),
    c2_transformiere_erste_args(Rest, Ausgabe).
c2_transformiere_erste_args([X|Rest], [var|Ausgabe]) :-
    write('Fehler in erstem Argument: '), write(X), nl,
    c2_transformiere_erste_args(Rest, Ausgabe).

% c2_baue_geruest_fuer_pred
%   ein> Regel-Anzahl
%        Stelligkeit
%        Das erste Argument jeder Regel
%   aus> Prozedur-Geruest
c2_baue_geruest_fuer_pred(0, _, _, [pseudocode(ll1)]).
c2_baue_geruest_fuer_pred(Anz, Stell, FirstArgs, Skelett) :-
%    write(pred(Stell, Anz, FirstArgs)),nl,
    c4_build_skeleton(pred(Stell, Anz, FirstArgs), Skelett).
%    drucke_liste(Skelett), nl.
c2_baue_geruest_fuer_pred(_, _, FA, []) :-
    write('Fehler bei build-skeleton:'), nl,
    write(FA), nl.

% c2_baue_geruest_fuer_total
%   ein> Regel-Anzahl
%        Stelligkeit
%        Das erste Argument jeder Regel
%   aus> Prozedur-Geruest
c2_baue_geruest_fuer_total(0, _, _, [pseudocode(ll1)]).
c2_baue_geruest_fuer_total(Anz, Stell, FirstArgs, Skelett) :-
%    write(func(Stell, Anz, FirstArgs)),nl,
    c4_build_skeleton(func(Stell, Anz, FirstArgs), Skelett).
c2_baue_geruest_fuer_total(_, _, FA, []) :-
    write('Fehler bei build-skeleton:'), nl,
    write(FA), nl.

% c2_baue_geruest_fuer_nicht_total
%   ein> Regel-Anzahl
%        Stelligkeit
%        Das erste Argument jeder Regel
%   aus> Prozedur-Geruest
c2_baue_geruest_fuer_nicht_total(0, _, _, [pseudocode(ll1)]).
c2_baue_geruest_fuer_nicht_total(Anz, Stell, FirstArgs, Skelett) :-
    c2_concat(FirstArgs, [var], NeuFirstArgs),
    NeuAnz is Anz + 1,
%    write(func(Stell, NeuAnz, NeuFirstArgs)),nl,
    c4_build_skeleton(func(Stell, NeuAnz, NeuFirstArgs), Skelett).
c2_baue_geruest_fuer_nicht_total(_, _, FA, []) :-
    write('Fehler bei build-skeleton:'), nl,
    write(FA), nl.

% c2_baue_geruest_fuer_redu
%   ein> Regel-Anzahl
%        Stelligkeit
%        Das erste Argument jeder Regel
%   aus> Prozedur-Geruest
c2_baue_geruest_fuer_redu(0, _, _, [pseudocode(ll1)]).
c2_baue_geruest_fuer_redu(Anz, Stell, FirstArgs, Skelett) :-
    c2_concat(FirstArgs, [var], NeuFirstArgs),
    NeuAnz is Anz + 1,
%    write(redu(Stell, NeuAnz, NeuFirstArgs)),nl,
    c4_build_skeleton(redu(Stell, NeuAnz, NeuFirstArgs), Skelett).
c2_baue_geruest_fuer_redu(_, _, FA, []) :-
    write('Fehler bei build-skeleton:'), nl,
    write(FA), nl.

% vereinige_geruest_mit_pred:
%   ein> Geruest (Liste von Konstruktoren: code, Pseudocode)
%        Innerer Code (Liste von Instruktions-Listen)
%   aus> Liste von Instruktionen
c2_vereinige_geruest_mit_pred([pseudocode(Label)], [], [(Label:fail)]).
c2_vereinige_geruest_mit_pred([pseudocode(Label)], [CL], NeuCl) :-
    c2_verbinde_code_mit_label(CL, Label, NeuCl).
c2_vereinige_geruest_mit_pred([code(nolabel, G)|GRest], CL, [G|RestCode]) :-
    c2_vereinige_geruest_mit_pred(GRest, CL, RestCode).
c2_vereinige_geruest_mit_pred([code(Label, G)|GRest], CL,
                              [(Label:G)|RestCode]) :-
    c2_vereinige_geruest_mit_pred(GRest, CL, RestCode).
c2_vereinige_geruest_mit_pred([pseudocode(Label)|GRest], [CL|Rest],
                              Code) :-
    c2_verbinde_code_mit_label(CL, Label, NeuCl),
    c2_concat(NeuCl, RestCode, Code),
    c2_vereinige_geruest_mit_pred(GRest, Rest, RestCode).
c2_vereinige_geruest_mit_pred(X, Y, []) :-
    write('Fehler bei c2_vereinige_geruest_mit_pred : '), write(X), nl,
    write(Y), nl.

% vereinige_geruest_mit_total:
%   ein> Geruest (Liste von Konstruktoren: code, Pseudocode)
%        Innerer Code (Liste von Instruktions-Listen)
%   aus> Liste von Instruktionen
c2_vereinige_geruest_mit_total([pseudocode(Label)], [], [(Label:fail)]).
c2_vereinige_geruest_mit_total([pseudocode(Label)], [CL], NeuCl) :-
    c2_verbinde_code_mit_label(CL, Label, NeuCl).
c2_vereinige_geruest_mit_total([code(nolabel, G)|GRest], CL, [G|RestCode]) :-
    c2_vereinige_geruest_mit_total(GRest, CL, RestCode).
c2_vereinige_geruest_mit_total([code(Label, G)|GRest], CL,
			       [(Label:G)|RestCode]) :-
    c2_vereinige_geruest_mit_total(GRest, CL, RestCode).
c2_vereinige_geruest_mit_total([pseudocode(Label)|GRest], [CL|Rest],
			       Code) :-
    c2_verbinde_code_mit_label(CL, Label, NeuCl),
    c2_concat(NeuCl, RestCode,Code),
    c2_vereinige_geruest_mit_total(GRest, Rest, RestCode).
c2_vereinige_geruest_mit_total(X, Y, []) :-
    write('Fehler bei c2_vereinige_geruest_mit_total : '), write(X), nl,
    write(Y), nl.

% vereinige_geruest_mit_nicht_total:
%   ein> Geruest (Liste von Konstruktoren: code, Pseudocode)
%        Innerer Code (Liste von Instruktions-Listen)
%   aus> Liste von Instruktionen
c2_vereinige_geruest_mit_nicht_total([pseudocode(Label)], [],
                                     [(Label:inner_reflection)]).
c2_vereinige_geruest_mit_nicht_total([code(nolabel, G)|GRest], CL,
                                     [G|RestCode]) :-
    c2_vereinige_geruest_mit_nicht_total(GRest, CL, RestCode).
c2_vereinige_geruest_mit_nicht_total([code(Label, G)|GRest], CL,
				     [(Label:G)|RestCode]) :-
    c2_vereinige_geruest_mit_nicht_total(GRest, CL, RestCode).
c2_vereinige_geruest_mit_nicht_total([pseudocode(Label)|GRest], [CL|Rest],
				     Code) :-
    c2_verbinde_code_mit_label(CL, Label, NeuCl),
    c2_concat(NeuCl, RestCode,Code),
    c2_vereinige_geruest_mit_nicht_total(GRest, Rest, RestCode).
c2_vereinige_geruest_mit_nicht_total(X, Y, []) :-
    write('Fehler bei c2_vereinige_geruest_mit_nicht_total : '), write(X), nl,
    write(Y), nl.

% vereinige_geruest_mit_redu:
%   ein> Innerer Code (Liste von Instruktions-Listen)
%        Geruest (Liste von Konstruktoren: code, Pseudocode)
%	 Funktions-Name (Name/Stelligkeit) - (as)
%   aus> Liste von Instruktionen
c2_vereinige_geruest_mit_redu([code(LT, r_trust_me_else_fail),
			       pseudocode(Label)], [], Name,
                              [(LT:(Label:put_function_occ(Name))),
			       copy_pop_occ, execute_rewriting(ao)]).
c2_vereinige_geruest_mit_redu([pseudocode(Label)], [], Name,
                              [(Label:put_function_occ(Name)),
			       copy_pop_occ, execute_rewriting(ao)]).
c2_vereinige_geruest_mit_redu([code(nolabel, G)|GRest], CL, Name,
			      [G|RestCode]) :-
    c2_vereinige_geruest_mit_redu(GRest, CL, Name, RestCode).
c2_vereinige_geruest_mit_redu([code(Label, G)|GRest], CL, Name,
                              [(Label:G)|RestCode]) :-
    c2_vereinige_geruest_mit_redu(GRest, CL, Name, RestCode).
c2_vereinige_geruest_mit_redu([pseudocode(Label)|GRest], [CL|Rest], Name,
                              Code) :-
    c2_verbinde_code_mit_label(CL, Label, NeuCl),
    c2_concat(NeuCl, RestCode,Code),
    c2_vereinige_geruest_mit_redu(GRest, Rest, Name, RestCode).
c2_vereinige_geruest_mit_redu(X, Y, _,  []) :-
    write('Fehler bei c2_vereinige_geruest_mit_redu: '), write(X), nl,
    write(Y), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
