%% Uebersetzung AbsySOWAM -> Bytecode
%% Berthold Josephs, Andreas Schwab

%%% absy_sowam_to_bc
%%
%% Aufgabe:
%%  Uebersetzung des abstrakten Syntaxbaums in eine Folge von Bytecodes,
%%  die in eine Datei geschrieben wird.
%%
%% Eingabe:
%%   AbsySowam:	  abstrakte Syntax des SOWAM-Programms
%%   SymbolList:  Liste aller im urspruenglichen ALF-Programm
%%		  benutzten Symbole (Funktionen, Praedikate, Konstruktoren,
%%		  Atome, ...) und deren Spezifikation
%%   StartLabel:  Label des auszufuehrenden Goals
%%   OutFileName: Dateiname der Ausgabedatei
%%

absy_sowam_to_bc(AbsySowam, SymbolList, StartLabel, OutFileName) :-
    b_init_bc(InitBCList, InitPC),
    b_sowam_to_bc(AbsySowam, SymbolList, GSymTab, CSymTab,
		  BCList, InitPC, MaxPC),
    b_lookup(GSymTab, StartLabel, Entry),
    b_make_AF_area(SymbolList, GSymTab, CSymTab, AFTable, AFMax,
		   TextTable, TextLength),
    b_check_symtab(GSymTab),
    b_check_symtab(CSymTab),
    b_open_file_name(OutFileName),
    b_make_reloc_table(BCList, InitPC, RelocTable),
    b_bc_out([InitBCList | BCList], MaxPC, AFTable, AFMax,
	     TextTable, TextLength, RelocTable, Entry),
    told,
    write('Bytecode generated!'),nl.


%%% b_sowam_to_bc/7
%%

b_sowam_to_bc([proc(ProcLabel, InstrList) | AbsyRest],
	      SymbolList, GSymTab, CSymTab, [BCProc | BCRest], PC, MaxPC) :-
    b_lookup(GSymTab, ProcLabel, PC),
    b_func_to_bc(InstrList, SymbolList, GSymTab, CSymTab, BCProc, PC, NPC),
    b_sowam_to_bc(AbsyRest, SymbolList, GSymTab, CSymTab, BCRest, NPC, MaxPC).
b_sowam_to_bc([], _, _, _, [], PC, PC).


%%% b_init_bc/2
%%

b_init_bc(InitBCList, InitPC) :-
    b_func_to_bc([fail], [], _, _, InitBCList, 0, InitPC).


%%% b_init_symbols/2
%%
%
%b_init_symbols(SymbolList, NewSymbolList) :-
%    b_merge_symbols(SymbolList,
%		    [entry([]/0,cons,nofix,0),
%		     entry(s/1,cons,nofix,0),
%		     entry('0'/0,cons,nofix,0),
%		     entry(read_error/0,cons,nofix,0),
%		     entry('='/2,cons,infixnot,700),
%		     entry(compound/2,cons,nofix,0),
%		     entry(const/1,cons,nofix,0),
%		     entry(var/1,cons,nofix,0),
%		     entry(str/1,cons,nofix,0),
%		     entry(list/2,cons,nofix,0),
%		     entry(integer/1,cons,nofix,0),
%		     entry(infixleft/2,cons,nofix,0),
%		     entry(infixright/2,cons,nofix,0),
%		     entry(infixnot/2,cons,nofix,0),
%		     entry(prefix/2,cons,nofix,0),
%		     entry(postfix/2,cons,nofix,0),
%		     entry(end_of_file/0,cons,nofix,0),
%		     entry(input/0,cons,nofix,0),
%		     entry(output/0,cons,nofix,0),
%		     entry(append/0,cons,nofix,0)],
%		    NewSymbolList).

b_merge_symbols([],SL,SL).
b_merge_symbols([Sym | RestSyms], SL, NSL) :-
    b_insert_symbol(SL, Sym, NNSL),
    b_merge_symbols(RestSyms, NNSL, NSL).

b_insert_symbol([], Sym, [Sym]).
b_insert_symbol([entry(Name,_,_,_)|RSL], Sym, [Sym|RSL]) :-
    Sym = entry(Name,_,_,_), !.
b_insert_symbol([Sym1|RSL], Sym, [Sym1|NSL]) :-
    b_insert_symbol(RSL, Sym, NSL).


%%% b_check_symtab/1
%%
%% Aufgabe:
%%   Ueberprueft eine Symboltabelle auf undefinierte Eintraege
%%   und gibt ggf. Warnungen aus. Ist die Symboltabelle eine
%%   offene Liste, wird sie geschlossen.
%%
%% b_check_symtab(SymTab)
%%
%% Ein-/Ausgabe:
%%   SymTab: die Symboltabelle; undefinierte Eintraege werden auf 0 gesetzt
%%

b_check_symtab([]) :- !.
b_check_symtab([entry(Spec, Adr) | Rest]) :-
    var(Adr), !,
    (
	Spec = 'MISSING LABEL'
      ;
	write('Warnung: `'), writeq(Spec),
	write(''' ist nicht definiert!'), nl
    ),
    Adr = 0,
    b_check_symtab(Rest).
b_check_symtab([_ | Rest]) :-
    b_check_symtab(Rest).

%%% b_open_file_name/1
%%

b_open_file_name(FName) :-
    name(FName, F1),
    b_append(F1, ".byt", F2),
    name(ExtFileName, F2),
    tell(ExtFileName).

b_append([], L, L).
b_append([H|T], L1, [H|L2]) :-
    b_append(T, L1, L2).

b_debug_write(Str, Val) :-
    telling(S),
    tell(user),
    write(Str), write(' = '),
    writeq(Val), nl,
    tell(S).

