/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Version 1.0  -  C Run-time                           Daniel Diaz - 1994 */
/* Extended to FD Constraints (July 1992 revised May 1994)                 */
/*                                                                         */
/* FD Range Implementation - Header file                                   */
/*                                                                         */
/* fd_range.h                                                              */
/*-------------------------------------------------------------------------*/

#include "fd_range_hook.h"

          /* Default definitions (if not defined in fd_range_hook.h) */

#ifndef M_Mul
#   define M_Mul(x,y)               ((x) * (y))
#endif

#ifndef M_Div
#   define M_Div(x,y)               ((x) / (y))
#endif

#ifndef M_Mod
#   define M_Mod(x,y)               ((x) % (y))
#endif




#ifndef Lib0
#    define Lib0(f)                 f()
#endif

#ifndef Lib1
#    define Lib1(f,a1)              f(a1)
#endif

#ifndef Lib2
#    define Lib2(f,a1,a2)           f(a1,a2)
#endif

#ifndef Lib3
#    define Lib3(f,a1,a2,a3)        f(a1,a2,a3)
#endif

#ifndef Lib4
#    define Lib4(f,a1,a2,a3,a4)     f(a1,a2,a3,a4)
#endif

#ifndef Lib5
#    define Lib5(f,a1,a2,a3,a4,a5)  f(a1,a2,a3,a4,a5)
#endif




/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

typedef unsigned VecWord;

typedef VecWord *Vector;

typedef struct               /* Ranges are always handled through pointers */
    {
     Bool   extra_cstr;
     int    min;
     int    max;
     Vector vec;
    }Range;




/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

void     Define_Vector_Size     (int max_val);
void     Vector_From_Interval   (Vector vec,int min,int max);
int      Vector_Nb_Elem         (Vector vec);
void     Vector_Empty           (Vector vec);
void     Vector_Full            (Vector vec);
void     Vector_Copy            (Vector vec,Vector vec1);
void     Vector_Union           (Vector vec,Vector vec1);
void     Vector_Inter           (Vector vec,Vector vec1);
void     Vector_Compl           (Vector vec);
void     Vector_Add_Vector      (Vector vec,Vector vec1);
void     Vector_Sub_Vector      (Vector vec,Vector vec1);
void     Vector_Mul_Vector      (Vector vec,Vector vec1);
void     Vector_Div_Vector      (Vector vec,Vector vec1);
void     Vector_Mod_Vector      (Vector vec,Vector vec1);
void     Vector_Add_Term        (Vector vec,int n);
void     Vector_Mul_Term        (Vector vec,int n);
void     Vector_Div_Term        (Vector vec,int n);
void     Vector_Mod_Term        (Vector vec,int n);

Bool     Is_Int_In_Range        (Range *range,int n);
void     Range_Copy             (Range *range,Range *range1);
int      Range_Nb_Elem          (Range *range);
void     Range_Becomes_Sparse   (Range *range);
void     Range_From_Vector      (Range *range);
void     Range_Union            (Range *range,Range *range1);
void     Range_Inter            (Range *range,Range *range1);
void     Range_Compl            (Range *range);
void     Range_Compl_Singleton  (Range *range,int n);
void     Range_Add_Range        (Range *range,Range *range1);
void     Range_Sub_Range        (Range *range,Range *range1);
void     Range_Mul_Range        (Range *range,Range *range1);
void     Range_Div_Range        (Range *range,Range *range1);
void     Range_Mod_Range        (Range *range,Range *range1);
void     Range_Add_Term         (Range *range,int n);
void     Range_Mul_Term         (Range *range,int n);
void     Range_Div_Term         (Range *range,int n);
void     Range_Mod_Term         (Range *range,int n);
void     Range_Write            (FILE *out,Range *range);





/*---------------------------------*/
/* Vector Management Macros        */
/*---------------------------------*/

#define Word_Nb_And_Bit_Nb(w,b)    (((w) << 5) | (b))        /* w * 32 + b */
#define Word_Nb(n)                 ((n) >> 5)                /* n / 32     */
#define Bit_Nb(n)                  ((n) & 0x1F)              /* n % 32     */




#define Is_Int_In_Vector(vec,n)   ((vec[Word_Nb(n)] & (1 << Bit_Nb(n))) != 0)




#define Set_Int_In_Vector(vec,n)  (vec[Word_Nb(n)] |= (1 << Bit_Nb(n)))




#define Reset_Int_In_Vector(vec,n)(vec[Word_Nb(n)] &= ~(1 << Bit_Nb(n)))




#define Vector_Allocate_If_Necessary(vec)                                   \
   ({                                                                       \
     if (vec==NULL)                                                         \
         Vector_Allocate(vec);                                              \
    })




#define Vector_Allocate(vec)                                                \
   ({                                                                       \
     vec=(Vector) RANGE_TOP_STACK;                                          \
     RANGE_TOP_STACK += vec_size;                                           \
    })




          /* To enumerate a vector use BEGIN_ENUM_VECTOR / END_ENUM_VECTOR */
          /* macros as follows:                                            */
          /* ...                                                           */
          /* BEGIN_ENUM_VECTOR(the_vector)                                 */
          /*    your code (vec_elem contains the current range element)    */
          /* END_ENUM_VECTOR                                               */

#define BEGIN_ENUM_VECTOR(vec)                                              \
   ({                                                                       \
     __label__ exit_label;                                                  \
     int vec_elem=0;                                                        \
     int enum_i,enum_j;                                                     \
     int enum_word;                                                         \
                                                                            \
     for(enum_i=0;enum_i<vec_size;enum_i++)                                 \
        {                                                                   \
         enum_word=vec[enum_i];                                             \
         for(enum_j=0;enum_j++<32;)                                         \
            {                                                               \
             if (enum_word & 1)                                             \
                {




#define BREAK_ENUM_VECTOR                                                   \
                 goto exit_label;




#define END_ENUM_VECTOR                                                     \
                }                                                           \
             enum_word >>= 1;                                               \
             vec_elem++;                                                    \
            }                                                               \
        }                                                                   \
                                                                            \
     exit_label:                                                            \
   });




/*---------------------------------*/
/* Range Management Macros         */
/*---------------------------------*/

#define Is_Interval(range)         ((range)->vec==NULL)
#define Is_Sparse(range)           ((range)->vec!=NULL)
#define Is_Empty(range)            ((range)->min > (range)->max)
#define Is_Not_Empty(range)        ((range)->max >=(range)->min)


#define Set_To_Empty(range)        (range)->max=(1<<31)


#define Init_Interval_Range(range,r_min,r_max)                              \
   ({                                                                       \
     (range)->extra_cstr=FALSE;                                             \
     (range)->min       =(r_min);                                           \
     (range)->max       =(r_max);                                           \
     (range)->vec       =NULL;                                              \
    })







