/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Version 1.0  -  C Run-time                           Daniel Diaz - 1991 */
/* Extended to FD Constraints (July 1992)                                  */
/*                                                                         */
/* Built-In: X in r meta (for call/1)                                      */
/*                                                                         */
/* fd_bips.pl                                                              */
/*-------------------------------------------------------------------------*/

:- public in/2.

X in R:-g_assign(fd_cstr,ok),
	(meta_range(R,X), !
            ;  
         g_read(fd_cstr,error),
         formata('incorrect constraint ~w~n',[X in R]),
	 fail).

          % meta_range(R,X)

meta_range([V|Vs],X):-
	L=[V|Vs],
	X in [L].

meta_range({T},X):-
	meta_term(T,0,X),
	meta_term(T,1,X).

meta_range(T1..T2,X):-
	meta_term(T1,0,X),
	meta_term(T2,1,X).

meta_range(dom(Y),X):-
	X in dom(Y).

meta_range(R1 : R2,X):-
	meta_range(R1,XR1),
	meta_range(R2,XR2),
	X in dom(XR1) : dom(XR2).

meta_range(R1 & R2,X):-
	meta_range(R1,X),
	meta_range(R2,X).

meta_range(-R,X):-
	meta_range(R,XR),
        X in -{val(XR)}.

meta_range(R1 + R2,X):-
	meta_range(R1,XR1),
	meta_range(R2,XR2),
	X in dom(XR1) + dom(XR2).

meta_range(R1 - R2,X):-
	meta_range(R1,XR1),
	meta_range(R2,XR2),
	X in dom(XR1) - dom(XR2).

meta_range(R1 * R2,X):-
	meta_range(R1,XR1),
	meta_range(R2,XR2),
	X in dom(XR1) * dom(XR2).

meta_range(R1 / R2,X):-
	meta_range(R1,XR1),
	meta_range(R2,XR2),
	X in dom(XR1) / dom(XR2).

meta_range(R1 mod R2,X):-
	meta_range(R1,XR1),
	meta_range(R2,XR2),
	X in dom(XR1) mod dom(XR2).

meta_range(R + T,X):-
	meta_range(R,XR),
	integer(T),
	X in dom(XR)+T.

meta_range(R - T,X):-
	meta_range(R,XR),
	integer(T),
	X in dom(XR)-T.

meta_range(R * T,X):-
	meta_range(R,XR),
	integer(T),
	X in dom(XR)*T.

meta_range(R / T,X):-
	meta_range(R,XR),
	integer(T),
	X in dom(XR)/T.

meta_range(R mod T,X):-
	meta_range(R,XR),
	integer(T),
	X in dom(XR) mod T.




	% meta_term(T,D,X)   D(irection): 0=min, 1=max

meta_term(N,D,X):-
	integer(N),
	(D==0 -> X in N..infinity
	      ;  X in 0..N).

meta_term(infinity,D,X):-
	(D==0 -> X in infinity..infinity
	      ;  X in 0..infinity).

meta_term(min(Y),D,X):-
	(D==0 -> X in min(Y)..infinity
	      ;  g_assign(fd_cstr,error), fail).


meta_term(max(Y),D,X):-
	(D==0 -> g_assign(fd_cstr,error), fail
              ;  X in 0..max(Y)).

meta_term(val(Y),D,X):-
	(D==0 -> X in val(Y)..infinity
              ;  X in 0..val(Y)).

meta_term(T1+T2,D,X):-
	meta_term(T1,D,XT1),
	meta_term(T2,D,XT2),
	(D==0 -> X in min(XT1)+min(XT2)..infinity
              ;  X in 0..max(XT1)+max(XT2)).

meta_term(T1 - T2,D,X):-
	meta_term(T1,D,XT1),
	D1 is 1-D,
	meta_term(T2,D1,XT2),
	(D==0 -> X in min(XT1)-max(XT2)..infinity
              ;  X in 0..max(XT1)-min(XT2)).

meta_term(T1 * T2,D,X):-
	meta_term(T1,D,XT1),
	meta_term(T2,D,XT2),
	(D==0 -> X in min(XT1)*min(XT2)..infinity
              ;  X in 0..max(XT1)*max(XT2)).

meta_term(T1 / T2,D,X):-
	meta_term(T1,D,XT1),
	D1 is 1-D,
	meta_term(T2,D1,XT2),
	(D==0 -> X in min(XT1)/max(XT2)..infinity
              ;  X in 0..max(XT1)/min(XT2)).

meta_term(T1 // T2,D,X):-
	meta_term(T1,D,XT1),
	D1 is 1-D,
	meta_term(T2,D1,XT2),
	(D==0 -> X in min(XT1)//max(XT2)..infinity
              ;  X in 0..max(XT1)//min(XT2)).

meta_term(T1 mod T2,D,X):-
	integer(T2),
	meta_term(T1,D,XT1),
	(D==0 -> X in min(XT1) mod T2..infinity
              ;  X in 0..max(XT1) mod T2).




          % Linear equations, inequations, disequalities

:- public (#=)/2, (#\=)/2, (#>=)/2, (#>)/2, (#<=)/2, (#<)/2.


LE #= RE:-
	normalize(LE,RE,LEL,LC,REL,RC),
	eq_var(LEL,LC,Z),
	eq_var(REL,RC,Z).


LE #\= RE:-
	normalize(LE,RE,LEL,LC,REL,RC),
	eq_var(LEL,LC,LZ),
	eq_var(REL,RC,RZ),
	'x<>y'(LZ,RZ).



LE #>= RE:-
	normalize(LE,RE,LEL,LC,REL,RC),
	eq_var(LEL,LC,LZ),
	eq_var(REL,RC,RZ),
	'x>=y'(LZ,RZ).


LE #> RE:-
	normalize(LE,RE,LEL,LC,REL,RC),
	eq_var(LEL,LC,LZ),
	eq_var(REL,RC,RZ),
	'x>y'(LZ,RZ).


LE #<= RE:-
	normalize(LE,RE,LEL,LC,REL,RC),
	eq_var(LEL,LC,LZ),
	eq_var(REL,RC,RZ),
	'x>=y'(RZ,LZ).


LE #< RE:-
	normalize(LE,RE,LEL,LC,REL,RC),
	eq_var(LEL,LC,LZ),
	eq_var(REL,RC,RZ),
	'x>y'(RZ,LZ).



eq_var([],Z,Z).

eq_var([A*X],C,Y):-
	!,
	(C=0 -> (A=1 -> X=Y
	             ;  'ax=y'(A,X,Y))
	     ;
	        (A=1 -> 'x+c=y'(X,C,Y)
	             ;  'ax+c=y'(A,X,C,Y))).

eq_var([A*X,B*Y],C,Z):-
	!,
	(C=0 -> (A=1 -> (B=1 -> 'x+y=z'(X,Y,Z)
	                     ;  'ax+y=z'(B,Y,X,Z))
	             ;
	                (B=1 -> 'ax+y=z'(A,X,Y,Z)
	                     ;  'ax+by=z'(A,X,B,Y,Z)))
	     ;
	        (A=1 -> (B=1 -> 'x+y+c=z'(X,Y,C,Z)
	                     ;  'ax+y+c=z'(B,Y,X,C,Z))
	             ;
	                (B=1 -> 'ax+y+c=z'(A,X,Y,C,Z)
	                     ;  'ax+by+c=z'(A,X,B,Y,C,Z)))).


eq_var([A*X,B*Y|EL],C,T):-
	!,
	eq_var(EL,C,Z),
	(A=1 -> (B=1 -> 'x+y+z=t'(X,Y,Z,T)
	             ;  'ax+y+z=t'(B,Y,X,Z,T))
	     ;
	        (B=1 -> 'ax+y+z=t'(A,X,Y,Z,T)
	             ;  'ax+by+z=t'(A,X,B,Y,Z,T))).








 /* nf = [a1*X1,...] + C   ai>=1  C >=0 */

/*
% without sorting by coef 

normalize(E1,E2,LEL,LC,REL,RC):-
	normalize1(E1-E2,1,EL,C),
	(C>=0 -> LC=C, RC=0
	      ;  LC=0, RC is -C),
	split(EL,LEL,REL),
	!.
*/

normalize(E1,E2,LEL2,LC,REL2,RC):-
	normalize1(E1-E2,1,EL,C),
	(C>=0 -> LC=C, RC=0
	      ;  LC=0, RC is -C),
	split(EL,LEL,REL),
	sort(LEL,LEL1),
	reverse(LEL1,[],LEL2),
	sort(REL,REL1),
	reverse(REL1,[],REL2),
	!.


normalize1(E,Sign,EL,C):-
	 nonvar(E),
	 E=E1+E2,
	 normalize1(E1,Sign,EL1,C1),
	 normalize1(E2,Sign,EL2,C2),
	 append_with_add(EL1,EL2,EL),
	 C is C1+C2.

normalize1(E,Sign,EL,C):-
	 nonvar(E),
	 E=E1-E2,
	 Sign1 is -Sign,
	 normalize1(E1,Sign, EL1,C1),
	 normalize1(E2,Sign1,EL2,C2),
	 append_with_add(EL1,EL2,EL),
	 C is C1+C2.

normalize1(CX,Sign,[C1*X],0):-
	 nonvar(CX),
	 CX=C*X,
	 C1 is Sign*C.

normalize1(C,Sign,[],C1):-
	integer(C),
	C1 is Sign*C.

normalize1(X,Sign,[Sign*X],0).




append_with_add([],EL,EL).

append_with_add([C*X|EL1],EL2,EL3):-
	sum_in_list(EL2,C,X,EL21),
	append_with_add(EL1,EL21,EL3).




sum_in_list([],C,X,[C*X]).

sum_in_list([C1*X|EL],C2,Y,[C*X|EL]):-
	X==Y,
	C is C1+C2.

sum_in_list([CX|EL],C,X,[CX|EL1]):-
	sum_in_list(EL,C,X,EL1).




split([],[],[]).

split([C*X|EL],[C*X|LEL],REL):-
	C > 0,
	split(EL,LEL,REL).

split([C*X|EL],LEL,[C1*X|REL]):-
	C < 0,
	C1 is -C,
	split(EL,LEL,REL).

split([_|EL],LEL,REL):-
	split(EL,LEL,REL).




reverse([],L,L).

reverse([X|L],L1,L2):-
	reverse(L,[X|L1],L2).
