/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Version 1.0  -  C Run-time                           Daniel Diaz - 1991 */
/* Extended to FD Constraints (July 1992)                                  */
/*                                                                         */
/* Built-In: B predicates (booleans)                                       */
/*                                                                         */
/* b_bips.pl                                                               */
/*-------------------------------------------------------------------------*/

	/* Boolean constraints: not, and, or, xor, equiv */

:- public not/2, and/3, or/3, and0/2, or1/2, and0/3, or1/3, 
	xor/3, equiv/3, equiv1/2.


not(X,Y):-
	X in {1-val(Y)},
	Y in {1-val(X)}.




and(X,Y,Z):-
	X in 0..1, Y in 0..1,
	Z in and(min(X),min(Y)) .. and(max(X),max(Y)),
	X in min(Z)             .. max(Z)*max(Y)+1-min(Y),
	Y in min(Z)             .. max(Z)*max(X)+1-min(X).




or(X,Y,Z):-
	X in 0..1, Y in 0..1,
	Z in or(min(X),min(Y)) .. or(max(X),max(Y)),
	X in min(Z)*(1-max(Y)) .. max(Z),
	Y in min(Z)*(1-max(X)) .. max(Z).




and0(X,Y):-
	X in 0 .. 1-min(Y),
	Y in 0 .. 1-min(X).




or1(X,Y):-
	X in 1-max(Y) .. 1,
	Y in 1-max(X) .. 1.




and0(X,Y,Z):-
	X in 0 .. 1-(min(Y)*min(Z)),
	Y in 0 .. 1-(min(X)*min(Z)),
	Z in 0 .. 1-(min(X)*min(Y)).




or1(X,Y,Z):-
	X in 1-or(min(Y),min(Z)) .. 1,
	Y in 1-or(min(X),min(Z)) .. 1,
	Z in 1-or(min(X),min(Y)) .. 1.




xor(X,Y,Z):-
	X in 0..1, Y in 0..1, Z in 0..1,
	Z in {xor(val(X),val(Y))},
	X in {xor(val(Y),val(Z))},
	Y in {xor(val(X),val(Z))}.




equiv(X,Y,Z):-
	X in 0..1, Y in 0..1, Z in 0..1,
	Z in {1-xor(val(X),val(Y))},
	X in {1-xor(val(Y),val(Z))},
	Y in {1-xor(val(X),val(Z))}.




equiv1(X,X).




/*--- version without user fct ---


and(X,Y,Z):-
	X in 0..1, Y in 0..1,
	Z in min(X)*min(Y) .. max(X)*max(Y),
	X in min(Z)        .. max(Z)*max(Y)+1-min(Y),
	Y in min(Z)        .. max(Z)*max(X)+1-min(X).




or(X,Y,Z):-
	X in 0..1, Y in 0..1,
	Z in min(X)+min(Y)-min(X)*min(Y) .. max(X)+max(Y)-max(X)*max(Y),
	X in min(Z)*(1-max(Y))           .. max(Z),
	Y in min(Z)*(1-max(X))           .. max(Z).




xor(X,Y,Z):-
	X in 0..1, Y in 0..1, Z in 0..1,
	Z in {(val(X)+val(Y)) mod 2},
	X in {(val(Y)+val(Z)) mod 2},
	Y in {(val(X)+val(Z)) mod 2}.




equiv(X,Y,Z):-
	X in 0..1, Y in 0..1, Z in 0..1,
	Z in {1-((val(X)+val(Y)) mod 2)},
	X in {1-((val(Y)+val(Z)) mod 2)},
	Y in {1-((val(X)+val(Z)) mod 2)}.


--- end version without user fct ---*/




	/* Symbolic constraints */

:- public at_least_one/1, at_most_one/1, only_one/1.


at_least_one(L):- 
	at_least_one1(L,1).


at_least_one1([X],X).

at_least_one1([X|L],R):- 
	at_least_one1(L,R1),
	or(X,R1,R).




at_most_one([]).

at_most_one([X|L]):-
	not_two(L,X),
	at_most_one(L).




not_two([],_).

not_two([X1|L],X):- 
	and0(X1,X),
	not_two(L,X).




only_one(L):-
	at_least_one(L),
	at_most_one(L).




