/*
 * Copyright (C) 1990, 1993 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * misc.c - miscellaneous X functions
 *
 * pxListExtensions
 * pxQueryExtension
 *
 * pxGetDefault
 * pxParseGeometry
 *
 * pxGetHostName
 *
 * pxNoOp
 *
 * pxOk
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"
#include "attrib.h"

/*
 * pxListExtensions(+Connection, -Next, 0)
 *	integer: Connection, Next
 */
FFInteger
pxListExtensions(pc, pn)
     FFInteger pc, *pn;
{
  PxConnection *pcp;

  PX_ErrorInit("xListExtensions/2");
  *pn = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  pxStringPointers = XListExtensions(pcp->xDisplay, &pxElements);
  if (pxElements) {
    pxMallocBlock = (char *)pxStringPointers;
    pxType = PX_VectorExtension;
    *pn = PX_Cont;
  } else
    *pn = PX_End;
  return FF_Ok;
}

/*
 * pxQueryExtension(+Connection, +Name, -Opcode, -Event, -Error, 0)
 *	integer: Connection, Opcode, Event, Error
 *	string: Name
 */
FFInteger
pxQueryExtension(pc, pn, po, pev, per)
     FFInteger pc, *po, *pev, *per;
     FFString pn;
{
  PxConnection *pcp;

  PX_ErrorInit("xQueryExtension/5");
  *po = *pev = *per = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  
  if (XQueryExtension(pcp->xDisplay, pn, po, pev, per) == False)
    PX_Error("no such extension");
  return FF_Ok;
}

/*
 * pxGetDefault(+Connection, +Program, +Option, -Default, 0)
 *	integer: Connection
 *	string: Program, Option, Default
 */
FFInteger
pxGetDefault(pc, pp, po, pd)
     FFInteger pc;
     FFString pp, po, *pd;
{
  PxConnection *pcp;
  char *res;

  PX_ErrorInit("xGetDefault/4");
  *pd = pxNil;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  if ((res = XGetDefault(pcp->xDisplay, pp, po)) == NULL)
    return FF_Fail;
  else
    *pd = res;
  return FF_Ok;
}

/*
 * pxParseGeometry(+Specification, -X, -Y, -Width, -Height, -Flags)
 *	integer: X, Y, Width, Height, Flags
 *	string: Specification
 */
void
pxParseGeometry(ps, px, py, pw, ph, pf)
     FFInteger *px, *py, *pw, *ph, *pf;
     FFString ps;
{
  int rw, rh, rx, ry, flags;

  *pw = *ph = *px = *py = *pf = PX_Invalid;
  flags = XParseGeometry(ps, &rx, &ry, &rw, &rh);
  if (flags & XValue)
    *px = rx;
  if (flags & YValue)
    *py = ry;
  if (flags & WidthValue)
    *pw = rw;
  if (flags & HeightValue)
    *ph = rh;
  *pf = flags;
}

/*
 * pxGetHostName(-Name, 0)
 */

#define ATOMBUF (pxAttribBuf.atom) 

FFInteger
pxGetHostName(pn)
     FFString *pn;
{
  PX_ErrorInit("xGetHostName/1");
  *pn = pxNil;

  if (gethostname(ATOMBUF, sizeof(ATOMBUF))) 
    PX_Error("could not get hostname");

  *pn = ATOMBUF;
  return FF_Ok;
}

/*
 * pxNoOp(+Connection, 0)
 *	integer: Connection
 */
FFInteger
pxNoOp(pc)
     FFInteger pc;
{
  PxConnection *pcp;

  PX_ErrorInit("xNoOp/1");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  
  XNoOp(pcp->xDisplay);
  return FF_Ok;
}

/* 
 * pxOk(0)
 * 
 * checks and resets px error status
 */
FFInteger
pxOk()
{
  int old = pxServerError;

  pxErrorSerial = 0;
  pxServerError = false;
  return old;
}

/*
 * eof
 */
