%
% XWIP version of David Rosenthal's "X Hello World" Program
% with some stuff stolen from Glenn Widener's R4 update
%

helloWorld :-
	Text = 'Hello, World',
	FontName = '-adobe-times-medium-r-normal--*-240-*-*-p-*-iso8859-1',

	xOpenConnection([], Connection),

	xOpenFont(Connection, FontName, Font),
	xLoadFont(Connection, Font, LoadedFont),
	xTextExtents(LoadedFont, Text, _, _, Width, Ascent, Descent),

	xQueryConnection(Connection, [xDefaultScreen(DefaultScreen)]),
	xQueryScreen(DefaultScreen,
		     [xRootWindow(RootWindow), 
		      xWidth(ScreenWidth), xHeight(ScreenHeight),
		      xDefaultColormap(DefaultColormap),
		      xWhitePixel(WhitePixel), xBlackPixel(BlackPixel)]),
	
	FontHeight is Ascent + Descent,
	BorderWidth is 1,
	MinHeight is FontHeight + (2 * BorderWidth),
	MinWidth is Width + (2 * BorderWidth),
	WindowX is (ScreenWidth - MinWidth) // 2,
	WindowY is (ScreenHeight - MinHeight) // 2,

	xCreateWindow(Connection, RootWindow,
		      WindowX, WindowY, MinWidth, MinHeight,
	              BorderWidth, xCopyFromParent,
		      xInputOutput, xCopyFromParent,
		      [xBackPixel(BlackPixel), xBorderPixel(WhitePixel),
                       xBitGravity(xCenter),
		       xEventMask([xExposure, xKeyPress]),
                       xColormap(DefaultColormap)],
                      Window),
		      
	Name = 'Hello, World',
	IconName = 'Hello',
	Command = helloWorld,
	xGetHostName(Machine),
	NormalHints = [xProgramX(WindowX), xProgramY(WindowY),
		       xProgramWidth(MinWidth), xProgramHeight(MinHeight),
		       xMinWidth(MinWidth), xMinHeight(MinHeight)],
	WMHints = [xInput(xFalse), xInitialState(xNormal)],
	Class = [helloWorld, 'HelloWorld'],

	xSetWMProperties(Connection, Window, Name, IconName, Command,
			 Machine, NormalHints, WMHints, Class),

	xSetWMProtocols(Connection, Window, ['WM_DELETE_WINDOW']),

	xCreateGC(Connection, Window, 
		  [xForeground(WhitePixel), xBackground(BlackPixel),
		   xFont(Font)],
		  GC),

	xMapWindow(Connection, Window),

	repeat,
	xNextEvent(Connection, xTrue, Event),
	handleEvent(Event, Connection, Window, GC,
		    Text, Width, Ascent, Descent, Exit),
	(Exit = xTrue -> true; fail).
	
handleEvent(Event, Connection, Window, GC, 
	    Text, Width, Ascent, Descent, xFalse) :- 
	arg(1, Event, xExpose), arg(10, Event, 0), !,
	filterQueue(Connection, xExpose),

	xQueryWindow(Connection, Window,
		     [xWidth(WindowWidth), xHeight(WindowHeight)]),
	X is (WindowWidth - Width) // 2,
	Y is (WindowHeight + Ascent - Descent) // 2,
		
	xClearArea(Connection, Window, 0, 0, 0, 0, xFalse),
	xDrawText(Connection, Window, GC, X, Y, [Text]).

handleEvent(Event, _, _, _, _, _, _, _, xFalse) :-
	arg(1, Event, xMappingNotify), !,
	xRefreshMapping(Event).

handleEvent(Event, Connection, _, _, _, _, _, _, xTrue) :-
	arg(1, Event, xKeyPress),
        xKeysymToKeycode(Connection, 113, KeyCode), % q keysym
        arg(14, Event, KeyCode), !,
        xCloseConnection(Connection).

handleEvent(Event, Connection, _, _, _, _, _, _, xTrue) :-
	arg(1, Event, xWMMessage),
	arg(8, Event, 'WM_DELETE_WINDOW'), !,
	xCloseConnection(Connection).

handleEvent(_, _, _, _, _, _, _, _, xFalse).

filterQueue(Connection, Type) :-
	xGetEvent(Connection, xAny, [], Type, xTrue, xFalse, _) -> 
	filterQueue(Connection, Type) ; true.

%
% eof
%
