%
% Copyright (C) 1990, 1993 by Ted Kim.
%
% This software work was developed at UCLA with support in part from
% DARPA Contract F29601-87-C-0072.
%

%
% ff.pl
% X Window Interface for Prolog (XWIP)
% Foreign Functions
%

foreign_file('xwip.o',
						% ff.c
       [pxVectorXFree,
	pxPrecisionGet, pxPrecisionSet,
	pxUnsignedPut1, pxUnsignedPut2,
	pxSplitGet, pxSplitGetOne, pxSplitPut,
	pxVectorAlloc, pxVectorGet, pxVectorPut, 
	pxStringAlloc, pxStringDealloc, pxStringGet, pxStringPutOne,
	pxTextAlloc, pxTextPut,
	pxColorGet, pxColorPut,
	pxListGet,
	pxGetEnvironment,

						% conn.c
	pxOpenConnection, pxCloseConnection,
	pxConnections, pxGetConnectionAttribute, 
	pxFormats, pxGetFormatAttribute,
	pxScreens, pxGetScreenAttribute, 
	pxDepths, pxGetDepthAttribute, 
	pxVisuals, pxGetVisualAttribute,

						% window.c
	pxCreateWindow, pxDestroyWindow, pxDestroySubwindows,
	pxGetWindowAttribute, pxSetWindowAttribute, pxQueryWindow,
	pxSetWindow, pxSetWMWindow,
	pxQueryTree, pxTranslateCoordinates,
	pxMapWindow, pxMapSubwindows, pxUnmapWindow, pxUnmapSubwindows,
	pxCirculateSubwindows,

						% prop.c
	pxInternAtom, pxGetAtomName,
	pxWindowProperties, pxGetProperty, pxSetProperty,
	pxDeleteProperty, pxRotateProperties,
	pxGetSelectionOwner, pxSetSelectionOwner, pxConvertSelection,

						% pixmap.c
	pxCreatePixmap, pxDestroyPixmap, pxGetPixmapAttribute, pxQueryPixmap,

						% color.c
	pxCreateColormap, pxDestroyColormap, pxMoveToNewColormap,
	pxLoadedColormaps, pxLoadColormap, pxUnloadColormap,
	pxParseColor, pxQueryColor, pxGetColors,
	pxRequestColor, pxRequestNamedColor, pxFreeColors,
	pxAllocColorCells, pxAllocColorPlanes,
	pxSetColors, pxSetNamedColor,

						% gc.c
	pxGCs, pxCreateGC, pxDestroyGC, pxCopyGC,
	pxGetGCAttribute, pxQueryBestSize,
	pxSetGCAttribute, pxSetGC, pxSetClips, pxSetDashes, 

						% graphics.c
	pxClearArea, pxCopyArea, pxCopyPlane,
	pxDrawPoints, pxDrawLines, pxDrawSegments, pxDrawRectangles, pxDrawArcs,
	pxFillRectangles, pxFillPolygon, pxFillArcs,

						% image.c
	pxImages, pxCreateImage, pxDestroyImage,
	pxGetImageAttribute, pxGetImage, pxPutImage,
	pxSubImage, pxAddPixel,
	pxGetPixel, pxSetPixel,

						% text.c
	pxOpenFont, pxCloseFont, 
	pxLoadedFonts, pxLoadFont, pxUnloadFont,
	pxGetFontPath, pxSetFontPath, pxListFonts, 
	pxGetFontAttribute, pxGetFontProperty, pxGetCharInfo, pxTextExtents,
	pxDrawText, pxImageText,

						% cursor.c
	pxCreateFontCursor, pxCreateGlyphCursor, pxCreatePixmapCursor,
	pxDestroyCursor, pxRecolorCursor,

						% pointer.c
	pxPointerState, pxWarpPointer,
	pxGetPointerAttribute, pxSetPointerAttribute,
	pxQueryPointer, pxSetPointer,
	pxGetPointerMapping, pxSetPointerMapping,

						% keyboard.c
	pxDownKeymap, pxGetKeyboardAttribute, pxSetKeyboardAttribute,
	pxQueryKeyboard, pxSetKeyboard,
	pxGetKeyboardMapping, pxSetKeyboardMapping,
	pxGetModifierMapping, pxSetModifierMapping,
	pxBell,
	pxKeycodeToKeysym, pxKeysymToKeycode, pxRefreshMapping,

						% wm.c
	pxSetSaveSet, pxReparentWindow, pxSetCloseDownMode, pxKillClient,
	pxGetInputFocus, pxSetInputFocus,
	pxGrabPointer, pxUngrabPointer, pxSetActivePointer,
	pxGrabButton, pxUngrabButton,
	pxGrabKeyboard, pxUngrabKeyboard, pxGrabKey, pxUngrabKey,
	pxAllowEvents,
	pxGrabServer, pxUngrabServer,
	pxGetScreenSaver, pxSetScreenSaver, pxScreenSaver,
	pxQueryAccess, pxSetAccess, pxSetHostAccess,

						% event.c
	pxEventsQueued, pxNextEvent, pxGetEvent, pxSelectEvent,
	pxPutBackEvent, pxSendEvent,
	pxFlush, pxSync, pxSynchronize,
	pxNormalMotion, pxSplitMotion, pxGetMotionEvents, 

						% res.c
	pxResourceDatabases, pxOpenResourceDatabase, pxCloseResourceDatabase,
	pxQueryResourceDatabase,

						% misc.c
	pxListExtensions, pxQueryExtension,
	pxGetDefault, pxParseGeometry,
	pxGetHostName,
	pxNoOp, pxOk]).

% ff.c
%
% pxVectorXFree
%
% pxPrecisionGet(-Bits)
% pxPrecisionSet(+Bits, 0)
%
% pxUnsignedPut1(+Type, +Most, +Least, 0)
% pxUnsignedPut2(+Type, +Most, +Least, 0)
%
% pxVectorAlloc(+Type, +Length, 0)
% pxVectorGet(-Element, -Next, 0)
% pxVectorPut(+Element, 0)
%
% pxSplitGet(-Most, -Least, -Next, 0)
% pxSplitGetOne(-Most, -Least, 0)
% pxSplitPut(+Most, +Least, 0)
%
% pxStringAlloc(+Type, +Elements, +Length, 0)
% pxStringDealloc(0)
% pxStringGet(-Element, -Next, 0)
% pxStringPutOne(+Element)
%
% pxTextAlloc(+Type, +Items, +Characters, 0)
% pxTextPut(+Type, +String, +Length, +Delta, +Font, 0)
%
% pxColorGet(-Pixel, -Red, -Green, -Blue, 0)
% pxColorPut(+Pixel, +Red, +Green, +Blue, +Flags, 0)
%
% pxListGet(-Element, -Next, 0)
%
% pxGetEnvironment(+Name, -Value, 0)
foreign(pxVectorXFree, c, pxVectorXFree).
foreign(pxPrecisionGet, c, pxPrecisionGet(-integer)).
foreign(pxPrecisionSet, c, pxPrecisionSet(+integer, [-integer])).
foreign(pxUnsignedPut1, c, pxUnsignedPut1(+integer, +integer, +integer,
	[-integer])).
foreign(pxUnsignedPut2, c, pxUnsignedPut2(+integer, +integer, +integer,
	[-integer])).
foreign(pxVectorAlloc, c, pxVectorAlloc(+integer, +integer, [-integer])).
foreign(pxVectorGet, c, pxVectorGet(-integer, -integer, [-integer])).
foreign(pxVectorPut, c, pxVectorPut(+integer, [-integer])).
foreign(pxSplitGet, c, pxSplitGet(-integer, -integer, -integer, [-integer])).
foreign(pxSplitGetOne, c, pxSplitGetOne(-integer, -integer, [-integer])).
foreign(pxSplitPut, c, pxSplitPut(+integer, +integer, [-integer])).
foreign(pxStringAlloc, c, pxStringAlloc(+integer, +integer, +integer,
	[-integer])).
foreign(pxStringDealloc, c, pxStringDealloc([-integer])).
foreign(pxStringGet, c, pxStringGet(-string, -integer, [-integer])).
foreign(pxStringPutOne, c, pxStringPutOne(+string)).
foreign(pxTextAlloc, c, pxTextAlloc(+integer, +integer, +integer, [-integer])).
foreign(pxTextPut, c, pxTextPut(+integer, +string, +integer, +integer,
	+integer, [-integer])).
foreign(pxColorGet, c, pxColorGet(-integer, -integer, -integer, -integer,
	[-integer])).
foreign(pxColorPut, c, pxColorPut(+integer, +integer, +integer, +integer, 
	+integer, [-integer])).
foreign(pxListGet, c, pxListGet(-integer, -integer, [-integer])).
foreign(pxGetEnvironment, c, pxGetEnvironment(+string, -string, [-integer])).

% conn.c
%
% pxOpenConnection(+Name, -Connection, 0)
% pxCloseConnection(+Connection, 0)
%
% pxConnections(-Next)
% pxGetConnectionAttribute(+Connection, +Attribute, -String, -Upper, -Lower, 0)
%
% pxFormats(-Next)
% pxGetFormatAttribute(+Format, +Attribute, -Value, 0)
%
% pxScreens(-Next)
% pxGetScreenAttribute(+Screen, +Attribute, -Value, 0)
%
% pxDepths(-Next)
% pxGetDepthAttribute(+Depth, +Attribute, -Value, 0)
%
% pxVisuals(-Next)
% pxGetVisualAttribute(+Visual, +Attribute, -Value, 0)
%
foreign(pxOpenConnection, c, pxOpenConnection(+string, -integer, [-integer])).
foreign(pxCloseConnection, c, pxCloseConnection(+integer, [-integer])).
foreign(pxConnections, c, pxConnections(-integer)).
foreign(pxGetConnectionAttribute, c, pxGetConnectionAttribute(+integer,
	+integer, -string, -integer, -integer, [-integer])).
foreign(pxFormats, c, pxFormats(-integer)).
foreign(pxGetFormatAttribute, c, pxGetFormatAttribute(+integer, +integer,
	-integer, [-integer])).
foreign(pxScreens, c, pxScreens(-integer)).
foreign(pxGetScreenAttribute, c, pxGetScreenAttribute(+integer, +integer,
	-integer, [-integer])).
foreign(pxDepths, c, pxDepths(-integer)).
foreign(pxGetDepthAttribute, c, pxGetDepthAttribute(+integer, +integer,
	-integer, [-integer])).
foreign(pxVisuals, c, pxVisuals(-integer)).
foreign(pxGetVisualAttribute, c, pxGetVisualAttribute(+integer, +integer,
	-integer, [-integer])).

% window.c
%
% pxCreateWindow(+Connection, +Parent, +X, +Y, +Width, +Height, +BorderWidth,
%	+Depth, +Class, +Visual, -Window, 0)
% pxDestroyWindow(+Connection, +Window, 0)
% pxDestroySubwindows(+Connection, +Window, 0)
%
% pxGetWindowAttribute(+Attribute, -Value, 0)
% pxSetWindowAttribute(+Attribute, +Value, 0)
% pxQueryWindow(+Connection, +Window, 0)
% pxSetWindow(+Connection, +Window, 0)
% pxSetWMWindow(+Connection, +Screen, +Window, 0)
%
% pxQueryTree(+Connection, +Window, -Root, -Parent, -Next, 0)
% pxTranslateCoordinates(+Connection, +Source, +Dest, +SrcX, +SrcY, -DestX,
%	-DestY, -Child, 0)
%
% pxMapWindow(+Connection, +Window, 0)
% pxMapSubwindows(+Connection, +Window, 0)
% pxUnmapWindow(+Connection, +Window, 0)
% pxUnmapSubwindows(+Connection, +Window, 0)
%
% pxCirculateSubwindows(+Connection, +Window, +LowerHighest, 0)
%
foreign(pxCreateWindow, c, pxCreateWindow(+integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer, +integer, 
	-integer, [-integer])).
foreign(pxDestroyWindow, c, pxDestroyWindow(+integer, +integer, [-integer])).
foreign(pxDestroySubwindows, c, pxDestroySubwindows(+integer, +integer,
	[-integer])).
foreign(pxGetWindowAttribute, c, pxGetWindowAttribute(+integer, -integer,
	[-integer])).
foreign(pxSetWindowAttribute, c, pxSetWindowAttribute(+integer, +integer,
	[-integer])).
foreign(pxQueryWindow, c, pxQueryWindow(+integer, +integer, [-integer])).
foreign(pxSetWindow, c, pxSetWindow(+integer, +integer, [-integer])).
foreign(pxSetWMWindow, c, pxSetWMWindow(+integer, +integer, +integer,
	[-integer])).
foreign(pxQueryTree, c, pxQueryTree(+integer, +integer, -integer, -integer,
	-integer, [-integer])).
foreign(pxTranslateCoordinates, c, pxTranslateCoordinates(+integer, +integer,
	+integer, +integer, +integer, -integer, -integer, -integer,
	[-integer])).
foreign(pxMapWindow, c, pxMapWindow(+integer, +integer, [-integer])).
foreign(pxMapSubwindows, c, pxMapSubwindows(+integer, +integer, [-integer])).
foreign(pxUnmapWindow, c, pxUnmapWindow(+integer, +integer, [-integer])).
foreign(pxUnmapSubwindows, c, pxUnmapSubwindows(+integer, +integer,
	[-integer])).
foreign(pxCirculateSubwindows, c, pxCirculateSubwindows(+integer, +integer, 
	+integer, [-integer])).

% prop.c
%
% pxInternAtom(+Connection, +XAtomName, +DontCreate, -XAtom, 0)
% pxGetAtomName(+Connection, +XAtom, -XAtomName, 0)
%
% pxWindowProperties(+Connection, +Window, -Next, 0)
% pxGetProperty(+Connection, +Window, +Property, +Offset, +Length, +DeleteIfEnd,
%	+RequestedType, +WantAtom, -Type, -Remaining, -Format, -String, -Next,
%	0)
% pxSetProperty(+Connection, +Window, +Property, +Type, +Mode, +Format, +Data,
%	0)
% pxDeleteProperty(+Connection, +Window, +Property, 0)
% pxRotateProperties(+Connection, +Window, +Positions, 0)
%
% pxGetSelectionOwner(+Connection, +Selection, -Window, 0)
% pxSetSelectionOwner(+Connection, +Selection, +Owner, 0)
% pxConvertSelection(+Connection, +Selection, +DestType, +DestProperty,
%	+DestWindow, 0)
%
foreign(pxInternAtom, c, pxInternAtom(+integer, +string, +integer, -integer,
	[-integer])).
foreign(pxGetAtomName, c, pxGetAtomName(+integer, +integer, -string,
	[-integer])).
foreign(pxWindowProperties, c, pxWindowProperties(+integer, +integer, -integer,
	[-integer])).
foreign(pxGetProperty, c, pxGetProperty(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, -integer, -integer, -integer,
	-string, -integer, [-integer])).
foreign(pxSetProperty, c, pxSetProperty(+integer, +integer, +integer, +integer,
	+integer, +integer, +string, [-integer])).
foreign(pxDeleteProperty, c, pxDeleteProperty(+integer, +integer, +integer,
	[-integer])).
foreign(pxRotateProperties, c, pxRotateProperties(+integer, +integer, +integer,
	[-integer])).
foreign(pxGetSelectionOwner, c, pxGetSelectionOwner(+integer, +integer,
	-integer, [-integer])).
foreign(pxSetSelectionOwner, c, pxSetSelectionOwner(+integer, +integer,
	+integer, [-integer])).
foreign(pxConvertSelection, c, pxConvertSelection(+integer, +integer, +integer,
	+integer, +integer, [-integer])).

% pixmap.c
%
% pxCreatePixmap(+Connection, +Screen, +Width, +Height, +Depth, -Pixmap, 0)
% pxDestroyPixmap(+Connection, +Pixmap, 0)
%
% pxGetPixmapAttribute(+Attribute, -Value, 0)
% pxQueryPixmap(+Connection, +Drawable, 0)
%
foreign(pxCreatePixmap, c, pxCreatePixmap(+integer, +integer, +integer,
	+integer, +integer, -integer, [-integer])).
foreign(pxDestroyPixmap, c, pxDestroyPixmap(+integer, +integer, [-integer])).
foreign(pxGetPixmapAttribute, c, pxGetPixmapAttribute(+integer, -integer,
	[-integer])).
foreign(pxQueryPixmap, c, pxQueryPixmap(+integer, +integer, [-integer])).

% color.c
%
% pxCreateColormap(+Connection, +Screen, +Visual, +Alloc, -Colormap, 0)
% pxDestroyColormap(+Connection, +Colormap, 0)
% pxMoveToNewColormap(+Connection, +Current, -New, 0)
%
% pxLoadedColormaps(+Connection, +Screen, -Next, 0)
% pxLoadColormap(+Connection, +Colormap, 0)
% pxUnloadColormap(+Connection, +Colormap, 0)
%
% pxParseColor(+Connection, +Colormap, +Specification, -ExactRed, -ExactGreen,
%	-ExactBlue, 0)
% pxQueryColor(+Connection, +Colormap, +Name, -ActualRed, -ActualGreen,
%	-ActualBlue, -ExactRed, -ExactGreen, -ExactBlue, 0)
% pxGetColors(+Connection, +Colormap, 0)
%
% pxRequestColor(+Connection, +Colormap, +Red, +Green, +Blue, -Pixel,
%	-ActualRed, -ActualGreen, -ActualBlue, 0)
% pxRequestNamedColor(+Connection, +Colormap, +Name, -Pixel, -ActualRed,
%	-ActualGreen, -ActualBlue, -ExactRed, -ExactGreen, -ExactBlue, 0)
% pxFreeColors(+Connection, +Colormap, +PlaneMask, 0)
%
% pxAllocColorCells(+Connection, +Colormap, +Contiguous, +Planes, +Colors, 0)
% pxAllocColorPlanes(+Connection, +Colormap, +Contiguous, +Colors, +Reds,
%	+Greens, +Blues, -RedMask, -GreenMask, -BlueMask, 0)
% pxSetColors(+Connection, +Colormap, 0)
% pxSetNamedColor(+Connection, +Colormap, +Name, +Pixel, +Flags, 0)
%
foreign(pxCreateColormap, c, pxCreateColormap(+integer, +integer, +integer,
	+integer, -integer, [-integer])).
foreign(pxDestroyColormap, c, pxDestroyColormap(+integer, +integer,
	[-integer])).
foreign(pxMoveToNewColormap, c, pxMoveToNewColormap(+integer, +integer,
	-integer, [-integer])).
foreign(pxLoadedColormaps, c, pxLoadedColormaps(+integer, +integer, -integer,
	[-integer])).
foreign(pxLoadColormap, c, pxLoadColormap(+integer, +integer, [-integer])).
foreign(pxUnloadColormap, c, pxUnloadColormap(+integer, +integer, [-integer])).
foreign(pxParseColor, c, pxParseColor(+integer, +integer, +string, -integer,
	-integer, -integer, [-integer])).
foreign(pxQueryColor, c, pxQueryColor(+integer, +integer, +string, -integer,
	-integer, -integer, -integer, -integer, -integer, [-integer])).
foreign(pxGetColors, c, pxGetColors(+integer, +integer, [-integer])).
foreign(pxRequestColor, c, pxRequestColor(+integer, +integer, +integer,
	+integer, +integer, -integer, -integer, -integer, -integer,
	[-integer])).
foreign(pxRequestNamedColor, c, pxRequestNamedColor(+integer, +integer,
	+string, -integer, -integer, -integer, -integer, -integer, -integer,
	-integer, [-integer])).
foreign(pxFreeColors, c, pxFreeColors(+integer, +integer, +integer,
	[-integer])).
foreign(pxAllocColorCells, c, pxAllocColorCells(+integer, +integer, +integer,
	+integer, +integer, [-integer])).
foreign(pxAllocColorPlanes, c, pxAllocColorPlanes(+integer, +integer, +integer,
	+integer, +integer, +integer, +integer, -integer, -integer, -integer,
	[-integer])).
foreign(pxSetColors, c, pxSetColors(+integer, +integer, [-integer])).
foreign(pxSetNamedColor, c, pxSetNamedColor(+integer, +integer, +string,
	+integer, +integer, [-integer])).

% gc.c
%
% pxGCs(-Next)
% pxCreateGC(+Connection, +Drawable, -GC, 0)
% pxDestroyGC(+Connection, +GC, 0)
% pxCopyGC(+Connection, +Src, +Mask, +Dest, 0)
%
% pxGetGCAttribute(+GC, +Attribute, -Value, 0)
% pxQueryBestSize(+Connection, +Mode, +Screen, +Width, +Height, -ReturnWidth,
%	-ReturnHeight, 0)
%
% pxSetGCAttribute(+Attribute, +Value, 0)
% pxSetGC(+Connection, +GC, 0)
% pxSetClips(+Connection, +GC, +XOrigin, +YOrigin, +Ordering, 0)
% pxSetDashes(+Connection, +GC, +DashOffset, 0)
%
foreign(pxGCs, c, pxGCs(-integer)).
foreign(pxCreateGC, c, pxCreateGC(+integer, +integer, -integer, [-integer])).
foreign(pxDestroyGC, c, pxDestroyGC(+integer, +integer, [-integer])).
foreign(pxCopyGC, c, pxCopyGC(+integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxGetGCAttribute, c, pxGetGCAttribute(+integer, +integer, -integer,
	[-integer])).
foreign(pxQueryBestSize, c, pxQueryBestSize(+integer, +integer, +integer,
	+integer, +integer, -integer, -integer, [-integer])).
foreign(pxSetGCAttribute, c, pxSetGCAttribute(+integer, +integer, [-integer])).
foreign(pxSetGC, c, pxSetGC(+integer, +integer, [-integer])).
foreign(pxSetClips, c, pxSetClips(+integer, +integer, +integer, +integer,
	+integer, [-integer])).
foreign(pxSetDashes, c, pxSetDashes(+integer, +integer, +integer, [-integer])).

% graphics.c
%
% pxClearArea(+Connection, +Window, +X, +Y, +Width, +Height, +Exposures, 0)
% pxCopyArea(+Connection, +Src, +Dest, +GC, +SrcX, +SrcY, +Width, +Height,
%	+DestX, +DestY, 0)
% pxCopyPlane(+Connection, +Src, +Dest, +GC, +SrcX, +SrcY, +Width, +Height,
%	+DestX, +DestY, +Plane, 0)
%
% pxDrawPoints(+Connection, +Drawable, +GC, +Relative, 0)
% pxDrawLines(+Connection, +Drawable, +GC, +Relative, 0)
% pxDrawSegments(+Connection, +Drawable, +GC, 0)
% pxDrawRectangles(+Connection, +Drawable, +GC, 0)
% pxDrawArcs(+Connection, +Drawable, +GC, 0)
%
% pxFillRectangles(+Connection, +Drawable, +GC, 0)
% pxFillPolygon(+Connection, +Drawable, +GC, +Shape, +Relative, 0)
% pxFillArcs(+Connection, +Drawable, +GC, 0)
%
foreign(pxClearArea, c, pxClearArea(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, [-integer])).
foreign(pxCopyArea, c, pxCopyArea(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxCopyPlane, c, pxCopyPlane(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxDrawPoints, c, pxDrawPoints(+integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxDrawLines, c, pxDrawLines(+integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxDrawSegments, c, pxDrawSegments(+integer, +integer, +integer,
	[-integer])).
foreign(pxDrawRectangles, c, pxDrawRectangles(+integer, +integer, +integer,
	[-integer])).
foreign(pxDrawArcs, c, pxDrawArcs(+integer, +integer, +integer, [-integer])).
foreign(pxFillRectangles, c, pxFillRectangles(+integer, +integer, +integer,
	[-integer])).
foreign(pxFillPolygon, c, pxFillPolygon(+integer, +integer, +integer, +integer,
	+integer, [-integer])).
foreign(pxFillArcs, c, pxFillArcs(+integer, +integer, +integer, [-integer])).

% image.c
%
% pxImages(-Next)
% pxCreateImage(+Connection, +Visual, +Depth, +Format, +Offset, +Width, +Height,
%	+BitmapPad, +BytesPerLine, -Image, 0)
% pxDestroyImage(+Image, 0)
%
% pxGetImageAttribute(+Image, +Attribute, -Value, 0)
% pxGetImage(+Connection, +Drawable, +SrcX, +SrcY, +Width, +Height, +PlaneMask,
%	+DestImage, +DestX, +DestY, 0)
% pxPutImage(+Connection, +Drawable, +GC, +Image, +SrcX, +SrcY, +DestX, +DestY,
%	+Width, +Height, 0)
%
% pxSubImage(+Image, +X, +Y, +Width, +Height, -SubImage, 0)
% pxAddPixel(+Image, +Value, 0)
%
% pxGetPixel(+Image, +X, +Y, -Pixel, 0)
% pxSetPixel(+Image, +X, +Y, +Pixel, 0)
%
foreign(pxImages, c, pxImages(-integer)).
foreign(pxCreateImage, c, pxCreateImage(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, -integer,
	[-integer])).
foreign(pxDestroyImage, c, pxDestroyImage(+integer, [-integer])).
foreign(pxGetImageAttribute, c, pxGetImageAttribute(+integer, +integer,
	-integer, [-integer])).
foreign(pxGetImage, c, pxGetImage(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxPutImage, c, pxPutImage(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxSubImage, c, pxSubImage(+integer, +integer, +integer, +integer,
	+integer, -integer, [-integer])).
foreign(pxAddPixel, c, pxAddPixel(+integer, +integer, [-integer])).
foreign(pxGetPixel, c, pxGetPixel(+integer, +integer, +integer, -integer,
	[-integer])).
foreign(pxSetPixel, c, pxSetPixel(+integer, +integer, +integer, +integer,
	[-integer])).

% text.c
%
% pxOpenFont(+Connection, +Name, -Font, 0)
% pxCloseFont(+Connection, +Font, 0)
%
% pxLoadedFonts(-Next)
% pxLoadFont(+Connection, +Font, -LoadedFont, 0)
% pxUnloadFont(+Font, 0)
%
% pxGetFontPath(+Connection, -Next, 0)
% pxSetFontPath(+Connection,  0)
% pxListFonts(+Connection, +Pattern, +MaxNames, -Next, 0)
%
% pxGetFontAttribute(+Font, +Attribute, -Value, 0)
% pxGetFontProperty(+Font, +Property, -Value, 0)
% pxGetCharInfo(+Font, +Character, -LeftBearing, -RightBearing, -Width, -Ascent,
%	-Descent, -Attributes, 0)
% pxTextExtents(+Font, +Format, +XString, -LeftBearing, -RightBearing, -Width,
%	-Ascent, -Descent, 0)
%
% pxDrawText(+Connection, +Drawbale, +GC, +X, +Y, 0)
% pxImageText(+Connection, +Drawable, +GC, +X, +Y, +Type, +String, 0)
%
foreign(pxOpenFont, c, pxOpenFont(+integer, +string, -integer, [-integer])).
foreign(pxCloseFont, c, pxCloseFont(+integer, +integer, [-integer])).
foreign(pxLoadedFonts, c, pxLoadedFonts(-integer)).
foreign(pxLoadFont, c, pxLoadFont(+integer, +integer, -integer, [-integer])).
foreign(pxUnloadFont, c, pxUnloadFont(+integer, [-integer])).
foreign(pxGetFontPath, c, pxGetFontPath(+integer, -integer, [-integer])).
foreign(pxSetFontPath, c, pxSetFontPath(+integer, [-integer])).
foreign(pxListFonts, c, pxListFonts(+integer, +string, +integer, -integer,
	[-integer])).
foreign(pxGetFontAttribute, c, pxGetFontAttribute(+integer, +integer, -integer,
	[-integer])).
foreign(pxGetFontProperty, c, pxGetFontProperty(+integer, +integer, -integer,
	[-integer])).
foreign(pxGetCharInfo, c, pxGetCharInfo(+integer, +integer, -integer, -integer,
	-integer, -integer, -integer, -integer, [-integer])).
foreign(pxTextExtents, c, pxTextExtents(+integer, +integer, +string, -integer,
	-integer, -integer, -integer, -integer, [-integer])).
foreign(pxDrawText, c, pxDrawText(+integer, +integer, +integer, +integer,
	+integer, [-integer])).
foreign(pxImageText, c, pxImageText(+integer, +integer, +integer, +integer, 
	+integer, +integer, +string, [-integer])).

% cursor.c
%
% pxCreateFontCursor(+Connection , +Chape, -Cursor, 0)
% pxCreateGlyphCursor(+Connection, +SrcFont, +MaskFont, +SrcChar, +MaskChar,
%	+ForeRed, +ForeGreen, +ForeBlue, +BackRed, +BackGreen, +BackBlue,
%	-Cursor, 0)
% pxCreatePixmapCursor(+Connection, +Source, +Mask, +ForeRed, +ForeGreen,
%	+ForeBlue, +BackRed, +BackGreen, +BackBlue, +X, +Y, -Cursor, 0)
%
% pxDestroyCursor(+Connection, +Cursor, 0)
% pxRecolorCursor(+Connection, +Cursor, +ForeRed, +ForeGreen, +ForeBlue,
%	+BackRed, +BackGreen, +BackBlue, 0)
%
foreign(pxCreateFontCursor, c, pxCreateFontCursor(+integer, +integer, -integer,
	[-integer])).
foreign(pxCreateGlyphCursor, c, pxCreateGlyphCursor(+integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer, +integer,
	+integer, +integer, -integer, [-integer])).
foreign(pxCreatePixmapCursor, c, pxCreatePixmapCursor(+integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer, +integer,
	+integer, +integer, -integer, [-integer])).
foreign(pxDestroyCursor, c, pxDestroyCursor(+integer, +integer, [-integer])).
foreign(pxRecolorCursor, c, pxRecolorCursor(+integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, [-integer])).

% pointer.c
%
% pxPointerState(+Connection, +Window, -Root, -Child, -RootX, -RootY, -WinX,
%	-WinY, -State, 0)
% pxWarpPointer(+Connection, +Source, +Dest, +SrcX, +SrcY, +Width, +Height,
%	+DestX, +DestY, 0)
%
% pxGetPointerAttribute(+Attribute, -Value, 0)
% pxSetPointerAttribute(+Attribute, +Value, 0)
% pxQueryPointer(+Connection, 0)
% pxSetPointer(+Connection, 0)
% 
% pxGetPointerMapping(+Connection, +Length, 0)
% pxSetPointerMapping(+Connection, 0)
%
foreign(pxPointerState, c, pxPointerState(+integer, +integer, -integer,
	-integer, -integer, -integer, -integer, -integer, -integer,
	[-integer])).
foreign(pxWarpPointer, c, pxWarpPointer(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, [-integer])).
foreign(pxGetPointerAttribute, c, pxGetPointerAttribute(+integer, -integer,
	[-integer])).
foreign(pxSetPointerAttribute, c, pxSetPointerAttribute(+integer, +integer,
	[-integer])).
foreign(pxQueryPointer, c, pxQueryPointer(+integer, [-integer])).
foreign(pxSetPointer, c, pxSetPointer(+integer, [-integer])).
foreign(pxGetPointerMapping, c, pxGetPointerMapping(+integer, +integer,
	[-integer])).
foreign(pxSetPointerMapping, c, pxSetPointerMapping(+integer, [-integer])).

% keyboard.c
%
% pxDownKeymap(+Connection, -Next, 0)
% pxGetKeyboardAttribute(+Attribute, -Value, 0)
% pxSetKeyboardAttribute(+Attribute, +Value, 0)  
% pxQueryKeyboard(+Connection, 0)
% pxSetKeyboard(+Connection, 0)
%
% pxGetKeyboardMapping(+Connection, +First, +Count, -Keysyms, -Next, 0)
% pxSetKeyboardMapping(+Connection, +First, +Keysyms, +Count, 0)
%
% pxGetModifierMapping(+Connection, -Keycodes, 0)
% pxSetModifierMapping(+Connection, +Keycodes, -Status, 0)
%
% pxBell(+Connection, +Percent, 0)
%
% pxKeycodeToKeysym(+Connection, +Keycode, +Index, -Keysym, 0)
% pxKeysymToKeycode(+Connection, +Keysym, -Keycode, 0)
% pxRefreshMapping(0)
%
foreign(pxDownKeymap, c, pxDownKeymap(+integer, -integer, [-integer])).
foreign(pxGetKeyboardAttribute, c, pxGetKeyboardAttribute(+integer, -integer,
	[-integer])).
foreign(pxSetKeyboardAttribute, c, pxSetKeyboardAttribute(+integer, +integer,
	[-integer])).
foreign(pxQueryKeyboard, c, pxQueryKeyboard(+integer, [-integer])).
foreign(pxSetKeyboard, c, pxSetKeyboard(+integer, [-integer])).
foreign(pxGetKeyboardMapping, c, pxGetKeyboardMapping(+integer, +integer,
	+integer, -integer, -integer, [-integer])).
foreign(pxSetKeyboardMapping, c, pxSetKeyboardMapping(+integer, +integer,
	+integer, +integer, [-integer])).
foreign(pxGetModifierMapping, c, pxGetModifierMapping(+integer, -integer,
	[-integer])).
foreign(pxSetModifierMapping, c, pxSetModifierMapping(+integer, +integer,
	-integer, [-integer])).
foreign(pxBell, c, pxBell(+integer, +integer, [-integer])).
foreign(pxKeycodeToKeysym, c, pxKeycodeToKeysym(+integer, +integer, +integer, 
	-integer, [-integer])).
foreign(pxKeysymToKeycode, c, pxKeysymToKeycode(+integer, +integer, -integer,
	[-integer])).
foreign(pxRefreshMapping, c, pxRefreshMapping([-integer])).

% wm.c
%
% pxSetSaveSet(+Connection, +Window, +Delete, 0)
% pxReparentWindow(+Connection, +Window, +Parent, +X, +Y, 0)
% pxSetCloseDownMode(+Connection, +Mode, 0)
% pxKillClient(+Connection, +Resource, 0)
%
% pxGetInputFocus(+Connection, -Window, -Revert, 0)
% pxSetInputFocus(+Connection, +Window, +Revert, 0)
%
% pxGrabPointer(+Connection, +GrabWindow, +NormalEvents, +EventMask,
%	+PointerDefer, +KeyboardDefer, +ConfineWindow, +Cursor, -Status, 0)
% pxUngrabPointer(+Connection, 0)
% pxSetActivePointer(+Connection, +EventMask, +Cursor, 0)
%
% pxGrabButton(+Connection, +Button, +Modifiers, +GrabWindow, +NormalEvents,
%	+EventMask, +PointerDefer, +KeyboardDefer, +ConfineWindow, +Cursor, 0)
% pxUngrabButton(+Connection, +Button, +Modifiers, +GrabWindow, 0)
%
% pxGrabKeyboard(+Connection, +GrabWindow, +NormalEvents, +PointerDefer,
%	+KeyboardDefer, -Status, 0)
% pxUngrabKeyboard(+Connection, 0)
%
% pxGrabKey(+Connection, +Keycode, +Modifiers, +GrabWindow, +NormalEvents,
%	+PointerDefer, +KeyboardDefer, 0)
% pxUngrabKey(+Connection, +Keycode, +Modifiers, +GrabWindow, 0)
%
% pxAllowEvents(+Connection, +Mode, 0)
%
% pxGrabServer(+Connection, 0)
% pxUngrabServer(+Connection, 0)
%
% pxGetScreenSaver(+Connection, -Timeout, -Interval, -Blanking, -Exposures, 0)
% pxSetScreenSaver(+Connection, +Timeout, +Interval, +Blanking, +Exposures, 0)
% pxScreenSaver(+Connection, +Activate, 0)
%
% pxQueryAccess(+Connection, -Control, -Next, 0)
% pxSetAccess(+Connection, +Enable, 0)
% pxSetHostAccess(+Connection, +Insert, +Host, 0)
%
foreign(pxSetSaveSet, c, pxSetSaveSet(+integer, +integer, +integer,
	[-integer])).
foreign(pxReparentWindow, c, pxReparentWindow(+integer, +integer, +integer, 
	+integer, +integer, [-integer])).
foreign(pxSetCloseDownMode, c, pxSetCloseDownMode(+integer, +integer,
	[-integer])).
foreign(pxKillClient, c, pxKillClient(+integer, +integer, [-integer])).
foreign(pxGetInputFocus, c, pxGetInputFocus(+integer, -integer, -integer,
	[-integer])). 
foreign(pxSetInputFocus, c, pxSetInputFocus(+integer, +integer, +integer,
	[-integer])).
foreign(pxGrabPointer, c, pxGrabPointer(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, -integer, [-integer])).
foreign(pxUngrabPointer, c, pxUngrabPointer(+integer, [-integer])).
foreign(pxSetActivePointer, c, pxSetActivePointer(+integer, +integer, +integer,
	[-integer])).
foreign(pxGrabButton, c, pxGrabButton(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxUngrabButton, c, pxUngrabButton(+integer, +integer, +integer,
	+integer, [-integer])).
foreign(pxGrabKeyboard, c, pxGrabKeyboard(+integer, +integer, +integer,
	+integer, +integer, -integer, [-integer])).
foreign(pxUngrabKeyboard, c, pxUngrabKeyboard(+integer, [-integer])).
foreign(pxGrabKey, c, pxGrabKey(+integer, +integer, +integer, +integer,
	+integer, +integer, +integer, [-integer])).
foreign(pxUngrabKey, c, pxUngrabKey(+integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxAllowEvents, c, pxAllowEvents(+integer, +integer, [-integer])).
foreign(pxGrabServer, c, pxGrabServer(+integer, [-integer])).
foreign(pxUngrabServer, c, pxUngrabServer(+integer, [-integer])).
foreign(pxGetScreenSaver, c, pxGetScreenSaver(+integer, -integer, -integer,
	-integer, -integer, [-integer])).
foreign(pxSetScreenSaver, c, pxSetScreenSaver(+integer, +integer, +integer,
	+integer, +integer, [-integer])).
foreign(pxScreenSaver, c, pxScreenSaver(+integer, +integer, [-integer])).
foreign(pxQueryAccess, c, pxQueryAccess(+integer, -integer, -integer,
	[-integer])).
foreign(pxSetAccess, c, pxSetAccess(+integer, +integer, [-integer])).
foreign(pxSetHostAccess, c, pxSetHostAccess(+integer, +integer, +string,
	[-integer])).

% event.c
%
% pxEventsQueued(+Connection, +Mode, -Count, 0)
% pxNextEvent(+Connection, +Remove, -Length, 0)
% pxGetEvent(+Connection, +Window, +Mask, +Type, +Remove, +Block, -Length, 0)
% pxSelectEvent(+NConnections, +NReadFDs, +NWriteFDs, +NExceptFDs,
%	-SConnections, -SReadFDs, -SWriteFDs, -SExceptFDs, -TimeOutFlag, 0)
%
% pxPutBackEvent(+Connection, 0)
% pxSendEvent(+Connection, +Window, +Propagate, +EventMask, 0)
%
% pxFlush(+Connection, 0)
% pxSync(+Connection, +Discard, 0)
% pxSynchronize(+Connection, +On, 0)
%
% pxNormalMotion(-Time, -X, -Y, -Next, 0)
% pxSplitMotion(-Most, -Least, -X, -Y, -Next, 0)
% pxGetMotionEvents(+Connection, +Window, -Next, 0)
%
foreign(pxEventsQueued, c, pxEventsQueued(+integer, +integer, -integer,
	[-integer])).
foreign(pxNextEvent, c, pxNextEvent(+integer, +integer, -integer, [-integer])).
foreign(pxGetEvent, c, pxGetEvent(+integer, +integer, +integer, +integer,
	+integer, +integer, -integer, [-integer])).
foreign(pxSelectEvent, c, pxSelectEvent(+integer, +integer, +integer, +integer, 
	-integer, -integer, -integer, -integer, -integer, [-integer])).
foreign(pxPutBackEvent, c, pxPutBackEvent(+integer, [-integer])).
foreign(pxSendEvent, c, pxSendEvent(+integer, +integer, +integer, +integer,
	[-integer])).
foreign(pxFlush, c, pxFlush(+integer, [-integer])).
foreign(pxSync, c, pxSync(+integer, +integer, [-integer])).
foreign(pxSynchronize, c, pxSynchronize(+integer, +integer, [-integer])).
foreign(pxNormalMotion, c, pxNormalMotion(-integer, -integer, -integer,
	-integer, [-integer])).
foreign(pxSplitMotion, c, pxSplitMotion(-integer, -integer, -integer, -integer,
	-integer, [-integer])).
foreign(pxGetMotionEvents, c, pxGetMotionEvents(+integer, +integer, -integer,
	[-integer])).

% res.c
%
% pxResourceDatabases(-Next)
% pxOpenResourceDatabase(+Connection, +Name, +Class, +OLen, -RDB, 0)
% pxCloseResourceDatabase(+RDB, 0)
%
% pxQueryResourceDatabase(+RDB, +Elements, -Value, 0)
%
foreign(pxResourceDatabases, c, pxResourceDatabases(-integer)).
foreign(pxOpenResourceDatabase, c, pxOpenResourceDatabase(+integer,
	+string, +string, +integer, -integer, [-integer])).
foreign(pxCloseResourceDatabase, c, pxCloseResourceDatabase(+integer,
	[-integer])).
foreign(pxQueryResourceDatabase, c, pxQueryResourceDatabase(+integer,
	+integer, -string, [-integer])).

% misc.c
%
% pxListExtensions(+Connection, -Next, 0)
% pxQueryExtension(+Connection, +Name, -Opcode, -Event, -Error, 0)
%
% pxGetDefault(+Connection, +Program, +Option, -Default, 0)
% pxParseGeometry(+Specification, -X, -Y, -Width, -Height, -Flags)
%
% pxGetHostName(-Name, 0)
%
% pxNoOp(+Connection, 0)
% pxOk(0)
%
foreign(pxListExtensions, c, pxListExtensions(+integer, -integer, [-integer])).
foreign(pxQueryExtension, c, pxQueryExtension(+integer, +string, -integer,
	-integer, -integer, [-integer])).
foreign(pxGetDefault, c, pxGetDefault(+integer, +string, +string, -string,
	[-integer])).
foreign(pxParseGeometry, c, pxParseGeometry(+string, -integer, -integer,
	-integer, -integer, -integer)).
foreign(pxGetHostName, c, pxGetHostName(-string, [-integer])).
foreign(pxNoOp, c, pxNoOp(+integer, [-integer])).
foreign(pxOk, c, pxOk([-integer])).

%
% eof
%
