/*  $Id: pce_postscript.pl,v 1.2 1993/05/06 10:12:21 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/

:- module(pce_postscript,
	  [ postscript/2		% Object x file
	  ]).


postscript(Obj, File) :-
	extension(File, '.ps', FileName),
	new(F, file(FileName)),
	send(F, open, write),
	send(F, append, Obj?postscript),
	send(F, format, 'showpage\n'),
	send(F, close),
	get(F, size, Size),
	format('PostScript written to ~w, ~D bytes~n', [FileName,Size]).

extension(Raw, Ext, Raw) :-
	concat(_, Ext, Raw), !.
extension(Raw, Ext, Name) :-
	concat(Raw, Ext, Name).
