/*  $Id: emacs.pl,v 1.12 1993/12/15 17:18:24 jan Exp $ $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/

:- module(emacs,
	  [ emacs/0
	  , emacs/1				% x File
	  ]).


:- use_module(library(pce)).
:- require([ ignore/1
	   , send_list/3
	   ]).


		/********************************
		*         DECLARE MODES		*
		********************************/

:- pce_global(@mode_name_type,
	      new(type(mode_name, name_of, new(chain)))).

:- get(@mode_name_type, context, Ctx),
   send(Ctx, clear),
   send_list(Ctx, append,
	     [ fundamental
	     , language
	     , prolog
	     , latex
	     , c
	     , 'c++'
	     , script
	     , text
	     , shell
	     , gdb
	     , man
	     ]).


		 /*******************************
		 *           PROLOG		*
		 *******************************/

:- new(@loading_emacs, object).
:- ensure_loaded(user:'emacs/swi_prolog').	  % SWI-Prolog extensions


		 /*******************************
		 *	    LIBRARIES		*
		 *******************************/

:- pce_autoload(file_item,		library(file_item)).


		 /*******************************
		 *          KERNEL FILES	*
		 *******************************/

:- ensure_loaded('emacs/window').		% window & modes
:- ensure_loaded('emacs/buffer').		% buffer
:- ensure_loaded('emacs/buffer_menu').		% Buffer menu/globals
:- ensure_loaded('emacs/fundamental_mode').	% Fundamental mode
:- ensure_loaded('emacs/server').		% Server mode


		 /*******************************
		 *       AUTOLOAD CLASSES	*
		 *******************************/

:- pce_autoload(emacs_hit_list,		'emacs/hit_list').
:- pce_autoload(emacs_process_buffer,	'emacs/shell').
:- pce_autoload(emacs_gdb_buffer,	'emacs/gdb').
:- pce_autoload(emacs_language_mode,	'emacs/language_mode').
:- pce_autoload(emacs_prolog_mode,	'emacs/prolog_mode').
:- pce_autoload(emacs_latex_mode,	'emacs/latex_mode').
:- pce_autoload(emacs_c_mode,		'emacs/c_mode').
:- pce_autoload('emacs_c++_mode',	'emacs/c++_mode').
:- pce_autoload(emacs_script_mode,	'emacs/script_mode').
:- pce_autoload(emacs_man_mode,		'emacs/man_mode').
:- pce_autoload(emacs_text_mode,	'emacs/text_mode').

		 /*******************************
		 *     EMACS GLOBAL OBJECTS	*
		 *******************************/

:- pce_global(@emacs_mark_list,
	      new(emacs_hit_list('Emacs Mark List'))).
:- pce_global(@emacs_base_names,
	      new(chain_table)).		  % file-base --> buffers
:- pce_global(@emacs_buffers,
	      new(dict)).			  % name --> buffer object
:- pce_global(@emacs_modes,
	      new(hash_table)).			  % name --> mode object
:- pce_global(@emacs,
	      new(emacs_buffer_menu(@emacs_buffers))).
:- pce_global(@emacs_comment_column, new(number(40))).
:- pce_global(@emacs_mode_list,			  % regex --> mode
	      new(sheet(attribute(regex('.*\.pl~?$'),   	prolog),
			attribute(regex('.*\.\(tex\|sty\)~?$'), latex),
			attribute(regex('.*\.[ch]~?$'), 	c),
			attribute(regex('.*\.C$'),		'c++'),
			attribute(regex('.*\.cc$'),		'c++'),
			attribute(regex('.*\.cpp$'),		'c++'),
			attribute(regex('[Cc]ompose\|README'),	text),
			attribute(regex('.*'),	        	script)))).


		 /*******************************
		 *           TOP-LEVEL		*
		 *******************************/

emacs :-
	send(@emacs, open),
	(   get(@emacs_server, status, listen)
	->  true
	;   (	send(@emacs_server_address, exists, @off)
	    ->  send(@emacs, report, status, 'Restarted server'),
	        send(@emacs_server_address, remove)
	    ;	true
	    ),
	    ignore(send(@emacs_server, listen))
	),
	new(_Scratch, emacs_buffer(@nil, '*scratch*')).
	
emacs(File) :-
	emacs,
	new(B, emacs_buffer(File)),
	send(B, open).

:- send(@loading_emacs, free).
