/*  $Id: imageviewer.pl,v 1.5 1993/09/29 09:28:22 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/

:- module(pce_image, [image_viewer/0]).
:- use_module(library(pce)).
:- require([ chain_list/2
	   , concat/3
	   , concat_atom/2
	   , send_list/3
	   , shell/1
	   ]).

image_viewer :-
	new(P, picture),
	send(new(D, dialog), below, P),
	send(P?frame, label, 'Image Viewer'),
	get(@pce, home, Home),
	concat(Home, '/bitmaps', DefDir),
	send(D, append, new(Dir, text_item(directory, DefDir))),
	send(D, append, new(File, text_item(file_pattern, regex('\.bm$')))),
	send(D, append, button(apply,
			       message(@prolog, view, P,
				       Dir?selection, File?selection))),
	send(D, append, button(quit,
			       message(P, destroy))),
	send(D, default_button, apply),
	send(P, open).


view(P, Dir, Pattern) :-
	new(D, directory(Dir)),
	get(D, files, Pattern, Files),
	(   send(Files, empty)
	->  send(@display, inform, 'No matching images')
	;   send(P, clear),
	    send(P?frame, label, string('Images from %s/%s',
					D?path, Pattern?pattern)),
	    chain_list(Files, List),
	    send(P, display, new(F, figure)),
	    send(F, background, @grey12_image),
	    send(F, pen, 1),
	    show(F, List, 0, 0),
	    send(F, recogniser, new(move_gesture))
	).


:- pce_global(@image_recogniser, make_image_recogniser).

make_image_recogniser(R) :-
	new(R, handler_group),
	send(R, append, click_gesture(left, '', single,
				      message(@receiver, inverted,
					      @receiver?inverted?negate))),
	send(R, append, popup_gesture(new(P, popup))),
	new(Bitmap, @event?receiver),
	new(BitmapName, Bitmap?file?name),
	send_list(P, append,
		  [ menu_item(run_bitmap_editor,
			      message(@prolog, edit, Bitmap),
			      @default, @on)
		  , menu_item(reload,
			      message(@prolog, reload, Bitmap),
			      @default, @off)
		  , menu_item(resize,
			      message(@prolog, resize, Bitmap),
			      @default, @off)
		  , menu_item(convert_to_x11,
			      message(@prolog, convert, Bitmap),
			      @default, @off)
		  , menu_item(remove,
			      and(message(@display, confirm,
					  'Remove %s', BitmapName),
				  message(@prolog, remove, Bitmap)),
			      @default, @on)
%		  , menu_item(rename,
%			      message(@prolog, rename, Bitmap),
%			      @default, @on)
		  ]).


convert(Bitmap) :-
	get(Bitmap, file, File),
	send(File, backup),
	send(Bitmap?image, save, File).


remove(Bitmap) :-
	get(Bitmap, file, File),
	send(File, remove),
	send(Bitmap, free).


reload(Bitmap) :-
	send(Bitmap?image, load),
	send(Bitmap, redraw).


edit(Bitmap) :-
	get(Bitmap?file, name, File),
	concat_atom(['bitmap ', File, ' &'], Cmd),
	shell(Cmd).


rename(Bitmap) :-
	get(Bitmap, file, _File).


resize(Bitmap) :-
	get(Bitmap, file, File),
	get(File, name, FileName),
	new(D, dialog(string('Resize image %s', FileName))),
	send(D, append, label(image, Bitmap)),
	send(D, append, new(W, text_item(width, Bitmap?width))),
	send(D, append, new(H, text_item(height, Bitmap?height))),
	send(D, append, button(ok,
			       and(message(@prolog, resize,
					   Bitmap, W?selection, H?selection),
				   message(D, destroy)))),
	send(D, append, button(cancel,
			       message(D, destroy))),
	send(D, default_button, ok),
	send(D, open).

resize(Bitmap, W, H) :-
	get(Bitmap, file, File),
	new(I2, image(@nil, W, H)),
	send(I2, draw_in, Bitmap, point(0,0)),
	send(Bitmap, image, I2),
	send(File, backup),
	send(I2, save, File),
	send(I2, load, File).


show(_, [], _, _) :- !.
show(P, [F|R], X, Y) :-
	new(I, image(F)),
	new(B, bitmap(I)),
	send(B, recogniser, @image_recogniser),
	BX is X * 100 + 5,
	BY is Y * 90 + 5,
	send(P, display, B, point(BX, BY)),
	new(T, text(F, center, font(screen, roman, 10))),
	send(T, transparent, @off),
	TX is BX + 50,
	TY is BY + 80,
	send(T, center, point(TX, TY)),
	send(P, display, T),
	next_xy(X, Y, NX, NY),
	show(P, R, NX, NY).
show(P, [_|R], X, Y) :-
	show(P, R, X, Y).

next_xy(X, Y, NX, Y) :-
	NX is X + 1,
	NX < 10, !.
next_xy(_, Y, 0, NY) :-
	NY is Y + 1.
