/*  $Id: pce_sp.pl,v 1.5 1993/05/06 10:11:53 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/

:- module(pce_host, [user_help/0]).


		/********************************
		*        LOADING C-PART		*
		********************************/

foreign(prolog_pce_init, pce_init).
foreign_file('/ISP/xpce/sp/src/sp-pce1.o', [prolog_pce_init]).
foreign_file('/ISP/xpce/sun4/XPCE.o', []).

'$load_pce' :-
	load_foreign_files([ '/ISP/xpce/sp/src/sp-pce1.o'
			   , '/ISP/xpce/sun4/XPCE.o'
			   ],
			   [ '-lXt'
			   , '-lX11'
			   , '-lpixrect'
			   , '-lm'
			   ]),
	pce_init,
	prolog:'$set_meta_declaration'(send(+, :), pce_principal),
	prolog:'$set_meta_declaration'(send(+, :, +), pce_principal),
	prolog:'$set_meta_declaration'(send(+, :, +, +), pce_principal),
	prolog:'$set_meta_declaration'(send(+, :, +, +, +), pce_principal),
	prolog:'$set_meta_declaration'(get(+, :, -), pce_principal),
	prolog:'$set_meta_declaration'(get(+, :, ?, -), pce_principal),
	prolog:'$set_meta_declaration'(get(+, :, ?, ?, -), pce_principal),
	prolog:'$set_meta_declaration'(get(+, :, ?, ?, ?, -), pce_principal).

user_help :-
	use_module(library(pce_manual)),
	manpce.

:- initialization(pce_reinitialise).

pce_reinitialise :-
	pce_boot:pce_reinitialise,
	format('~nFor HELP, please invoke the predicate `manpce''.~n~n', []).
	
 
print_exception(Excp) :-
       format("Exception caught by hostSend/Get:~n", []),
       prolog:puncaught(Excp).
