'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/read.n,v 1.1 93/05/10 17:10:20 ouster Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS read tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
read \- Read from a file
.SH SYNOPSIS
\fBread \fR?\fB\-nonewline\fR? \fIfileId\fR
.br
\fBread \fIfileId numBytes\fR
.BE

.SH DESCRIPTION
.PP
In the first form, all of the remaining bytes are read from the file
given by \fIfileId\fR; they are returned as the result of the command.
If the \fB\-nonewline\fR switch is specified then the last
character of the file is discarded if it is a newline.
In the second form, the extra argument specifies how many bytes to read;
exactly this many bytes will be read and returned, unless there are fewer than
\fInumBytes\fR bytes left in the file; in this case, all the remaining
bytes are returned.
\fIFileId\fR must be \fBstdin\fR or the return
value from a previous call to \fBopen\fR; it must
refer to a file that was opened for reading.

.SH KEYWORDS
file, read
