%-----------------------------------------------------------------------%
%									%
%			Edipo - sicstus/quintus version			%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		gc.pl						%
%	purpose : 	gc creation and manipulation			%
%	creation	90/08/01					%
%	last changes :	92/04/10					%
%	bugs :		invalid attributes values are not trapped	%
%	comments :	current_gc could be implemented in X11 R4	%
%									%
%-----------------------------------------------------------------------%

	
	   	
%	if Name refers to an existing GC of the working window
%		change Attrs in Name
%	else
%		creates a gc Name with Attrs for the working window
%	Name is the new working gc for the working window
gc(Name,Attr) :-
	recorded('$window','$window'(WindowName,Display,Window,_),Ref), !,
	erase(Ref),
	get_gc(Name,Display,Window,GC),
	recorda('$window','$window'(WindowName,Display,Window,GC),_),
	set_gc_attr_list(Attr,Display,GC).

%	selects Name as the working gc for the working window
%	(like gc(Name,[]) if Name is an existing gc for ...
%	but gives an error otherwise)

working_gc(Name) :-
	recorded('$window','$window'(WindowName,_Display,_Window,_),_), !,
	working_envir(WindowName,Name).

working_envir(Name) :- working_envir(Name,Name).

working_envir(WindowName,GCName) :-
	recorded('$window','$window'(WindowName,Display,Window,_),Ref), !,
	erase(Ref),
	(recorded('$gc','$gc'(GCName,Window,GC),_)  -> 
	    recorda('$window','$window'(WindowName,Display,Window,GC),_)
	;
	    format('[[edipo: unknown gc "~w" for window "~w" ]]~n',
	    GCName,WindowName)
	).



%	a gc duplicate of the current working gc is created 
%	with name NewGCName
%	NewGCName is the new current gc 

dup_gc(NewGCName) :- 
	recorded('$window','$window'(_WindowName,Display,Window,GC),_), !,
	(recorded('$gc','$gc'(NewGCName,Window,NewGC),Ref)  -> 
	    erase(Ref)
	;
	    x_create_gc(Display,Window,0,0,NewGC)
	),
	All_Flags is \(0),
	x_copy_gc(Display,GC,All_Flags,NewGC),
	recorda('$gc','$gc'(NewGCName,Window,NewGC),_).

% -- utils --------------------------


% low-level gc creation

get_gc(Name,Display,Window,GC) :- 
	(recorded('$gc','$gc'(Name,Window,GC),Ref)  -> 
	    erase(Ref)	
	;
	    x_create_gc(Display,Window,0,0,GC),
	    
	    get_default_pixels(Display,WH,BL),		% GC default values
	    x_set_foreground(Display,GC,BL),
	    x_set_background(Display,GC,WH),
	    get_default_font(Display,Font), 	x_set_font(Display,GC,Font)
	),
	recorda('$gc','$gc'(Name,Window,GC),_).

set_gc_attr_list([],D,GC) :- x_my_change_gc(D,GC).
set_gc_attr_list([A=V|R],D,GC) :-
	set_gc_attr(A,V,D,GC), !,
	set_gc_attr_list(R,D,GC).
set_gc_attr_list([AV|R],D,GC) :-
	format('[[ytoolkit: illegal attribute ~w]]~n',AV),
	set_gc_attr_list(R,D,GC).

set_gc_attr(foreground,F,D,GC) :- 
	x_get_color_pixel(D,F,C),
	x_set_foreground(D,GC,C).
set_gc_attr(background,B,D,GC) :-
	x_get_color_pixel(D,B,C), 
	x_set_background(D,GC,C).
set_gc_attr(tile,T,D,GC) :- 
	get_pixmap(T,P),
	'XSetTile'(D,GC,P).
set_gc_attr(stipple,T,D,GC) :-
	get_pixmap(T,P), 
	'XSetStipple'(D,GC,P).
set_gc_attr(font,FN,D,GC) :- 
	x_load_font(D,FN,F),
	(F=0 ->
	    format('[[ytoolkit: invalid font ~w]]~n',FN)
	;
		x_set_font(D,GC,F)
	    ).


set_gc_attr(line_width,Value,_,_) :- !,
	x_set_gc_int_attr(line_width,Value).
set_gc_attr(Attr,Value,_,_) :-	atom_attr(Attr), !,
	x_set_gc_atom_attr(Attr,Value).

atom_attr(cap).
atom_attr(join).
atom_attr(function).
atom_attr(line_style).
atom_attr(fill_style).
atom_attr(fill_rule).
atom_attr(arc_mode).

