% unify.nl
%
% unify a parsetree with a '++' construct

% P is a node, Q is a ++  
unify( P, pplus( T, Sub, N)) :-
	isNode(P),
	var(T), !,
	unify_sub( P, T, Sub, N).
% P is a variable, T is a node with gaps
unify( P, pplus( T, Sub, N)) :-
	var(P),
	isNode(T), !,
	unify_sub( T, P, Sub, N).
% P or Q is a seq, the other is a node 
unify( P, seq( List)) :-
	isNode( P), !,
	unify_seq( P, List).
unify( seq( List), Q) :-
	isNode( Q), !,
	unify_seq( Q, List).
% if all else fails
unify( P, Q) :-
	P = Q.

% unify_sub( +Parsetree, -Parsetree, +Sub, +GapNum)
%
% depends on the format of Sub, as to which search to call
% Sub is a single sub/3
unify_sub( P, T, Sub, N) :-
	Sub = sub( _, _, _), !,
	search_l( P, T, N, none, _, [Sub], []).
% Sub is a list of sub/3
unify_sub( P, T, Subs, N) :-
	Subs = [ _|_], !,
	strings_csubs( Subs, Subs1),
	search_l( P, T, N, none, _, Subs1, Rsubs),
	check_Rsubs( _, Rsubs).
% Sub is a sseq of Subs (i.e. each sub must represent contiguous leaves in the 
% parse tree P
unify_sub( P, T, sseq( Subs), N) :-
	!, strings_subs( Subs, Subs1),
	search_sseq( P, T, N, none, _, none, MS, Subs1, RSubs),
	check_Rsubs( MS, RSubs).
% Sub is a mult
unify_sub( P, T, mult( Type, Toks, Pts), N) :-
	!, search_l( P, T, N, none, _, [ mult( Type, Toks, Pts)], 
					[mult( Type, [], [])]).
% Sub is a string
unify_sub( P, T, S, N) :-
	string( S), 
	S \== [], !,
	s_subs(S, Subs),
	search_sseq( P, T, N, none, some, none, none, Subs, []).


% s_subs( +String, -Subs)
%
% convert String into sub( Grsymbol, Tokens, Parsetree) form
%
s_subs( String, Subs) :-
	stringToTokens( String, Tokens),
	tokens_subs( Tokens, Subs).

tokens_subs( [], []) :- !.
tokens_subs( [ H|T], [ Sub|Subs]) :-
	!, t_sub( H, Sub),
	tokens_subs( T, Subs).

t_sub( [ Item|T], sub( T, [Item], tnode( T, [Item]))).

% convert a list of strings, to a list of "subs"
%
strings_subs( [], []):- !.
strings_subs( [ sub( T, L, P)|Rest], [ sub( T, L, P)|RestSubs]) :-
	!, strings_subs( Rest, RestSubs).
strings_subs( [ mult( T, L, P)|Rest], [ mult( T, L, P)|RestSubs]) :-
	!, strings_subs( Rest, RestSubs).
strings_subs( [  S|Rest], NewSubs) :-
	!, s_subs(  S, Csubs),
	strings_subs( Rest, RestSubs),
	append( Csubs, RestSubs, NewSubs).

% csubs - for a subsequence inside a list
%
s_csubs( String, Subs) :-
	stringToTokens( String, Tokens),
	tokens_csubs( Tokens, Subs).

tokens_csubs( [], []):- !.
tokens_csubs( [ H|T], [ Sub|Subs]) :-
        !, t_csub( H, Sub),
        tokens_csubs( T, Subs).

t_csub( [ Item|T], csub( T, [Item], tnode( T, [Item]))).

strings_csubs( [], []):- !.
strings_csubs( [ csub( T, L, P)|Rest], [ csub( T, L, P)|RestSubs]) :-
        !, strings_csubs( Rest, RestSubs).
strings_csubs( [ sub( T, L, P)|Rest], [ sub( T, L, P)|RestSubs]) :-
        !, strings_csubs( Rest, RestSubs).
strings_csubs( [ mult( T, L, P)|Rest], [ mult( T, L, P)|RestSubs]) :-
        !, strings_csubs( Rest, RestSubs).
strings_csubs( [  S|Rest], NewSubs) :-
        !, s_csubs(  S, Csubs),
        strings_csubs( Rest, RestSubs),
        append( Csubs, RestSubs, NewSubs).

check_Rsubs( mult, [ mult( _, [], [])]):- !.
check_Rsubs( _, []):- !.


	
