% tokens.pl
%
% contains all the predicates that manipulate tokens
%
%

% build_tokens( +String, -Tokens)
% given a String, returns a list of Tokens
% uses NU-Prolog's built-in tokenizer
%
build_tokens( String, CleanTokens) :-
	stringToTokens( String, Tokens), 
	strip_lists( Tokens, CleanTokens).

strip_lists( [], []).
strip_lists( [ [Token|_]|Tokens], [Token|CleanTokens]) :-
	strip_lists( Tokens, CleanTokens).

% tokens_in_children( +Tokens, +Children)
% Succeeds if Tokens can be found in Children ( a list of parse trees)
%
tokens_in_children( Toks, Children) :-
	ground( Toks),
	nonvar( Children),!, 
	nodes_to_list( Children, Tokens, []),
	tokens_in_tokens( Toks, Tokens).
tokens_in_children( _, _). % succeeds if Toks is nonground or Children is a var

tokens_in_tokens( [], _).
tokens_in_tokens( [ Tok|RToks], Tokens) :-
	one_token( Tok, Tokens, Tokens1),
	tokens_in_tokens( RToks, Tokens1).

one_token( Tok, [ Tok|RToks], RToks) .
one_token( Tok, [ Tok2|RToks], RToks1) :-
	Tok2 \==Tok,
	one_token( Tok, RToks, RToks1).

% extract_tokens( +Parsetrees, -Tokens)
% Given a list of parse trees, returns a list of Tokens
%
extract_tokens( [N|R], List) :-
	nodes_to_list( [N|R], List, []).
extract_tokens( Node, List) :-
	Node \== [_|_],
	node_l( Node, List, []).

node_l( tnode( _, List), NewList, Sofar ) :-
	!, append( List, Sofar, NewList).
node_l( node( _, [empty]), Sofar, Sofar):- !.
node_l( gap(_), Sofar, Sofar):- !.
node_l( node( _, Nodes),  NewList, Sofar) :-
	Nodes \== [empty], !, 
	nodes_to_list( Nodes, NewList, Sofar).
node_l( String, List, Sofar) :-
	string( String), !, 
	build_tokens( String, Toks),
	append( Toks, Sofar, List).

nodes_to_list( [], SoFar, SoFar).
nodes_to_list( [ Node|Nodes], NewList, Sofar) :-
	nodes_to_list( Nodes, List, Sofar),
	node_l( Node, NewList, List).

