% timings
%
% Once loaded into ptn, the following code will produce some
% comparisons of the processing time taken for pre-built
% proofs and proofs built at runtime (as per S & S "solve")
%
% the code can be compiled to speed it up, except the blocks.nl
% and water.nl - "solve" uses the built-in clause/2 predicate
% which requires the clauses are not compiled.

% consult the files required
 
:-[proof_gr].
:-[proof].
:-[blocks].
:-[solve].
:-[water].

timings(blocks) :-
	write( 'Solving the "blocks world" problem using S & S meta interpreter'),
	nl,
	nl,
	timer( solve( test_plan( test, P), Pr), T),
	write( 'CPU time: '),
	Time is T / 1000,
	write( Time), 
	write( ' seconds'), nl, nl,
	write( 'Pre-proofing the blocks.nl file - to produce blocksProof.nl '),
	nl, nl, 
	timer( proof( blocks), T2),
	Time2 is T2 / 1000,
	write( 'CPU time: '),
	write( Time2),
	write( '  seconds'),nl, 
	load( blocksProof), nl,
	write( 'Solving the "blocks world" problem using pre-compiled proofs '),
	nl,nl,
	timer( test_plan( test, P1, Pr1), T1), !,
	write( 'CPU time: '),
        Time1 is T1 / 1000,
        write( Time1),
        write( ' seconds'), nl, nl.

timings(water) :-
	 write( 'Solving the "water jugs" problem using S & S meta interpreter'
),
        nl,
        nl,
        timer( solve( go( state(5, 0), state(2,3),Path), Pr), T),
        write( 'CPU time: '),
        Time is T / 1000,
        write( Time),
        write( ' seconds'), nl, nl,
        write( 'Pre-proofing the water.nl file - to produce waterProof.nl '),
        nl, nl,
        timer( proof( water), T2),
        Time2 is T2 / 1000,
	write( 'CPU time: '),
        write( Time2),
        write( '  seconds'), nl,
	load(waterProof), nl,
        write( 'Solving the "water jugs" problem using pre-compiled proofs '),
        nl,nl,
        timer( go( state(5, 0), state(2,3),Path, Pr1), T1),
        write( 'CPU time: '),
        Time1 is T1 / 1000,
        write( Time1),
        write( ' seconds'), nl, nl.
	
timer( X, Time) :-
	statistics( _),
	call( X),
	statistics( T),
	member( utime=[_, Time], T).

