% test.mod
:- module search.

:- local 
	span/3.
	spanned/3.
	search_l_c/7.
	search_sseq_c/7.	% arity 7 not there!

% a comment


% search.pl

search_l(tnode(Tp, Toks), gap(N), N, CS, CS, 
                        [mult(Tp, [Toks|LToks], [tnode(Tp,Toks)|Lpts])|Subs],
                        [mult(Tp, LToks, Lpts)|Subs]).
search_l(node(Type, Chs), gap(N), N, CS, CS,    
			[sub(Type, Tokens, S)|Subs], Subs):-
	nonvar(Tokens),
	spanned(Chs, Tokens, []).
search_l(node(Type, Chs), gap(N), N, CS, CS,    
			[sub(Type, Tokens, S)|Subs], Subs):-
	var(Tokens),
	extract_tokens(S, Tokens). 
search_l(node(Type, Chs), gap(N), N, _, some,
                        [csub(Type, Tokens, S)|Subs], Subs):-
        nonvar( Tokens),
	spanned(Chs, Tokens, []).
search_l(node(Type, Chs), gap(N), N, _, some,    
			[csub(Type, Tokens, S)|Subs], Subs):-
	var(Tokens),
	extract_tokens(S, Tokens). 
search_l(node(Tp, Chs), NewNode, N, CS, CS1,  
			 [mult(_, _, _)|Subs], RSubs):-
	search_l(node(Tp, Chs), NewNode, N, CS, CS1, Subs, RSubs).
search_l(node(Tp, Chs), gap(N), N, CS, CS,   
			[mult(Tp, [Toks|LToks], [node(Tp,Chs)|Lpts])|Subs],
			[mult(Tp, LToks, Lpts)|Subs]):-
	extract_tokens(Chs, Toks).
search_l(gap(N), gap(N), N1, CS, CS,  
		[sub(Type, Toks, S)|Subs], [sub(Type, Toks, S)|Subs]):-
	var(S).
search_l(gap(N), gap(N), N1, CS, CS,
                [csub(Type, Toks, S)|Subs], [csub(Type, Toks, S)|Subs]):-
        var(S).
search_l(gap(N), gap(N), N1, CS, CS, [mult(Tp, LToks, LPTs)|Subs], 
			[mult(Tp, LToks, LPTs)|Subs]):-
	var(LToks).
search_l(gap(N), S, N, CS, CS, [sub(_, _, S)|Subs], Subs):-
	nonvar(S).
search_l(gap(N), S, N, _, some, [csub(_, _, S)|Subs], Subs):-
        nonvar(S).
search_l(gap(N), Pt, N, CS, CS, [mult(Tp, [_|LToks], [Pt|Pts])|Subs],
                        [mult(Tp, LToks, Pts)|Subs]):-
	nonvar(Pt).
search_l(node(Tp, [empty]), node(Tp, [empty]), _, CS, CS, S, S).
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1, 
			Subs, RestSubs):-  
	var(S),
	number(N),	%replacing
	tokens_in_children(Toks, Chs), % speeds up search if Toks not in Chs
	search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
search_l( node(Type, Chs), node(Type, NewChs), N, CS, CS1,  
                       Subs, RestSubs):-
	nonvar(S),
	number(N),		%putting back
	search_l_c(Chs, NewChs, N,  CS, CS1, Subs, RestSubs).
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1, 
			Subs, RestSubs):-  
	nonvar(S),
	var(N),	%just looking
	tokens_in_children(Toks, Chs), % speeds up search if Toks not in Chs
	search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1,
                        Subs, RestSubs):-
	var(S),
        tokens_in_children(Toks, Chs), % speeds up search if Toks not in Chs
        search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
search_l( node(Type, Chs), node(Type, NewChs), N, CS, CS1,
                       Subs, RestSubs):-
	nonvar(S),
	search_l_c(Chs, NewChs, N,  CS, CS1, Subs, RestSubs).
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1, Subs, RestSubs):-
	search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
%search_l_c( [], [], _, Cs, Cs, [], []).
search_l_c([], [], _,  CS, CS, S, S).
search_l_c([Ch|Chs], [NewCh|NewChs], Gnum, CS, CS2, Subs, RestSubs):-
	search_l(Ch, NewCh, Gnum, CS, CS1, Subs, MoreSubs), 
	search_l_c(Chs, NewChs, Gnum, CS1, CS2, MoreSubs, RestSubs).
search_l_c([Ch|Chs], [Ch|NewChs], Gnum, CS, CS1, Subs, RestSubs):-
	search_l_c(Chs, NewChs, Gnum, CS, CS1, Subs, RestSubs).
search_l_c([Ch|Chs], [Ch|NewChs], Gnum, none, CS1, Subs, RestSubs):-
	search_l_c(Chs, NewChs, Gnum, none, CS1, Subs, RestSubs).
search_l_c([Ch|Chs], [NewCh|NewChs], N, CS, CS1,  
			[mult(_, [], [])|Subs], RSubs):-
	search_l_c([Ch|Chs], [NewCh|NewChs], N, CS, CS1, Subs, RSubs).


% search_sseq
%
search_sseq(tnode(Tp, Toks), gap(N), N, _, some, _ ,mult,
                        [mult(Tp, [Toks|LToks], [tnode(Tp,Toks)|Lpts])|Subs],
                        [mult(Tp, LToks, Lpts)|Subs]).
search_sseq(node(Tp, Chs), gap(N), N, _, some, Ms, Ms, 
			[sub(Tp, Toks, S)|Subs], Subs):-
	nonvar(Toks),
	spanned(Chs, Toks, []).
search_sseq(node(Tp, Chs), gap(N), N, _, some, Ms, Ms,
			[sub(Tp, Toks, S)|Subs], Subs):-
	var(Toks),
	extract_tokens(S, Toks).
search_sseq(node(Tp, Chs), gap(N), N, _, some, _, mult,
			[mult(Tp, [Toks|LToks], [node(Tp,Chs)|Lpts])|Subs],
			[mult(Tp, LToks, Lpts)|Subs]):-
	extract_tokens(Chs, Toks).
search_sseq(gap(N), gap(N), N1, SS, SS, MS, MS,
			[sub(Tp, Toks, S)|Subs],  [sub(Tp, Toks, S)|Subs]):-
	var(S).
search_sseq(gap(N), gap(N), N1, SS, SS, MS, MS, 
			[mult(Tp, LToks, LPTs)|Subs], 
			[mult(Tp, LToks, LPTs)|Subs]):-
	var(LToks).
search_sseq(gap(N), S, N, _, some, MS, MS,  
			[sub(Tp, Toks, S)|Subs], Subs):-
	nonvar(S).
search_sseq(gap(N), Pt, N, _, some, _, mult,
			[mult(Tp, [_|LToks], [Pt|Pts])|Subs],
                        [mult(Tp, LToks, Pts)|Subs]):-
	nonvar(Pt).
search_sseq(node(Tp, [empty]), node(Tp, [empty]), _, 
			SS, SS, MS, MS, Subs, Subs).
search_sseq(node(Tp, Chs), node(Tp, NewChs), N, SS, SS1, MS, MS1,
			Subs, Rsubs):-
	var(S),
	number(N), 	%search & remove 
	tokens_in_children(Toks, Chs),
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subs, Rsubs).
search_sseq(node(Tp, Chs), node(Tp, NewChs), N, SS, SS1, MS, MS1,
			Subs, Rsubs):-
	nonvar(S),
	number(N), 	% putting back
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subs, Rsubs).
search_sseq(node(Tp, Chs), node(Tp, NewChs), N, SS, SS1, MS, MS1,
			Subs, Rsubs):-
	nonvar(S),
	var(N),	 % just looking 
	tokens_in_children(Toks, Chs),
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subs, Rsubs).
search_sseq(node(Type, Chs), node(Type, NewChs), N, SS, SS1, MS, MS1,
				Subs, RSubs):-
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subss, RSubs).


search_sseq_c([], [], N, SS, SS, MS, MS, Subs, Subs). 
search_sseq_c([Ch|Chs], [NewCh|NewChs], N, SS, SS2, MS, MS2, 
				Subs, Rsubs):-
	search_sseq(Ch, NewCh, N, SS, SS1, MS, MS1, Subs, Subs1), 
	search_sseq_c(Chs, NewChs, N, SS1, SS2, MS1, MS2, Subs1, Rsubs).
search_sseq_c([Ch|Chs], [Ch|NewChs], N, none, SS, MS, MS1, Subs, Rsubs):-
	search_sseq_c(Chs, NewChs, N, none, SS, MS, MS1, Subs, Rsubs).
search_sseq_c([Ch|Chs], [NewCh|NewChs], N, some, SS, mult, MS,
			[mult(Tp, [], [])|Subs], Rsubs):- %no mults left
	search_sseq_c([Ch|Chs], [NewCh|NewChs], N, some, SS, none, MS,
				Subs, Rsubs).


spanned([], T, T).
spanned([empty], [], []).
spanned([Ch|Chs], Tokens, RestTokens):-
	span(Ch, Tokens, MoreTokens),
	spanned(Chs, MoreTokens, RestTokens).


span(tnode(_, Tokens), T, NewT):-
	append(Tokens, NewT, T).
span(node(_, Chs), T, NewT):-
	spanned(Chs, T, NewT).
span(tnode(_, [empty]), T, T).
span(node(_, [empty]), T, T).













