% interm.nl
%
% please see README file for explanation about interms

% need interm_gr.nl - the grammar

% interm( +Basename)
%
% get the tokens from the file and parse them, producing Node (the program
% parse tree)
% after extracting all the clause parse trees, a call to arg_inTerms/2
% translates the clauses and returns the parse trees in NewClPts
% these are then re unified with the program parse tree and the resultant
% tokens are printed out.
interm(Basename) :-
	name( Basename, Chars),
        append( Chars, ".int", InputFile),
	append( Chars, ".nl", OutputFile),
        get_tokens( InputFile, Toks), !,
        program( Toks, [], Node), !,
	unify( Node, pplus( T, mult( clause1, _, ClPts), 1)),
	!, arg_inTerms( ClPts,  NewClPts),
	unify( Newnode, pplus( T, mult( clause1, _, NewClPts), 1)),
	extract_tokens( Newnode, Tokens2),
	print_tokens( OutputFile, Tokens2).		


arg_inTerms( [], []).
arg_inTerms( [ ClPt|ClPts], [NClPt|NClPts]) :-
	arg_inTerm( ClPt, NClPt), !,
	arg_inTerms( ClPts, NClPts).

% arg_inTerm( +ClausePt, -NewClausePt)
%
% unify with a sequence of subs representing the head and body of the
% clause 
% The first clause is dealing with clauses that have no body -
% i.e. the token returned is []
% the head  is then unified with the interm construct Atom{ Interms }
% the Interms are translated into new NewTPts, which are used to
% replace Interms, A new clause is then constructed Atom([ NewTerms]).
% 
arg_inTerm( ClPt, NewClPt) :-
 	Plus = pplus( _, sseq( [sub(head, _, HeadPt), sub(body, [], _)]), 2),
        unify( ClPt, Plus),!,
	Plus1 = pplus( _,  sseq( [ sub( atom, _, Apt), "{",
				 sub( inTerms, _, IPt), "}"]), 3),
	unify( HeadPt, Plus1), 
	Plus2 = pplus( T2, mult( inTerm, _, ItPts), 4),
	unify( IPt, Plus2),
	interms_terms( ItPts, NewTPts),
	Plus3 = pplus( T2, mult( term, _, NewTPts), 4),
	unify( NewTermPt, Plus3),
	build_parse( clause1, [ Apt, "(", "[", NewTermPt, "])"], NewClPt).
% This clause translates body goals containing the interm notation
% into "lookup" goals
arg_inTerm( ClPt, NewClPt) :-
 	Plus = pplus( _, sseq( [sub(head, _, HeadPt),
                                sub( body, B, BodyPt )]), 2),
        B \== [],
	unify( ClPt, Plus),!,
	Plus1 = pplus( T1, mult( goal, _, GPts), 3),
	unify( BodyPt, Plus1),!,
	convert_goals( GPts, NewGPts),
	Plus2 = pplus( T1, mult( goal, _, NewGPts), 3),
	unify( NewBodyPt, Plus2),
	build_parse( clause1, [HeadPt, NewBodyPt], NewClPt).

convert_goals( [], []).
convert_goals( [GPt|GPts], [NewGPt|NewGPts]) :-
	goal_newgoal( GPt, NewGPt),
	convert_goals( GPts, NewGPts).

% each goal is unified with the Atom{Interms} notation and if successful,
% each Term in Interms is translated into a Name(Value) term. These are
% replaced in the Term and a lookup( Atom, [Terms]). goal is returned 
goal_newgoal( GPt, NewGPt) :-
	Plus1 = pplus( _,  sseq( [ sub( atom, _, Apt), "{",
				sub( inTerms, _, IPt), "}"]), 4),
	unify( GPt, Plus1),!, 
	Plus2 = pplus( T1, mult( inTerm, _, ItPts), 5),
	unify( IPt, Plus2),
	interms_terms( ItPts, NewTPts),
	Plus3 = pplus( T1, mult( term, _, NewTPts), 5),
	unify( NewTermPt, Plus3),
	build_parse( goal, ["lookup(", Apt,  ", [", NewTermPt,"])"], NewGPt).
goal_newgoal( GPt, GPt). 


interms_terms( [], []).
interms_terms( [It|Its], [T|Ts]) :-
	interm_term( It, T),
	interms_terms( Its, Ts).

% interm_term( +Interm, -Term)
%
% translate an Atom:Value interm into a Atom(Value) term
%
interm_term( InTerm, Term) :-
	Plus = pplus( _, sseq([ sub(atom, _, TPt), ":",
				sub(term, _, T1Pt)]), 6),
	unify( InTerm, Plus),
	build_parse( term, [  TPt, "(", T1Pt, ")"], Term).

% lookup( +Pred, +List)
%
% used by querys translated from interm format
%
lookup( Pred, List) :-
	Args =..[Pred, List1],
	call( Args),
	all_members( List, List1).

all_members( [], _).
all_members( [H|T], List) :-
	member( H, List),
	delete( H, List, Rest), !,
	all_members( T, Rest).



