% fun.nl
%
% need the grammar in fun_gr.nl 

% fun( +Basename)
%
% translate a program written in Prolog with functional notation into
% "raw" Prolog
% 
fun( Basename) :-
	name( Basename, Chars),
        append( Chars, ".fun", InputFile),
	append( Chars, ".nl", OutputFile),
		% get tokens from file and parse according to grammar
        get_tokens( InputFile, Toks),	
        program( Toks, [], Node),!,
		% extract clauses from program
	unify( Node, pplus( T, mult( clause1, _, ClausePts), 1)), 
		% translate the clauses
	arg_goals( ClausePts,  NewClausePts, 2, _),
		% return clauses to program
	unify( Newnode, pplus( T, mult( clause1, _, NewClausePts), 1)),
		% extract tokens and print out 
	extract_tokens( Newnode, Tokens2),
	print_tokens( OutputFile, Tokens2).		


arg_goals( [], [], N, N).
arg_goals( [ ClPt|ClPts], [NClPt|NClPts], Nin, Nout) :-
	arg_goal( ClPt, NClPt, Nin, N1), !,
	arg_goals( ClPts, NClPts, N1, Nout).

% arg_goal( +ClausePt, -NewClPt, +GapNum, -GapNum)
%
% all terms are extracted from the Clause parse tree and passed
% to arg-terms/7 for transformation, NewTerms are returned, along
% with any NewGoals. The NewTerms are returned to the clause and the
% NewGoals added.
arg_goal( ClausePt, NewClausePt, N, N3) :-
	Plus1 = pplus( T,  mult( term, _, TermPts), N),
	unify( ClausePt, Plus1),
	N1 is N + 1,
	arg_terms( TermPts, NewTermPts, NewGoals, [], N1, N2),
	Plus2 = pplus( T, mult( term, _, NewTermPts), N),
	unify( ClausePt1, Plus2),
	add_goals( ClausePt1, NewGoals, NewClausePt, N2, N3).	


arg_terms( [], [], G, G, N, N).
arg_terms( [TPt|TPts], [NTPt|NTPts], NewGoals, Goals, N, Nout) :-
	arg_t( TPt, NTPt, Goals1, Goals, N, N1),	
	arg_terms( TPts, NTPts, NewGoals, Goals1, N1, Nout).	

% arg_t( +TermPT, -TermPt, -NewGoals, +GoalsSoFar, +Gapnum, -GapNum)
%
% TermPt is recursively unified with a sequence of subs describing the 
% functional notation : Goal >> Var
% if it unifies, then the Var is returned into the Term parse tree and
% the Goal is added to GoalsSoFar.
arg_t( TermPt, NewTPt, NewGoals2, Goals, N, N2) :-
	Plus2 = pplus( T2, sseq([ sub( goal, _, GoalPt), 
			">>", sub( var, V, VarPt)]), N),
	unify( TermPt, Plus2),!,
	unify( NewTPt, pplus( T2, sub( var, V, VarPt), N)),
	N1 is N + 1,
	arg_t( GoalPt, NewGPt, NewG1, Goals, N1, N2),
	append( [NewGPt], NewG1, NewGoals2).
arg_t( T, T, G, G, N, N).

add_goals( ClPt, [], ClPt, N, N).	
add_goals(ClPt, [G|Gs], NewClausePt, N, N2):-
	add_g( ClPt, G, ClPt1, N, N1),
	add_goals( ClPt1, Gs, NewClausePt, N1, N2).

% add_g( +ClausePt, +GoalPt, -NewClausePt, +GapNum, -NewGapNum)
%
% The Clause is unified with a Head parse tree and a Body parse tree 
% and Goals are added to the body, a NewBody is returned and the
% NewClausePt is built up from the Head & Body parse trees
add_g( ClausePt, GoalPt, NewClausePt, N, N1):-	
	Plus = pplus( _, sseq( [sub(head, _, HeadPt), 
				sub( body, _, BodyPt)]), N),
	unify( ClausePt, Plus),!, 
	N1 is N + 1,
	add_body( BodyPt, GoalPt, NewBodyPt, N1),
	build_parse( clause1, [ HeadPt, NewBodyPt], NewClausePt).

% add_body( +BodyPt, +GoalPt, -NewBodyPt, +GapNum)
%
% add the GoalPt to the BodyPt
% first clause unifies with a body that contains no goals ([])
add_body(  BodyPt, GoalPt, NewBodyPt, N1) :-
	Plus = pplus( _, sub( body, [], _), N1),
	unify( BodyPt, Plus),
	build_parse(  body, [ ":-", GoalPt], NewBodyPt).
add_body( BodyPt, GoalPt, NewBodyPt, N1) :-
	Plus = pplus( _, sseq([ ":-", sub( goal, _, Goal1Pt), 
				sub( restBody, _, RbodyPt)]), N1),
	unify( BodyPt, Plus),
	build_parse( body, [":-", GoalPt, ",", Goal1Pt, RbodyPt], NewBodyPt).


	
