%
%  8queen.pl			Nai-Wei Lin			November, 1991
%
%  This program plays the 8-queens game.
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(eight_queens/8,[-,-,-,-,-,-,-,-]).
:- measure(eight_queens/8,[int,int,int,int,int,int,int,int]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
eight_queens(X1,X2,X3,X4,X5,X6,X7,X8) :-
	generator(8,8,[X1,X2,X3,X4,X5,X6,X7,X8]),
	queens(X1,X2,X3,X4,X5,X6,X7,X8).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(queens/8,[+,+,+,+,+,+,+,+]).
:- measure(queens/8,[int,int,int,int,int,int,int,int]).
:- domain(queens/8,[1-8,1-8,1-8,1-8,1-8,1-8,1-8,1-8]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
queens(X1,X2,X3,X4,X5,X6,X7,X8) :-
	safe([X1,X2,X3,X4,X5,X6,X7,X8]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(safe/1,[+]).
:- measure(safe/1,[length]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
safe([]).
safe([X|L]) :-
	noattacks(L,X,1),
	safe(L).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(noattacks/3,[+,+,+]).
:- measure(noattacks/3,[length,int,void]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
noattacks([],_,_).
noattacks([Y|L],X,D) :-
	noattack(X,Y,D),
	D1 is D+1,
	noattacks(L,X,D1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(noattack/3,[+,+,+]).
:- measure(noattack/3,[int,int,void]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
noattack(X,Y,D) :- X =\= Y,  Y-X =\= D,  Y-X =\= -D.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(generator/3,[+,+,-]).
:- measure(generator/3,[int,int,length]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
generator(0,_,[]).
generator(M,N,[Q|L]) :-
	M > 0,
	choose(N,Q),
	M1 is M-1,
	generator(M1,N,L).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(choose/2,[+,-]).
:- measure(choose/2,[int,int]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
choose(N,N) :-
	N >= 1.
choose(N,M) :-
	N > 1,
	N1 is N-1,
	choose(N1,M).

