#open "code";;

type tat_du_processeur =
   { registres: int vect;
     mutable pc: int;
     mutable code: instruction vect;
     mutable mmoire: int vect };;

let pico =
  { registres = make_vect nombre_de_registres 0;
    pc = 0;
    code = [| |];
    mmoire = [| |] };;
let lire_registre reg =
    if reg < 0 or reg >= nombre_de_registres then
      raise (Erreur ("registre illgal", reg));
    pico.registres.(reg);;

let crire_registre reg valeur =
    if reg < 0 or reg >= nombre_de_registres then
      raise (Erreur ("registre illgal", reg));
    if reg <> 0 then pico.registres.(reg) <- valeur;;

let lire_instruction adresse =
    let adr = adresse/taille_du_mot in
    if adr < 0 or adr >= vect_length pico.code then
      raise (Erreur ("sortie de la zone code", adr));
    if adresse mod taille_du_mot <> 0 then
      raise (Erreur ("pc non align", adresse));
    pico.code.(adr);;

let lire_mmoire adresse =
    let adr = adresse/taille_du_mot in
    if adr < 0 or adr >= vect_length pico.mmoire then
      raise (Erreur ("lecture en dehors de la mmoire", adresse));
    if adresse mod taille_du_mot <> 0 then
      raise (Erreur ("lecture non aligne", adresse));
    pico.mmoire.(adr);;

let crire_mmoire adresse valeur =
    let adr = adresse/taille_du_mot in
    if adr < 0 or adr >= vect_length pico.mmoire then
      raise (Erreur ("criture en dehors de la mmoire", adresse));
    if adresse mod taille_du_mot <> 0 then
      raise (Erreur ("criture non aligne", adresse));
    pico.mmoire.(adr) <- valeur;;

let valeur_oprande = function
    Reg r -> lire_registre r
  | Imm n -> n;;
let tableau_des_appels_systme =
  make_vect 10 ((function x -> x) : int -> int);;

let excute_appel_systme appel argument =
    if appel < 0 or appel >= vect_length tableau_des_appels_systme
     then raise(Erreur("mauvais appel systme", appel))
     else tableau_des_appels_systme.(appel) argument;;
exception Arrt;;

let cycle_d'horloge () =
  let instruction = lire_instruction pico.pc in
  pico.pc <- pico.pc + taille_du_mot;
  match instruction with
    Op(opration, reg1, oprande, reg2) ->
      let arg1 = lire_registre reg1
      and old2 = lire_registre reg2
      and arg2 = valeur_oprande oprande in
      begin match opration with
        Load  -> crire_registre reg2 (lire_mmoire (arg1 + arg2))
      | Store -> crire_mmoire (arg1 + arg2) (lire_registre reg2)
      | Add   -> crire_registre reg2 (arg1 + arg2)
      | Mult  -> crire_registre reg2 (arg1 * arg2)
      | Sub   -> crire_registre reg2 (arg1 - arg2)
      | Div   -> if arg2 = 0
                 then raise (Erreur("division par zro", pico.pc-1))
                 else crire_registre reg2 (arg1 / arg2)
      | And   -> crire_registre reg2 (arg1 land arg2)
      | Or    -> crire_registre reg2 (arg1 lor arg2)
      | Xor   -> crire_registre reg2 (arg1 lxor arg2)
      | Shl   -> crire_registre reg2 (arg1 lsl arg2)
      | Shr   -> crire_registre reg2 (arg1 asr arg2)
      | Slt   -> crire_registre reg2 (if arg1 < arg2 then 2 else 0)
      | Sle   -> crire_registre reg2 (if arg1 <= arg2 then 2 else 0)
      | Seq   -> crire_registre reg2 (if arg1 = arg2 then 2 else 0)
      end
  | Jmp(oprande, reg) ->
      crire_registre reg pico.pc;
      pico.pc <- valeur_oprande oprande
  | Braz(reg, adresse) ->
      if lire_registre reg = 0 then pico.pc <- adresse
  | Branz(reg, adresse) ->
      if lire_registre reg <> 0 then pico.pc <- adresse
  | Scall(appel_systme) ->
      crire_registre 1
        (excute_appel_systme appel_systme (lire_registre 1))
  | Stop -> raise Arrt;;
let excute programme taille_mmoire_en_octets =
    let taille_mmoire_en_mots = (taille_mmoire_en_octets + 3) / 4 in
    pico.code <- programme;
    pico.mmoire <- make_vect taille_mmoire_en_mots 0;
    pico.registres.(0) <- 0;
    pico.registres.(sp) <- taille_mmoire_en_mots * taille_du_mot;
    pico.pc <- 0;
    try while true do cycle_d'horloge() done
    with Arrt -> ();;

let appel_systme_read _ =
    print_string "? "; flush std_out;
    try read_int()
    with Failure _ -> raise (Erreur ("erreur de lecture", 1))

and appel_systme_write argument =
    print_int argument; print_newline(); argument;;

tableau_des_appels_systme.(0) <- appel_systme_read;
tableau_des_appels_systme.(1) <- appel_systme_write;;
