exception Mauvais_suffixe;;

let enlve_suffixe_cpr chane =
  let longueur = string_length chane in
  if longueur < 4 or sub_string chane (longueur - 4) 4 <> ".cpr"
  then raise Mauvais_suffixe
  else sub_string chane 0 (longueur - 4);;
#open "sys";;
exception Erreur;;
let erreur = ref false;;
for i = 1 to vect_length command_line - 1 do
  let (nom_entre, nom_sortie) =
    try
      (command_line.(i), enlve_suffixe_cpr command_line.(i))
    with Mauvais_suffixe ->
      (command_line.(i) ^ ".cpr", command_line.(i)) in
  try
    let entre =
      try
        open_in_bin nom_entre
      with Sys_error message ->
        prerr_endline
          ("Erreur  l'ouverture de " ^ nom_entre ^ " : " ^ message);
        raise Erreur in
    let sortie =
      try
        open_out_bin nom_sortie
      with Sys_error message ->
        close_in entre;
        prerr_endline
          ("Erreur  la cration de " ^ nom_sortie ^ " : " ^ message);
        raise Erreur in
    try
      huffman__dcompresse entre sortie;
      close_in entre; close_out sortie; remove nom_entre
    with Sys_error message ->
      close_in entre; close_out sortie; remove nom_sortie;
      prerr_endline
        ("Erreur pendant la compression de " ^ nom_entre ^ " : " ^ message);
      raise Erreur
  with Erreur ->
    erreur := true
done;
exit (if !erreur then 2 else 0);;
