;; Eulisp Module
;; Author: pab
;; File: table.em
;; Date: Wed Jun 30 12:46:18 1993
;;
;; Project:
;; Description: 
;;

(defmodule table
  (gens init extras0 macros0 defs
	)
  ()
  
  (export tablep table-ref setter-table-ref)

  (defpredicate tablep <table>)

  (defgeneric table-ref (table key)
    method (((x <table>) key)
	    (sys-table-ref x key)))

  (defgeneric setter-table-ref (table key value)
    method (((x <table>) key value)
	    ((setter sys-table-ref) x key value)))
  
  ((setter setter) table-ref setter-table-ref)

  (defmethod initial-state ((t <table>)) (table-keys t))

  (defmethod next-state ((t <table>) (s <null>)) ())

  (defmethod next-state ((t <table>) (s <pair>)) (cdr s))

  (defmethod final-state ((t <table>)) (table-keys t))

  (defmethod previous-state ((t <table>) (s <null>)) ())

  (defmethod previous-state ((t <table>) (s <pair>)) (cdr s))

  (defmethod current-element ((t <table>) (s <pair>)) (table-ref t (car s)))

  (defmethod current-key ((t <table>) (s <pair>)) (car s))

  (defmethod key-sequence ((t <table>)) (table-keys t))

  (defmethod element ((t <table>) k)
    (table-ref t k))

  (defmethod (setter element) ((t <table>) k v)
    ((setter table-ref) t k v))

  (defmethod size ((t <table>)) (table-population t))

  (defmethod clone ((tab <table>))
    (make <table> 
	  'hash-function (table-hash-function tab)
	  'comparator (table-comparator tab)))



  ;; end module
  )
