;; Eulisp Module
;; Author: pab
;; File: safe.em
;; Date: Tue Jul  6 15:27:08 1993
;;
;; Project:
;; Description: 
;;

(defmodule safe
  ((rename ((car xcar)
	    (cdr xcdr)
	    (vector-ref xvector-ref))
	   init)
   (only (vector-ref) vectors))
  ()
  
  (export car cdr vector-ref)

  (defun car (x) 
    (if (consp x) (xcar x)
      (error "Car: Not a list" Internal-Error 'error-value x)))

  (defun cdr (x) 
    (if (consp x) (xcdr x)
      (error "Cdr: Not a list" Internal-Error 'error-value x)))

  ;; end module
  )
