;; Eulisp Module
;; Author: pab
;; File: read2.em
;; Date: Tue Nov  3 23:09:24 1992
;;
;; Project:
;; Description: 
;;

(defmodule read2
        (standard0
         list-fns
         
         )
        ()
       
  (defun safe-read (stream)
    (labels ((get-list (stream last-pair)
		       (let ((next (safe-read stream)))
			 (format t "Reading: ~a to ~a~%" next last-pair)
			 (cond ((eq next list-end-symbol)
				nil)
			       ((eq next list-improper-symbol)
				(let* ((next-1 (safe-read stream))
				       (next-2 (safe-read stream)))
				  (if (not (eq next-2 list-end-symbol))
				      (error "Misplaced dot causing error" read-error)
				    ((setter cdr) last-pair next-1))))
			       (t (let ((new-last (cons next nil)))
				    ((setter cdr) last-pair new-last)
				    (get-list stream new-last))))))
	     (start-list (stream)
			 (let ((next (read stream)))
			   (cond ((eq next list-start-symbol)
				  (let ((first-pair (cons (start-list stream) nil)))
				    (get-list stream first-pair)
				    first-pair))
				 ((eq next list-end-symbol)
				  (let ((first-pair (cons nil nil)))
				    (get-list stream first-pair)
				    first-pair))
				 ((eq next list-improper-symbol)
				  (error "improper list" read-error))
				 ((eq next vector-start-symbol)
				  ...)
				 ((eq (obj-type next) wrapper)
				  ...)
				 (t (let ((first-pair (cons next nil)))
				      (get-list stream first-pair)
				      first-pair))))))
	    (let ((obj (read stream)))
	      (cond ((eq obj list-start-symbol)
		     (start-list stream))
		    ((eq (obj-type obj) wrapper)
		     (list obj (safe-read stream)))
		    ((eq obj vector-start-symbol)
		     ;; should make sure that no dotted pairs are returned...
		     (convert (start-list stream) vector))
		    ((eq obj close-paren)
		     (error 'extra parenthisis ignored))
		    (t obj)))))
      ;; end module
      )

